// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.lib.security.bcrypter;

/**
 * WireParams represents the wire format of the public parameters
 * of an identity provider (aka Root).
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/lib/security/bcrypter.WireParams")
public class WireParams extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Blessing", index = 0)
  private java.lang.String blessing;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Params", index = 1)
  private byte[] params;

  /**
   * Vdl type for {@link WireParams}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireParams.class);

  /**
   * Creates a new zero-value instance of {@link WireParams}.
   */
  public WireParams() {
    super(VDL_TYPE);

    this.blessing = "";

    this.params = new byte[] {};
  }

  /**
   * Creates a new instance of {@link WireParams} with the provided field values.
   */
  public WireParams(java.lang.String blessing, byte[] params) {
    super(VDL_TYPE);

    this.blessing = blessing;

    this.params = params;
  }

  /**
   * Blessing is the blessing name of the identity provider. The identity
   * provider  can extract private keys for blessings that are extensions
   * of this blessing name.
   */
  public java.lang.String getBlessing() {
    return this.blessing;
  }

  /**
   * Blessing is the blessing name of the identity provider. The identity
   * provider  can extract private keys for blessings that are extensions
   * of this blessing name.
   */
  public void setBlessing(java.lang.String blessing) {
    this.blessing = blessing;
  }

  /**
   * Params is the marshaled form of the public IBE params of the
   * the identity provider.
   */
  public byte[] getParams() {
    return this.params;
  }

  /**
   * Params is the marshaled form of the public IBE params of the
   * the identity provider.
   */
  public void setParams(byte[] params) {
    this.params = params;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WireParams other = (WireParams) obj;

    if (this.blessing == null) {
      if (other.blessing != null) {
        return false;
      }
    } else if (!this.blessing.equals(other.blessing)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.params, other.params)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.blessing == null ? 0 : this.blessing.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.params);

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "blessing:" + this.blessing;

    result += ", ";

    result += "params:" + java.util.Arrays.toString(this.params);

    return result + "}";
  }
}
