// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.lib.security.bcrypter;

/**
 * WireCiphertext represents the wire format of the ciphertext
 * generated by a Crypter.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/lib/security/bcrypter.WireCiphertext")
public class WireCiphertext extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PatternId", index = 0)
  private java.lang.String patternId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Bytes", index = 1)
  private java.util.Map<java.lang.String, byte[]> bytes;

  /**
   * Vdl type for {@link WireCiphertext}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireCiphertext.class);

  /**
   * Creates a new zero-value instance of {@link WireCiphertext}.
   */
  public WireCiphertext() {
    super(VDL_TYPE);

    this.patternId = "";

    this.bytes = new java.util.HashMap<java.lang.String, byte[]>();
  }

  /**
   * Creates a new instance of {@link WireCiphertext} with the provided field values.
   */
  public WireCiphertext(java.lang.String patternId, java.util.Map<java.lang.String, byte[]> bytes) {
    super(VDL_TYPE);

    this.patternId = patternId;

    this.bytes = bytes;
  }

  /**
   * PatternId is an identifier of the blessing pattern that this
   * ciphertext is for. It is represented by a 16 byte truncated
   * SHA256 hash of the pattern.
   */
  public java.lang.String getPatternId() {
    return this.patternId;
  }

  /**
   * PatternId is an identifier of the blessing pattern that this
   * ciphertext is for. It is represented by a 16 byte truncated
   * SHA256 hash of the pattern.
   */
  public void setPatternId(java.lang.String patternId) {
    this.patternId = patternId;
  }

  /**
   * Bytes is a map from an identifier of the public IBE params to
   * the ciphertext bytes that were generated using those params.
   *<p>
   * The params identifier is a 16 byte truncated SHA256 hash
   * of the marshaled form of the IBE params.
   */
  public java.util.Map<java.lang.String, byte[]> getBytes() {
    return this.bytes;
  }

  /**
   * Bytes is a map from an identifier of the public IBE params to
   * the ciphertext bytes that were generated using those params.
   *<p>
   * The params identifier is a 16 byte truncated SHA256 hash
   * of the marshaled form of the IBE params.
   */
  public void setBytes(java.util.Map<java.lang.String, byte[]> bytes) {
    this.bytes = bytes;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WireCiphertext other = (WireCiphertext) obj;

    if (this.patternId == null) {
      if (other.patternId != null) {
        return false;
      }
    } else if (!this.patternId.equals(other.patternId)) {
      return false;
    }

    if (this.bytes == null) {
      if (other.bytes != null) {
        return false;
      }
    } else if (!this.bytes.equals(other.bytes)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.patternId == null ? 0 : this.patternId.hashCode());

    result = prime * result + (this.bytes == null ? 0 : this.bytes.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "patternId:" + this.patternId;

    result += ", ";

    result += "bytes:" + this.bytes;

    return result + "}";
  }
}
