// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: type.vdl
package io.v.x.ref.lib.security;

@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/lib/security.blessingStoreState")
class BlessingStoreState extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PeerBlessings", index = 0)
  private java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>
      peerBlessings;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DefaultBlessings", index = 1)
  private io.v.v23.security.Blessings defaultBlessings;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DischargeCache", index = 2)
  private java.util.Map<io.v.x.ref.lib.security.DischargeCacheKey, io.v.v23.security.Discharge>
      dischargeCache;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Discharges", index = 3)
  private java.util.Map<
          io.v.x.ref.lib.security.DischargeCacheKey, io.v.x.ref.lib.security.CachedDischarge>
      discharges;

  @io.v.v23.vdl.GeneratedFromVdl(name = "CacheKeyFormat", index = 4)
  private io.v.v23.vdl.VdlUint32 cacheKeyFormat;

  /**
   * Vdl type for {@link BlessingStoreState}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(BlessingStoreState.class);

  /**
   * Creates a new zero-value instance of {@link BlessingStoreState}.
   */
  public BlessingStoreState() {
    super(VDL_TYPE);

    this.peerBlessings =
        new java.util.HashMap<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>();

    this.defaultBlessings = null;

    this.dischargeCache =
        new java.util.HashMap<
            io.v.x.ref.lib.security.DischargeCacheKey, io.v.v23.security.Discharge>();

    this.discharges =
        new java.util.HashMap<
            io.v.x.ref.lib.security.DischargeCacheKey, io.v.x.ref.lib.security.CachedDischarge>();

    this.cacheKeyFormat = new io.v.v23.vdl.VdlUint32();
  }

  /**
   * Creates a new instance of {@link BlessingStoreState} with the provided field values.
   */
  public BlessingStoreState(
      java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings> peerBlessings,
      io.v.v23.security.Blessings defaultBlessings,
      java.util.Map<io.v.x.ref.lib.security.DischargeCacheKey, io.v.v23.security.Discharge>
          dischargeCache,
      java.util.Map<
              io.v.x.ref.lib.security.DischargeCacheKey, io.v.x.ref.lib.security.CachedDischarge>
          discharges,
      io.v.v23.vdl.VdlUint32 cacheKeyFormat) {
    super(VDL_TYPE);

    this.peerBlessings = peerBlessings;

    this.defaultBlessings = defaultBlessings;

    this.dischargeCache = dischargeCache;

    this.discharges = discharges;

    this.cacheKeyFormat = cacheKeyFormat;
  }

  /**
   * PeerBlessings maps BlessingPatterns to the Blessings object that is to
   * be shared with peers which present blessings of their own that match the
   * pattern.
   *<p>
   * All blessings bind to the same public key.
   */
  public java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>
      getPeerBlessings() {
    return this.peerBlessings;
  }

  /**
   * PeerBlessings maps BlessingPatterns to the Blessings object that is to
   * be shared with peers which present blessings of their own that match the
   * pattern.
   *<p>
   * All blessings bind to the same public key.
   */
  public void setPeerBlessings(
      java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings> peerBlessings) {
    this.peerBlessings = peerBlessings;
  }

  /**
   * DefaultBlessings is the default Blessings to be shared with peers for which
   * no other information is available to select blessings.
   */
  public io.v.v23.security.Blessings getDefaultBlessings() {
    return this.defaultBlessings;
  }

  /**
   * DefaultBlessings is the default Blessings to be shared with peers for which
   * no other information is available to select blessings.
   */
  public void setDefaultBlessings(io.v.v23.security.Blessings defaultBlessings) {
    this.defaultBlessings = defaultBlessings;
  }

  /**
   * DischargeCache is the cache of discharges.
   * TODO(mattr): This map is deprecated in favor of the Discharges map below.
   */
  public java.util.Map<io.v.x.ref.lib.security.DischargeCacheKey, io.v.v23.security.Discharge>
      getDischargeCache() {
    return this.dischargeCache;
  }

  /**
   * DischargeCache is the cache of discharges.
   * TODO(mattr): This map is deprecated in favor of the Discharges map below.
   */
  public void setDischargeCache(
      java.util.Map<io.v.x.ref.lib.security.DischargeCacheKey, io.v.v23.security.Discharge>
          dischargeCache) {
    this.dischargeCache = dischargeCache;
  }

  /**
   * DischargeCache is the cache of discharges.
   */
  public java.util.Map<
          io.v.x.ref.lib.security.DischargeCacheKey, io.v.x.ref.lib.security.CachedDischarge>
      getDischarges() {
    return this.discharges;
  }

  /**
   * DischargeCache is the cache of discharges.
   */
  public void setDischarges(
      java.util.Map<
              io.v.x.ref.lib.security.DischargeCacheKey, io.v.x.ref.lib.security.CachedDischarge>
          discharges) {
    this.discharges = discharges;
  }

  /**
   * CacheKeyFormat is the dischargeCacheKey format version. It should incremented
   * any time the format of the dischargeCacheKey is changed.
   */
  public io.v.v23.vdl.VdlUint32 getCacheKeyFormat() {
    return this.cacheKeyFormat;
  }

  /**
   * CacheKeyFormat is the dischargeCacheKey format version. It should incremented
   * any time the format of the dischargeCacheKey is changed.
   */
  public void setCacheKeyFormat(io.v.v23.vdl.VdlUint32 cacheKeyFormat) {
    this.cacheKeyFormat = cacheKeyFormat;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    BlessingStoreState other = (BlessingStoreState) obj;

    if (this.peerBlessings == null) {
      if (other.peerBlessings != null) {
        return false;
      }
    } else if (!this.peerBlessings.equals(other.peerBlessings)) {
      return false;
    }

    if (this.defaultBlessings == null) {
      if (other.defaultBlessings != null) {
        return false;
      }
    } else if (!this.defaultBlessings.equals(other.defaultBlessings)) {
      return false;
    }

    if (this.dischargeCache == null) {
      if (other.dischargeCache != null) {
        return false;
      }
    } else if (!this.dischargeCache.equals(other.dischargeCache)) {
      return false;
    }

    if (this.discharges == null) {
      if (other.discharges != null) {
        return false;
      }
    } else if (!this.discharges.equals(other.discharges)) {
      return false;
    }

    if (this.cacheKeyFormat == null) {
      if (other.cacheKeyFormat != null) {
        return false;
      }
    } else if (!this.cacheKeyFormat.equals(other.cacheKeyFormat)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.peerBlessings == null ? 0 : this.peerBlessings.hashCode());

    result =
        prime * result + (this.defaultBlessings == null ? 0 : this.defaultBlessings.hashCode());

    result = prime * result + (this.dischargeCache == null ? 0 : this.dischargeCache.hashCode());

    result = prime * result + (this.discharges == null ? 0 : this.discharges.hashCode());

    result = prime * result + (this.cacheKeyFormat == null ? 0 : this.cacheKeyFormat.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "peerBlessings:" + this.peerBlessings;

    result += ", ";

    result += "defaultBlessings:" + this.defaultBlessings;

    result += ", ";

    result += "dischargeCache:" + this.dischargeCache;

    result += ", ";

    result += "discharges:" + this.discharges;

    result += ", ";

    result += "cacheKeyFormat:" + this.cacheKeyFormat;

    return result + "}";
  }
}
