// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  raft.vdl
package io.v.x.ref.lib.raft;

/**
 * Wrapper for {@link RaftProtoServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class RaftProtoServerWrapper {
  private final io.v.x.ref.lib.raft.RaftProtoServer server;

  /**
   * Creates a new {@link RaftProtoServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public RaftProtoServerWrapper(io.v.x.ref.lib.raft.RaftProtoServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<java.lang.String>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "members",
              "// Members returns the current set of ids of raft members." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "leader",
              "// Leader returns the id of the current leader." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Index.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "requestVote",
              "// RequestVote starts a new round of voting.  It returns the server's current Term and true if"
                  + "// the server voted for the client."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Index.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Index.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.x.ref.lib.raft.LogEntry>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "appendToLog",
              "// AppendToLog is sent by the leader to tell followers to append an entry.  If cmds"
                  + "// is empty, this is a keep alive message (at a random interval after a keep alive, followers"
                  + "// will initiate a new round of voting)."
                  + "//   term -- the current term of the sender"
                  + "//   leaderId -- the id of the sender"
                  + "//   prevIndex -- the index of the log entry immediately preceding cmds"
                  + "//   prevTerm -- the term of the log entry immediately preceding cmds.  The receiver must have"
                  + "//               received the previous index'd entry and it must have had the same term.  Otherwise"
                  + "//               an error is returned."
                  + "//   leaderCommit -- the index of the last committed entry, i.e., the one a quorum has gauranteed"
                  + "//                   to have logged."
                  + "//   cmds -- sequential log entries starting at prevIndex+1"
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg("", "", new io.v.v23.vdl.VdlTypeObject(byte[].class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Index.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "append",
              "// Append is sent to the leader by followers.  Only the leader is allowed to send AppendToLog."
                  + "// If a follower receives an Append() call it performs an Append() to the leader to run the actual"
                  + "// Raft algorithm.  The leader will respond after it has RaftClient.Apply()ed the command."
                  + "//"
                  + "// Returns the term and index of the append entry or an error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Index.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "committed",
              "// Committed returns the commit index of the leader." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Term.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.raft.Index.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "installSnapshot",
              "// InstallSnapshot is sent from the leader to follower to install the given snapshot.  It is"
                  + "// sent when it becomes apparent that the leader does not have log entries needed by the follower"
                  + "// to progress.  'term' and 'index' represent the last LogEntry RaftClient.Apply()ed to the"
                  + "// snapshot."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "RaftProto",
        "io.v.x.ref.lib.raft",
        "// raftProto is used by the members of a raft set to communicate with each other." + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("append".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"append\": %s", e.getMessage()));
      }
    }

    if ("appendToLog".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"appendToLog\": %s", e.getMessage()));
      }
    }

    if ("committed".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"committed\": %s", e.getMessage()));
      }
    }

    if ("installSnapshot".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"installSnapshot\": %s", e.getMessage()));
      }
    }

    if ("leader".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"leader\": %s", e.getMessage()));
      }
    }

    if ("members".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"members\": %s", e.getMessage()));
      }
    }

    if ("requestVote".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"requestVote\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Members returns the current set of ids of raft members.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>>
      members(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.members(_ctx, _call);
  }

  /**
   * Leader returns the id of the current leader.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> leader(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.leader(_ctx, _call);
  }

  /**
   * RequestVote starts a new round of voting.  It returns the server's current Term and true if
   * the server voted for the client.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoServer.RequestVoteOut>
      requestVote(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.x.ref.lib.raft.Term term,
          final java.lang.String candidateId,
          final io.v.x.ref.lib.raft.Term lastLogTerm,
          final io.v.x.ref.lib.raft.Index lastLogIndex) {

    return this.server.requestVote(_ctx, _call, term, candidateId, lastLogTerm, lastLogIndex);
  }

  /**
   * AppendToLog is sent by the leader to tell followers to append an entry.  If cmds
   * is empty, this is a keep alive message (at a random interval after a keep alive, followers
   * will initiate a new round of voting).
   *   term -- the current term of the sender
   *   leaderId -- the id of the sender
   *   prevIndex -- the index of the log entry immediately preceding cmds
   *   prevTerm -- the term of the log entry immediately preceding cmds.  The receiver must have
   *               received the previous index'd entry and it must have had the same term.  Otherwise
   *               an error is returned.
   *   leaderCommit -- the index of the last committed entry, i.e., the one a quorum has gauranteed
   *                   to have logged.
   *   cmds -- sequential log entries starting at prevIndex+1
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> appendToLog(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Index prevIndex,
      final io.v.x.ref.lib.raft.Term prevTerm,
      final io.v.x.ref.lib.raft.Index leaderCommit,
      final java.util.List<io.v.x.ref.lib.raft.LogEntry> cmds) {

    return this
        .server.appendToLog(_ctx, _call, term, leaderId, prevIndex, prevTerm, leaderCommit, cmds);
  }

  /**
   * Append is sent to the leader by followers.  Only the leader is allowed to send AppendToLog.
   * If a follower receives an Append() call it performs an Append() to the leader to run the actual
   * Raft algorithm.  The leader will respond after it has RaftClient.Apply()ed the command.
   *<p>
   * Returns the term and index of the append entry or an error.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoServer.AppendOut>
      append(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final byte[] cmd) {

    return this.server.append(_ctx, _call, cmd);
  }

  /**
   * Committed returns the commit index of the leader.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index> committed(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.committed(_ctx, _call);
  }

  /**
   * InstallSnapshot is sent from the leader to follower to install the given snapshot.  It is
   * sent when it becomes apparent that the leader does not have log entries needed by the follower
   * to progress.  'term' and 'index' represent the last LogEntry RaftClient.Apply()ed to the
   * snapshot.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> installSnapshot(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Term appliedTerm,
      final io.v.x.ref.lib.raft.Index appliedIndex) {

    io.v.v23.vdl.ServerStream<java.lang.Void, byte[]> _stream =
        new io.v.v23.vdl.ServerStream<java.lang.Void, byte[]>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              java.lang.Void _item) {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<byte[]> recv() {
            java.lang.reflect.Type _type = byte[].class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, byte[]>() {
                  @Override
                  public byte[] apply(Object result) {
                    return (byte[]) result;
                  }
                });
          }
        };

    return this
        .server.installSnapshot(_ctx, _call, term, leaderId, appliedTerm, appliedIndex, _stream);
  }
}
