// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  raft.vdl
package io.v.x.ref.lib.raft;

/**
 * Implementation of the {@link RaftProtoClient} interface.
 */
final class RaftProtoClientImpl implements io.v.x.ref.lib.raft.RaftProtoClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link RaftProtoClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public RaftProtoClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface RaftProtoClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>>
      members(io.v.v23.context.VContext _context) {
    return members(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>>
      members(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return members(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>>
      members(final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "members", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.List<java.lang.String>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.List<java.lang.String>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.List<java.lang.String>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.List<java.lang.String>>() {
                      @Override
                      public java.util.List<java.lang.String> apply(Object[] _results) {

                        return (java.util.List<java.lang.String>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> leader(
      io.v.v23.context.VContext _context) {
    return leader(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> leader(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return leader(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> leader(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "leader", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>
      requestVote(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.lib.raft.Term term,
          final java.lang.String candidateId,
          final io.v.x.ref.lib.raft.Term lastLogTerm,
          final io.v.x.ref.lib.raft.Index lastLogIndex) {
    return requestVote(
        _context, term, candidateId, lastLogTerm, lastLogIndex, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>
      requestVote(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.lib.raft.Term term,
          final java.lang.String candidateId,
          final io.v.x.ref.lib.raft.Term lastLogTerm,
          final io.v.x.ref.lib.raft.Index lastLogIndex,
          io.v.v23.Options _opts) {
    return requestVote(
        _context,
        term,
        candidateId,
        lastLogTerm,
        lastLogIndex,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>
      requestVote(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.lib.raft.Term term,
          final java.lang.String candidateId,
          final io.v.x.ref.lib.raft.Term lastLogTerm,
          final io.v.x.ref.lib.raft.Index lastLogIndex,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args =
        new java.lang.Object[] {term, candidateId, lastLogTerm, lastLogIndex};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.x.ref.lib.raft.Term.class,
          java.lang.String.class,
          io.v.x.ref.lib.raft.Term.class,
          io.v.x.ref.lib.raft.Index.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "requestVote", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.lib.raft.Term.class, java.lang.Boolean.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>() {
                      @Override
                      public io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut apply(
                          Object[] _results) {

                        io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut _ret =
                            new io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut();

                        _ret.term = (io.v.x.ref.lib.raft.Term) _results[0];

                        _ret.granted = (java.lang.Boolean) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> appendToLog(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Index prevIndex,
      final io.v.x.ref.lib.raft.Term prevTerm,
      final io.v.x.ref.lib.raft.Index leaderCommit,
      final java.util.List<io.v.x.ref.lib.raft.LogEntry> cmds) {
    return appendToLog(
        _context,
        term,
        leaderId,
        prevIndex,
        prevTerm,
        leaderCommit,
        cmds,
        (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> appendToLog(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Index prevIndex,
      final io.v.x.ref.lib.raft.Term prevTerm,
      final io.v.x.ref.lib.raft.Index leaderCommit,
      final java.util.List<io.v.x.ref.lib.raft.LogEntry> cmds,
      io.v.v23.Options _opts) {
    return appendToLog(
        _context,
        term,
        leaderId,
        prevIndex,
        prevTerm,
        leaderCommit,
        cmds,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> appendToLog(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Index prevIndex,
      final io.v.x.ref.lib.raft.Term prevTerm,
      final io.v.x.ref.lib.raft.Index leaderCommit,
      final java.util.List<io.v.x.ref.lib.raft.LogEntry> cmds,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args =
        new java.lang.Object[] {term, leaderId, prevIndex, prevTerm, leaderCommit, cmds};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.x.ref.lib.raft.Term.class,
          java.lang.String.class,
          io.v.x.ref.lib.raft.Index.class,
          io.v.x.ref.lib.raft.Term.class,
          io.v.x.ref.lib.raft.Index.class,
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.x.ref.lib.raft.LogEntry>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "appendToLog", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>
      append(io.v.v23.context.VContext _context, final byte[] cmd) {
    return append(_context, cmd, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>
      append(final io.v.v23.context.VContext _context, final byte[] cmd, io.v.v23.Options _opts) {
    return append(_context, cmd, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>
      append(
          final io.v.v23.context.VContext _context,
          final byte[] cmd,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {cmd};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {byte[].class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "append", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.lib.raft.Term.class, io.v.x.ref.lib.raft.Index.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>() {
                      @Override
                      public io.v.x.ref.lib.raft.RaftProtoClient.AppendOut apply(
                          Object[] _results) {

                        io.v.x.ref.lib.raft.RaftProtoClient.AppendOut _ret =
                            new io.v.x.ref.lib.raft.RaftProtoClient.AppendOut();

                        _ret.term = (io.v.x.ref.lib.raft.Term) _results[0];

                        _ret.index = (io.v.x.ref.lib.raft.Index) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index> committed(
      io.v.v23.context.VContext _context) {
    return committed(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index> committed(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return committed(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index> committed(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "committed", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.ref.lib.raft.Index>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.lib.raft.Index.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.x.ref.lib.raft.Index>() {
                      @Override
                      public io.v.x.ref.lib.raft.Index apply(Object[] _results) {

                        return (io.v.x.ref.lib.raft.Index) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> installSnapshot(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Term appliedTerm,
      final io.v.x.ref.lib.raft.Index appliedIndex) {
    return installSnapshot(
        _context, term, leaderId, appliedTerm, appliedIndex, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> installSnapshot(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Term appliedTerm,
      final io.v.x.ref.lib.raft.Index appliedIndex,
      io.v.v23.Options _opts) {
    return installSnapshot(
        _context,
        term,
        leaderId,
        appliedTerm,
        appliedIndex,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> installSnapshot(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Term appliedTerm,
      final io.v.x.ref.lib.raft.Index appliedIndex,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {term, leaderId, appliedTerm, appliedIndex};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.x.ref.lib.raft.Term.class,
          java.lang.String.class,
          io.v.x.ref.lib.raft.Term.class,
          io.v.x.ref.lib.raft.Index.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "installSnapshot", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<byte[], java.lang.Void, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(final byte[] item) {
        final java.lang.reflect.Type type = byte[].class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
        final java.lang.reflect.Type recvType = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object result) {
                            return (java.lang.Void) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }
}
