// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: raft.vdl
package io.v.x.ref.lib.raft;

/**
 * raftProto is used by the members of a raft set to communicate with each other.
 */
public interface RaftProtoClient {

  /**
   * Members returns the current set of ids of raft members.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>> members(
      io.v.v23.context.VContext context);

  /**
   * Members returns the current set of ids of raft members.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>> members(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Members returns the current set of ids of raft members.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>> members(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Leader returns the id of the current leader.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> leader(
      io.v.v23.context.VContext context);

  /**
   * Leader returns the id of the current leader.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> leader(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Leader returns the id of the current leader.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> leader(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Multi-return value for method {@link #requestVote}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class RequestVoteOut {

    public io.v.x.ref.lib.raft.Term term;

    public boolean granted;
  }

  /**
   * RequestVote starts a new round of voting.  It returns the server's current Term and true if
   * the server voted for the client.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>
      requestVote(
          io.v.v23.context.VContext context,
          final io.v.x.ref.lib.raft.Term term,
          final java.lang.String candidateId,
          final io.v.x.ref.lib.raft.Term lastLogTerm,
          final io.v.x.ref.lib.raft.Index lastLogIndex);

  /**
   * RequestVote starts a new round of voting.  It returns the server's current Term and true if
   * the server voted for the client.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>
      requestVote(
          io.v.v23.context.VContext context,
          final io.v.x.ref.lib.raft.Term term,
          final java.lang.String candidateId,
          final io.v.x.ref.lib.raft.Term lastLogTerm,
          final io.v.x.ref.lib.raft.Index lastLogIndex,
          io.v.v23.Options opts);

  /**
   * RequestVote starts a new round of voting.  It returns the server's current Term and true if
   * the server voted for the client.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.raft.RaftProtoClient.RequestVoteOut>
      requestVote(
          io.v.v23.context.VContext context,
          final io.v.x.ref.lib.raft.Term term,
          final java.lang.String candidateId,
          final io.v.x.ref.lib.raft.Term lastLogTerm,
          final io.v.x.ref.lib.raft.Index lastLogIndex,
          io.v.v23.options.RpcOptions opts);

  /**
   * AppendToLog is sent by the leader to tell followers to append an entry.  If cmds
   * is empty, this is a keep alive message (at a random interval after a keep alive, followers
   * will initiate a new round of voting).
   *   term -- the current term of the sender
   *   leaderId -- the id of the sender
   *   prevIndex -- the index of the log entry immediately preceding cmds
   *   prevTerm -- the term of the log entry immediately preceding cmds.  The receiver must have
   *               received the previous index'd entry and it must have had the same term.  Otherwise
   *               an error is returned.
   *   leaderCommit -- the index of the last committed entry, i.e., the one a quorum has gauranteed
   *                   to have logged.
   *   cmds -- sequential log entries starting at prevIndex+1
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> appendToLog(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Index prevIndex,
      final io.v.x.ref.lib.raft.Term prevTerm,
      final io.v.x.ref.lib.raft.Index leaderCommit,
      final java.util.List<io.v.x.ref.lib.raft.LogEntry> cmds);

  /**
   * AppendToLog is sent by the leader to tell followers to append an entry.  If cmds
   * is empty, this is a keep alive message (at a random interval after a keep alive, followers
   * will initiate a new round of voting).
   *   term -- the current term of the sender
   *   leaderId -- the id of the sender
   *   prevIndex -- the index of the log entry immediately preceding cmds
   *   prevTerm -- the term of the log entry immediately preceding cmds.  The receiver must have
   *               received the previous index'd entry and it must have had the same term.  Otherwise
   *               an error is returned.
   *   leaderCommit -- the index of the last committed entry, i.e., the one a quorum has gauranteed
   *                   to have logged.
   *   cmds -- sequential log entries starting at prevIndex+1
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> appendToLog(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Index prevIndex,
      final io.v.x.ref.lib.raft.Term prevTerm,
      final io.v.x.ref.lib.raft.Index leaderCommit,
      final java.util.List<io.v.x.ref.lib.raft.LogEntry> cmds,
      io.v.v23.Options opts);

  /**
   * AppendToLog is sent by the leader to tell followers to append an entry.  If cmds
   * is empty, this is a keep alive message (at a random interval after a keep alive, followers
   * will initiate a new round of voting).
   *   term -- the current term of the sender
   *   leaderId -- the id of the sender
   *   prevIndex -- the index of the log entry immediately preceding cmds
   *   prevTerm -- the term of the log entry immediately preceding cmds.  The receiver must have
   *               received the previous index'd entry and it must have had the same term.  Otherwise
   *               an error is returned.
   *   leaderCommit -- the index of the last committed entry, i.e., the one a quorum has gauranteed
   *                   to have logged.
   *   cmds -- sequential log entries starting at prevIndex+1
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> appendToLog(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Index prevIndex,
      final io.v.x.ref.lib.raft.Term prevTerm,
      final io.v.x.ref.lib.raft.Index leaderCommit,
      final java.util.List<io.v.x.ref.lib.raft.LogEntry> cmds,
      io.v.v23.options.RpcOptions opts);

  /**
   * Multi-return value for method {@link #append}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class AppendOut {

    public io.v.x.ref.lib.raft.Term term;

    public io.v.x.ref.lib.raft.Index index;
  }

  /**
   * Append is sent to the leader by followers.  Only the leader is allowed to send AppendToLog.
   * If a follower receives an Append() call it performs an Append() to the leader to run the actual
   * Raft algorithm.  The leader will respond after it has RaftClient.Apply()ed the command.
   *<p>
   * Returns the term and index of the append entry or an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>
      append(io.v.v23.context.VContext context, final byte[] cmd);

  /**
   * Append is sent to the leader by followers.  Only the leader is allowed to send AppendToLog.
   * If a follower receives an Append() call it performs an Append() to the leader to run the actual
   * Raft algorithm.  The leader will respond after it has RaftClient.Apply()ed the command.
   *<p>
   * Returns the term and index of the append entry or an error.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>
      append(io.v.v23.context.VContext context, final byte[] cmd, io.v.v23.Options opts);

  /**
   * Append is sent to the leader by followers.  Only the leader is allowed to send AppendToLog.
   * If a follower receives an Append() call it performs an Append() to the leader to run the actual
   * Raft algorithm.  The leader will respond after it has RaftClient.Apply()ed the command.
   *<p>
   * Returns the term and index of the append entry or an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.RaftProtoClient.AppendOut>
      append(io.v.v23.context.VContext context, final byte[] cmd, io.v.v23.options.RpcOptions opts);

  /**
   * Committed returns the commit index of the leader.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index> committed(
      io.v.v23.context.VContext context);

  /**
   * Committed returns the commit index of the leader.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index> committed(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Committed returns the commit index of the leader.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.raft.Index> committed(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * InstallSnapshot is sent from the leader to follower to install the given snapshot.  It is
   * sent when it becomes apparent that the leader does not have log entries needed by the follower
   * to progress.  'term' and 'index' represent the last LogEntry RaftClient.Apply()ed to the
   * snapshot.
   */
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> installSnapshot(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Term appliedTerm,
      final io.v.x.ref.lib.raft.Index appliedIndex);

  /**
   * InstallSnapshot is sent from the leader to follower to install the given snapshot.  It is
   * sent when it becomes apparent that the leader does not have log entries needed by the follower
   * to progress.  'term' and 'index' represent the last LogEntry RaftClient.Apply()ed to the
   * snapshot.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> installSnapshot(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Term appliedTerm,
      final io.v.x.ref.lib.raft.Index appliedIndex,
      io.v.v23.Options opts);

  /**
   * InstallSnapshot is sent from the leader to follower to install the given snapshot.  It is
   * sent when it becomes apparent that the leader does not have log entries needed by the follower
   * to progress.  'term' and 'index' represent the last LogEntry RaftClient.Apply()ed to the
   * snapshot.
   */
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> installSnapshot(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.raft.Term term,
      final java.lang.String leaderId,
      final io.v.x.ref.lib.raft.Term appliedTerm,
      final io.v.x.ref.lib.raft.Index appliedIndex,
      io.v.v23.options.RpcOptions opts);
}
