// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: raft.vdl
package io.v.x.ref.lib.raft;

/**
 * The LogEntry is what the log consists of.  'error' starts nil and is never written to stable
 * storage.  It represents the result of RaftClient.Apply(Cmd, Index).  This is a hack but I
 * haven't figured out a better way.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/lib/raft.LogEntry")
public class LogEntry extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Term", index = 0)
  private io.v.x.ref.lib.raft.Term term;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Index", index = 1)
  private io.v.x.ref.lib.raft.Index index;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Cmd", index = 2)
  private byte[] cmd;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Type", index = 3)
  private byte type;

  /**
   * Vdl type for {@link LogEntry}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(LogEntry.class);

  /**
   * Creates a new zero-value instance of {@link LogEntry}.
   */
  public LogEntry() {
    super(VDL_TYPE);

    this.term = new io.v.x.ref.lib.raft.Term();

    this.index = new io.v.x.ref.lib.raft.Index();

    this.cmd = new byte[] {};

    this.type = (byte) 0;
  }

  /**
   * Creates a new instance of {@link LogEntry} with the provided field values.
   */
  public LogEntry(
      io.v.x.ref.lib.raft.Term term, io.v.x.ref.lib.raft.Index index, byte[] cmd, byte type) {
    super(VDL_TYPE);

    this.term = term;

    this.index = index;

    this.cmd = cmd;

    this.type = type;
  }

  public io.v.x.ref.lib.raft.Term getTerm() {
    return this.term;
  }

  public void setTerm(io.v.x.ref.lib.raft.Term term) {
    this.term = term;
  }

  public io.v.x.ref.lib.raft.Index getIndex() {
    return this.index;
  }

  public void setIndex(io.v.x.ref.lib.raft.Index index) {
    this.index = index;
  }

  public byte[] getCmd() {
    return this.cmd;
  }

  public void setCmd(byte[] cmd) {
    this.cmd = cmd;
  }

  public byte getType() {
    return this.type;
  }

  public void setType(byte type) {
    this.type = type;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    LogEntry other = (LogEntry) obj;

    if (this.term == null) {
      if (other.term != null) {
        return false;
      }
    } else if (!this.term.equals(other.term)) {
      return false;
    }

    if (this.index == null) {
      if (other.index != null) {
        return false;
      }
    } else if (!this.index.equals(other.index)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.cmd, other.cmd)) {
      return false;
    }

    if (this.type != other.type) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.term == null ? 0 : this.term.hashCode());

    result = prime * result + (this.index == null ? 0 : this.index.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.cmd);

    result = prime * result + (int) this.type;

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "term:" + this.term;

    result += ", ";

    result += "index:" + this.index;

    result += ", ";

    result += "cmd:" + java.util.Arrays.toString(this.cmd);

    result += ", ";

    result += "type:" + this.type;

    return result + "}";
  }
}
