// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: encoding.vdl
package io.v.x.ref.lib.discovery.testdata;

/**
 * PackEncryptionKeysTest represents a test case for PackEncryptionKeys
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/lib/discovery/testdata.PackEncryptionKeysTest")
public class PackEncryptionKeysTest extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Algo", index = 0)
  private io.v.x.ref.lib.discovery.EncryptionAlgorithm algo;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Keys", index = 1)
  private java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> keys;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Packed", index = 2)
  private byte[] packed;

  /**
   * Vdl type for {@link PackEncryptionKeysTest}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(PackEncryptionKeysTest.class);

  /**
   * Creates a new zero-value instance of {@link PackEncryptionKeysTest}.
   */
  public PackEncryptionKeysTest() {
    super(VDL_TYPE);

    this.algo = new io.v.x.ref.lib.discovery.EncryptionAlgorithm();

    this.keys = new java.util.ArrayList<io.v.x.ref.lib.discovery.EncryptionKey>();

    this.packed = new byte[] {};
  }

  /**
   * Creates a new instance of {@link PackEncryptionKeysTest} with the provided field values.
   */
  public PackEncryptionKeysTest(
      io.v.x.ref.lib.discovery.EncryptionAlgorithm algo,
      java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> keys,
      byte[] packed) {
    super(VDL_TYPE);

    this.algo = algo;

    this.keys = keys;

    this.packed = packed;
  }

  /**
   * Algo is the algorithm that's in use.
   * but that isn't defined in vdl yet.
   */
  public io.v.x.ref.lib.discovery.EncryptionAlgorithm getAlgo() {
    return this.algo;
  }

  /**
   * Algo is the algorithm that's in use.
   * but that isn't defined in vdl yet.
   */
  public void setAlgo(io.v.x.ref.lib.discovery.EncryptionAlgorithm algo) {
    this.algo = algo;
  }

  /**
   * Keys are the encryption keys.
   * but that isn't defined in vdl yet.
   */
  public java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> getKeys() {
    return this.keys;
  }

  /**
   * Keys are the encryption keys.
   * but that isn't defined in vdl yet.
   */
  public void setKeys(java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> keys) {
    this.keys = keys;
  }

  /**
   * Packed is the expected output bytes.
   */
  public byte[] getPacked() {
    return this.packed;
  }

  /**
   * Packed is the expected output bytes.
   */
  public void setPacked(byte[] packed) {
    this.packed = packed;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    PackEncryptionKeysTest other = (PackEncryptionKeysTest) obj;

    if (this.algo == null) {
      if (other.algo != null) {
        return false;
      }
    } else if (!this.algo.equals(other.algo)) {
      return false;
    }

    if (this.keys == null) {
      if (other.keys != null) {
        return false;
      }
    } else if (!this.keys.equals(other.keys)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.packed, other.packed)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.algo == null ? 0 : this.algo.hashCode());

    result = prime * result + (this.keys == null ? 0 : this.keys.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.packed);

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "algo:" + this.algo;

    result += ", ";

    result += "keys:" + this.keys;

    result += ", ";

    result += "packed:" + java.util.Arrays.toString(this.packed);

    return result + "}";
  }
}
