// Copyright 2016 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  store.vdl
package io.v.x.ref.lib.discovery.plugins.vine;

/**
 * Wrapper for {@link StoreServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class StoreServerWrapper {
  private final io.v.x.ref.lib.discovery.plugins.vine.StoreServer server;

  /**
   * Creates a new {@link StoreServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public StoreServerWrapper(io.v.x.ref.lib.discovery.plugins.vine.StoreServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.discovery.AdInfo.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(org.joda.time.Duration.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "add",
              "// Add adds an advertisement with a given ttl." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.discovery.AdId.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "delete",
              "// Delete deletes the advertisement from the store." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Store",
        "io.v.x.ref.lib.discovery.plugins.vine",
        "// Store is the interface for sharing advertisements between vine plugins." + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("add".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"add\": %s", e.getMessage()));
      }
    }

    if ("delete".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Add adds an advertisement with a given ttl.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.x.ref.lib.discovery.AdInfo adinfo,
      final org.joda.time.Duration ttl) {

    return this.server.add(_ctx, _call, adinfo, ttl);
  }

  /**
   * Delete deletes the advertisement from the store.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.discovery.AdId id) {

    return this.server.delete(_ctx, _call, id);
  }
}
