// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  directory.vdl
package io.v.x.ref.lib.discovery;

/**
 * Wrapper for {@link DirectoryServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class DirectoryServerWrapper {
  private final io.v.x.ref.lib.discovery.DirectoryServer server;

  /**
   * Creates a new {@link DirectoryServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public DirectoryServerWrapper(io.v.x.ref.lib.discovery.DirectoryServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.discovery.AdId.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.discovery.AdInfo.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "lookup",
              "// Lookup returns the advertisement of the given service instance."
                  + "//"
                  + "// The returned advertisement may not include all attachments."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.discovery.AdId.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg("", "", new io.v.v23.vdl.VdlTypeObject(byte[].class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getAttachment",
              "// GetAttachment returns the named attachment. Accessing non-existent attachment"
                  + "// is not an error - nil data is returned if not found."
                  + "//"
                  + "// TODO(jhahn): Consider to return an error if not found."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Directory",
        "io.v.x.ref.lib.discovery",
        "// Directory is the interface for advertisement directory service." + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("getAttachment".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getAttachment\": %s", e.getMessage()));
      }
    }

    if ("lookup".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"lookup\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Lookup returns the advertisement of the given service instance.
   *<p>
   * The returned advertisement may not include all attachments.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.discovery.AdInfo> lookup(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.discovery.AdId id) {

    return this.server.lookup(_ctx, _call, id);
  }

  /**
   * GetAttachment returns the named attachment. Accessing non-existent attachment
   * is not an error - nil data is returned if not found.
   *<p>
   * TODO(jhahn): Consider to return an error if not found.
   */
  public com.google.common.util.concurrent.ListenableFuture<byte[]> getAttachment(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.discovery.AdId id,
      final java.lang.String name) {

    return this.server.getAttachment(_ctx, _call, id, name);
  }
}
