// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.lib.discovery;

/**
 * AdInfo represents advertisement information for discovery.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/lib/discovery.AdInfo")
public class AdInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Ad", index = 0)
  private io.v.v23.discovery.Advertisement ad;

  @io.v.v23.vdl.GeneratedFromVdl(name = "EncryptionAlgorithm", index = 1)
  private io.v.x.ref.lib.discovery.EncryptionAlgorithm encryptionAlgorithm;

  @io.v.v23.vdl.GeneratedFromVdl(name = "EncryptionKeys", index = 2)
  private java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> encryptionKeys;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Hash", index = 3)
  private io.v.x.ref.lib.discovery.AdHash hash;

  @io.v.v23.vdl.GeneratedFromVdl(name = "TimestampNs", index = 4)
  private long timestampNs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DirAddrs", index = 5)
  private java.util.List<java.lang.String> dirAddrs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Status", index = 6)
  private io.v.x.ref.lib.discovery.AdStatus status;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Lost", index = 7)
  private boolean lost;

  /**
   * Vdl type for {@link AdInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(AdInfo.class);

  /**
   * Creates a new zero-value instance of {@link AdInfo}.
   */
  public AdInfo() {
    super(VDL_TYPE);

    this.ad = new io.v.v23.discovery.Advertisement();

    this.encryptionAlgorithm = new io.v.x.ref.lib.discovery.EncryptionAlgorithm();

    this.encryptionKeys = new java.util.ArrayList<io.v.x.ref.lib.discovery.EncryptionKey>();

    this.hash = new io.v.x.ref.lib.discovery.AdHash();

    this.timestampNs = 0L;

    this.dirAddrs = new java.util.ArrayList<java.lang.String>();

    this.status = new io.v.x.ref.lib.discovery.AdStatus();

    this.lost = false;
  }

  /**
   * Creates a new instance of {@link AdInfo} with the provided field values.
   */
  public AdInfo(
      io.v.v23.discovery.Advertisement ad,
      io.v.x.ref.lib.discovery.EncryptionAlgorithm encryptionAlgorithm,
      java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> encryptionKeys,
      io.v.x.ref.lib.discovery.AdHash hash,
      long timestampNs,
      java.util.List<java.lang.String> dirAddrs,
      io.v.x.ref.lib.discovery.AdStatus status,
      boolean lost) {
    super(VDL_TYPE);

    this.ad = ad;

    this.encryptionAlgorithm = encryptionAlgorithm;

    this.encryptionKeys = encryptionKeys;

    this.hash = hash;

    this.timestampNs = timestampNs;

    this.dirAddrs = dirAddrs;

    this.status = status;

    this.lost = lost;
  }

  public io.v.v23.discovery.Advertisement getAd() {
    return this.ad;
  }

  public void setAd(io.v.v23.discovery.Advertisement ad) {
    this.ad = ad;
  }

  /**
   * Type of encryption applied to the advertisement so that it can
   * only be decoded by authorized principals.
   */
  public io.v.x.ref.lib.discovery.EncryptionAlgorithm getEncryptionAlgorithm() {
    return this.encryptionAlgorithm;
  }

  /**
   * Type of encryption applied to the advertisement so that it can
   * only be decoded by authorized principals.
   */
  public void setEncryptionAlgorithm(
      io.v.x.ref.lib.discovery.EncryptionAlgorithm encryptionAlgorithm) {
    this.encryptionAlgorithm = encryptionAlgorithm;
  }

  /**
   * If the advertisement is encrypted, then the data required to
   * decrypt it. The format of this data is a function of the algorithm.
   */
  public java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> getEncryptionKeys() {
    return this.encryptionKeys;
  }

  /**
   * If the advertisement is encrypted, then the data required to
   * decrypt it. The format of this data is a function of the algorithm.
   */
  public void setEncryptionKeys(
      java.util.List<io.v.x.ref.lib.discovery.EncryptionKey> encryptionKeys) {
    this.encryptionKeys = encryptionKeys;
  }

  /**
   * Hash of the current advertisement. This does not include the fields below.
   */
  public io.v.x.ref.lib.discovery.AdHash getHash() {
    return this.hash;
  }

  /**
   * Hash of the current advertisement. This does not include the fields below.
   */
  public void setHash(io.v.x.ref.lib.discovery.AdHash hash) {
    this.hash = hash;
  }

  /**
   * Unix time in nanoseconds at which the advertisement was created.
   */
  public long getTimestampNs() {
    return this.timestampNs;
  }

  /**
   * Unix time in nanoseconds at which the advertisement was created.
   */
  public void setTimestampNs(long timestampNs) {
    this.timestampNs = timestampNs;
  }

  /**
   * The addresses (vanadium object names) that the advertisement directory service
   * is served on. See directory.vdl.
   */
  public java.util.List<java.lang.String> getDirAddrs() {
    return this.dirAddrs;
  }

  /**
   * The addresses (vanadium object names) that the advertisement directory service
   * is served on. See directory.vdl.
   */
  public void setDirAddrs(java.util.List<java.lang.String> dirAddrs) {
    this.dirAddrs = dirAddrs;
  }

  /**
   * Status of the current advertisement. Valid for scanned advertisements.
   */
  public io.v.x.ref.lib.discovery.AdStatus getStatus() {
    return this.status;
  }

  /**
   * Status of the current advertisement. Valid for scanned advertisements.
   */
  public void setStatus(io.v.x.ref.lib.discovery.AdStatus status) {
    this.status = status;
  }

  /**
   * TODO(jhahn): Add proximity.
   * TODO(jhahn): Use proximity for Lost.
   */
  public boolean getLost() {
    return this.lost;
  }

  /**
   * TODO(jhahn): Add proximity.
   * TODO(jhahn): Use proximity for Lost.
   */
  public void setLost(boolean lost) {
    this.lost = lost;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    AdInfo other = (AdInfo) obj;

    if (this.ad == null) {
      if (other.ad != null) {
        return false;
      }
    } else if (!this.ad.equals(other.ad)) {
      return false;
    }

    if (this.encryptionAlgorithm == null) {
      if (other.encryptionAlgorithm != null) {
        return false;
      }
    } else if (!this.encryptionAlgorithm.equals(other.encryptionAlgorithm)) {
      return false;
    }

    if (this.encryptionKeys == null) {
      if (other.encryptionKeys != null) {
        return false;
      }
    } else if (!this.encryptionKeys.equals(other.encryptionKeys)) {
      return false;
    }

    if (this.hash == null) {
      if (other.hash != null) {
        return false;
      }
    } else if (!this.hash.equals(other.hash)) {
      return false;
    }

    if (this.timestampNs != other.timestampNs) {
      return false;
    }

    if (this.dirAddrs == null) {
      if (other.dirAddrs != null) {
        return false;
      }
    } else if (!this.dirAddrs.equals(other.dirAddrs)) {
      return false;
    }

    if (this.status == null) {
      if (other.status != null) {
        return false;
      }
    } else if (!this.status.equals(other.status)) {
      return false;
    }

    if (this.lost != other.lost) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.ad == null ? 0 : this.ad.hashCode());

    result =
        prime * result
            + (this.encryptionAlgorithm == null ? 0 : this.encryptionAlgorithm.hashCode());

    result = prime * result + (this.encryptionKeys == null ? 0 : this.encryptionKeys.hashCode());

    result = prime * result + (this.hash == null ? 0 : this.hash.hashCode());

    result = prime * result + java.lang.Long.valueOf(this.timestampNs).hashCode();

    result = prime * result + (this.dirAddrs == null ? 0 : this.dirAddrs.hashCode());

    result = prime * result + (this.status == null ? 0 : this.status.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.lost).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "ad:" + this.ad;

    result += ", ";

    result += "encryptionAlgorithm:" + this.encryptionAlgorithm;

    result += ", ";

    result += "encryptionKeys:" + this.encryptionKeys;

    result += ", ";

    result += "hash:" + this.hash;

    result += ", ";

    result += "timestampNs:" + this.timestampNs;

    result += ", ";

    result += "dirAddrs:" + this.dirAddrs;

    result += ", ";

    result += "status:" + this.status;

    result += ", ";

    result += "lost:" + this.lost;

    return result + "}";
  }
}
