// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  tunnel.vdl
package io.v.x.ref.examples.tunnel;

/**
 * Wrapper for {@link TunnelServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class TunnelServerWrapper {
  private final io.v.x.ref.examples.tunnel.TunnelServer server;

  /**
   * Creates a new {@link TunnelServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public TunnelServerWrapper(io.v.x.ref.examples.tunnel.TunnelServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "forward",
              "// The Forward method is used for network forwarding. All the data sent over"
                  + "// the byte stream is forwarded to the requested network address and all the"
                  + "// data received from that network connection is sent back on the reply"
                  + "// stream."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "reverseForward",
              "// The ReverseForward method is used for network forwarding from the server"
                  + "// back to the client. The server process listens on the requested network"
                  + "// address, forwarding all connections by calling Forwarder.Forward on the"
                  + "// caller."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.examples.tunnel.ShellOpts.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "shell",
              "// The Shell method is used to either run shell commands remotely, or to open"
                  + "// an interactive shell. The data received over the byte stream is sent to the"
                  + "// shell's stdin, and the data received from the shell's stdout and stderr is"
                  + "// sent back in the reply stream. It returns the exit status of the shell"
                  + "// command as an integer exit code and a human readable string."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Tunnel", "io.v.x.ref.examples.tunnel", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("forward".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"forward\": %s", e.getMessage()));
      }
    }

    if ("reverseForward".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"reverseForward\": %s", e.getMessage()));
      }
    }

    if ("shell".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"shell\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * The Forward method is used for network forwarding. All the data sent over
   * the byte stream is forwarded to the requested network address and all the
   * data received from that network connection is sent back on the reply
   * stream.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> forward(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String network,
      final java.lang.String address) {

    io.v.v23.vdl.ServerStream<byte[], byte[]> _stream =
        new io.v.v23.vdl.ServerStream<byte[], byte[]>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(byte[] _item) {
            java.lang.reflect.Type _type = byte[].class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<byte[]> recv() {
            java.lang.reflect.Type _type = byte[].class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, byte[]>() {
                  @Override
                  public byte[] apply(Object result) {
                    return (byte[]) result;
                  }
                });
          }
        };

    return this.server.forward(_ctx, _call, network, address, _stream);
  }

  /**
   * The ReverseForward method is used for network forwarding from the server
   * back to the client. The server process listens on the requested network
   * address, forwarding all connections by calling Forwarder.Forward on the
   * caller.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reverseForward(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String network,
      final java.lang.String address) {

    return this.server.reverseForward(_ctx, _call, network, address);
  }

  /**
   * The Shell method is used to either run shell commands remotely, or to open
   * an interactive shell. The data received over the byte stream is sent to the
   * shell's stdin, and the data received from the shell's stdout and stderr is
   * sent back in the reply stream. It returns the exit status of the shell
   * command as an integer exit code and a human readable string.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.examples.tunnel.TunnelServer.ShellOut>
      shell(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final java.lang.String command,
          final io.v.x.ref.examples.tunnel.ShellOpts shellOpts) {

    io.v.v23.vdl.ServerStream<
            io.v.x.ref.examples.tunnel.ServerShellPacket,
            io.v.x.ref.examples.tunnel.ClientShellPacket>
        _stream =
            new io.v.v23.vdl.ServerStream<
                io.v.x.ref.examples.tunnel.ServerShellPacket,
                io.v.x.ref.examples.tunnel.ClientShellPacket>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<Void> send(
                  io.v.x.ref.examples.tunnel.ServerShellPacket _item) {
                java.lang.reflect.Type _type = io.v.x.ref.examples.tunnel.ServerShellPacket.class;
                return _call.send(_item, _type);
              }

              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.examples.tunnel.ClientShellPacket>
                  recv() {
                java.lang.reflect.Type _type = io.v.x.ref.examples.tunnel.ClientShellPacket.class;
                return com.google.common.util.concurrent.Futures.transform(
                    _call.recv(_type),
                    new com.google.common.base.Function<
                        Object, io.v.x.ref.examples.tunnel.ClientShellPacket>() {
                      @Override
                      public io.v.x.ref.examples.tunnel.ClientShellPacket apply(Object result) {
                        return (io.v.x.ref.examples.tunnel.ClientShellPacket) result;
                      }
                    });
              }
            };

    return this.server.shell(_ctx, _call, command, shellOpts, _stream);
  }
}
