// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: tunnel.vdl
package io.v.x.ref.examples.tunnel;

@io.v.v23.vdl.VServer(serverWrapper = io.v.x.ref.examples.tunnel.TunnelServerWrapper.class)
public interface TunnelServer {

  /**
   * The Forward method is used for network forwarding. All the data sent over
   * the byte stream is forwarded to the requested network address and all the
   * data received from that network connection is sent back on the reply
   * stream.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> forward(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final java.lang.String network,
      final java.lang.String address,
      io.v.v23.vdl.ServerStream<byte[], byte[]> stream);

  /**
   * The ReverseForward method is used for network forwarding from the server
   * back to the client. The server process listens on the requested network
   * address, forwarding all connections by calling Forwarder.Forward on the
   * caller.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reverseForward(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final java.lang.String network,
      final java.lang.String address);

  /**
   * Multi-return value for method {@link #shell}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class ShellOut {

    public int exitCode;

    public java.lang.String exitMsg;
  }

  /**
   * The Shell method is used to either run shell commands remotely, or to open
   * an interactive shell. The data received over the byte stream is sent to the
   * shell's stdin, and the data received from the shell's stdout and stderr is
   * sent back in the reply stream. It returns the exit status of the shell
   * command as an integer exit code and a human readable string.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.examples.tunnel.TunnelServer.ShellOut>
      shell(
          io.v.v23.context.VContext context,
          io.v.v23.rpc.ServerCall call,
          final java.lang.String command,
          final io.v.x.ref.examples.tunnel.ShellOpts shellOpts,
          io.v.v23.vdl.ServerStream<
                  io.v.x.ref.examples.tunnel.ServerShellPacket,
                  io.v.x.ref.examples.tunnel.ClientShellPacket>
              stream);
}
