// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  tunnel.vdl
package io.v.x.ref.examples.tunnel;

/**
 * Implementation of the {@link ForwarderClient} interface.
 */
final class ForwarderClientImpl implements io.v.x.ref.examples.tunnel.ForwarderClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link ForwarderClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public ForwarderClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface ForwarderClient.

  @Override
  public io.v.v23.vdl.ClientStream<byte[], byte[], java.lang.Void> forward(
      io.v.v23.context.VContext _context) {
    return forward(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<byte[], byte[], java.lang.Void> forward(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return forward(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientStream<byte[], byte[], java.lang.Void> forward(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "forward", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<byte[], byte[], java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(final byte[] item) {
        final java.lang.reflect.Type type = byte[].class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<byte[]> recv() {
        final java.lang.reflect.Type recvType = byte[].class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, byte[]>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<byte[]> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, byte[]>() {
                          @Override
                          public byte[] apply(Object result) {
                            return (byte[]) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }
}
