// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.x.ref.examples.rps;

/**
 * Wrapper for {@link RockPaperScissorsServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class RockPaperScissorsServerWrapper {
  private final io.v.x.ref.examples.rps.RockPaperScissorsServer server;

  private final io.v.x.ref.examples.rps.JudgeServerWrapper wrapperJudge;

  private final io.v.x.ref.examples.rps.PlayerServerWrapper wrapperPlayer;

  private final io.v.x.ref.examples.rps.ScoreKeeperServerWrapper wrapperScoreKeeper;

  /**
   * Creates a new {@link RockPaperScissorsServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public RockPaperScissorsServerWrapper(io.v.x.ref.examples.rps.RockPaperScissorsServer server) {
    this.server = server;

    this.wrapperJudge = new io.v.x.ref.examples.rps.JudgeServerWrapper(server);

    this.wrapperPlayer = new io.v.x.ref.examples.rps.PlayerServerWrapper(server);

    this.wrapperScoreKeeper = new io.v.x.ref.examples.rps.ScoreKeeperServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    return new io.v.v23.vdlroot.signature.Interface(
        "RockPaperScissors", "io.v.x.ref.examples.rps", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperJudge.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperPlayer.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperScoreKeeper.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * CreateGame creates a new game with the given game options and returns a game
   * identifier that can be used by the players to join the game.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final io.v.x.ref.examples.rps.GameOptions Opts)
          throws io.v.v23.verror.VException {

    return this.wrapperJudge.createGame(ctx, call, Opts);
  }

  /**
   * Play lets a player join an existing game and play.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.PlayResult>
      play(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final io.v.x.ref.examples.rps.GameId Id)
          throws io.v.v23.verror.VException {

    return this.wrapperJudge.play(ctx, call, Id);
  }

  /**
   * Challenge is used by other players to challenge this player to a game. If
   * the challenge is accepted, the method returns nil.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> challenge(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final java.lang.String Address,
      final io.v.x.ref.examples.rps.GameId Id,
      final io.v.x.ref.examples.rps.GameOptions Opts)
      throws io.v.v23.verror.VException {

    return this.wrapperPlayer.challenge(ctx, call, Address, Id, Opts);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> record(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.x.ref.examples.rps.ScoreCard Score)
      throws io.v.v23.verror.VException {

    return this.wrapperScoreKeeper.record(ctx, call, Score);
  }
}
