// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.x.ref.examples.rps;

/**
 * Implementation of the {@link RockPaperScissorsClient} interface.
 */
final class RockPaperScissorsClientImpl implements io.v.x.ref.examples.rps.RockPaperScissorsClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.x.ref.examples.rps.JudgeClient implJudge;

  private final io.v.x.ref.examples.rps.PlayerClient implPlayer;

  private final io.v.x.ref.examples.rps.ScoreKeeperClient implScoreKeeper;

  /**
   * Creates a new instance of {@link RockPaperScissorsClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public RockPaperScissorsClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implJudge = io.v.x.ref.examples.rps.JudgeClientFactory.getJudgeClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implPlayer = io.v.x.ref.examples.rps.PlayerClientFactory.getPlayerClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implScoreKeeper =
          io.v.x.ref.examples.rps.ScoreKeeperClientFactory.getScoreKeeperClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface RockPaperScissorsClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          io.v.v23.context.VContext _context, final io.v.x.ref.examples.rps.GameOptions Opts) {

    return this.implJudge.createGame(_context, Opts);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameOptions Opts,
          io.v.v23.Options _opts) {

    return this.implJudge.createGame(_context, Opts, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameOptions Opts,
          io.v.v23.options.RpcOptions _opts) {

    return this.implJudge.createGame(_context, Opts, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.examples.rps.PlayerAction, io.v.x.ref.examples.rps.JudgeAction,
          io.v.x.ref.examples.rps.PlayResult>
      play(io.v.v23.context.VContext _context, final io.v.x.ref.examples.rps.GameId Id) {

    return this.implJudge.play(_context, Id);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.examples.rps.PlayerAction, io.v.x.ref.examples.rps.JudgeAction,
          io.v.x.ref.examples.rps.PlayResult>
      play(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameId Id,
          io.v.v23.Options _opts) {

    return this.implJudge.play(_context, Id, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.examples.rps.PlayerAction, io.v.x.ref.examples.rps.JudgeAction,
          io.v.x.ref.examples.rps.PlayResult>
      play(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameId Id,
          io.v.v23.options.RpcOptions _opts) {

    return this.implJudge.play(_context, Id, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> challenge(
      io.v.v23.context.VContext _context,
      final java.lang.String Address,
      final io.v.x.ref.examples.rps.GameId Id,
      final io.v.x.ref.examples.rps.GameOptions Opts) {

    return this.implPlayer.challenge(_context, Address, Id, Opts);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> challenge(
      io.v.v23.context.VContext _context,
      final java.lang.String Address,
      final io.v.x.ref.examples.rps.GameId Id,
      final io.v.x.ref.examples.rps.GameOptions Opts,
      io.v.v23.Options _opts) {

    return this.implPlayer.challenge(_context, Address, Id, Opts, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> challenge(
      io.v.v23.context.VContext _context,
      final java.lang.String Address,
      final io.v.x.ref.examples.rps.GameId Id,
      final io.v.x.ref.examples.rps.GameOptions Opts,
      io.v.v23.options.RpcOptions _opts) {

    return this.implPlayer.challenge(_context, Address, Id, Opts, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> record(
      io.v.v23.context.VContext _context, final io.v.x.ref.examples.rps.ScoreCard Score) {

    return this.implScoreKeeper.record(_context, Score);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> record(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.examples.rps.ScoreCard Score,
      io.v.v23.Options _opts) {

    return this.implScoreKeeper.record(_context, Score, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> record(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.examples.rps.ScoreCard Score,
      io.v.v23.options.RpcOptions _opts) {

    return this.implScoreKeeper.record(_context, Score, _opts);
  }
}
