// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.x.ref.examples.rps;

/**
 * Wrapper for {@link JudgeServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class JudgeServerWrapper {
  private final io.v.x.ref.examples.rps.JudgeServer server;

  /**
   * Creates a new {@link JudgeServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public JudgeServerWrapper(io.v.x.ref.examples.rps.JudgeServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.examples.rps.GameOptions.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.examples.rps.GameId.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "createGame",
              "// CreateGame creates a new game with the given game options and returns a game"
                  + "// identifier that can be used by the players to join the game."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.examples.rps.GameId.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.examples.rps.PlayResult.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "play",
              "// Play lets a player join an existing game and play." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Judge", "io.v.x.ref.examples.rps", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("createGame".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"createGame\": %s", e.getMessage()));
      }
    }

    if ("play".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"play\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * CreateGame creates a new game with the given game options and returns a game
   * identifier that can be used by the players to join the game.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.x.ref.examples.rps.GameOptions Opts) {

    return this.server.createGame(_ctx, _call, Opts);
  }

  /**
   * Play lets a player join an existing game and play.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.PlayResult>
      play(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.x.ref.examples.rps.GameId Id) {

    io.v.v23.vdl.ServerStream<
            io.v.x.ref.examples.rps.JudgeAction, io.v.x.ref.examples.rps.PlayerAction>
        _stream =
            new io.v.v23.vdl.ServerStream<
                io.v.x.ref.examples.rps.JudgeAction, io.v.x.ref.examples.rps.PlayerAction>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<Void> send(
                  io.v.x.ref.examples.rps.JudgeAction _item) {
                java.lang.reflect.Type _type = io.v.x.ref.examples.rps.JudgeAction.class;
                return _call.send(_item, _type);
              }

              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.examples.rps.PlayerAction>
                  recv() {
                java.lang.reflect.Type _type = io.v.x.ref.examples.rps.PlayerAction.class;
                return com.google.common.util.concurrent.Futures.transform(
                    _call.recv(_type),
                    new com.google.common.base.Function<
                        Object, io.v.x.ref.examples.rps.PlayerAction>() {
                      @Override
                      public io.v.x.ref.examples.rps.PlayerAction apply(Object result) {
                        return (io.v.x.ref.examples.rps.PlayerAction) result;
                      }
                    });
              }
            };

    return this.server.play(_ctx, _call, Id, _stream);
  }
}
