// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.x.ref.examples.rps;

/**
 * Implementation of the {@link JudgeClient} interface.
 */
final class JudgeClientImpl implements io.v.x.ref.examples.rps.JudgeClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link JudgeClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public JudgeClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface JudgeClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          io.v.v23.context.VContext _context, final io.v.x.ref.examples.rps.GameOptions Opts) {
    return createGame(_context, Opts, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameOptions Opts,
          io.v.v23.Options _opts) {
    return createGame(_context, Opts, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.GameId>
      createGame(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameOptions Opts,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {Opts};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.x.ref.examples.rps.GameOptions.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "createGame", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.ref.examples.rps.GameId>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.examples.rps.GameId>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.examples.rps.GameId.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.examples.rps.GameId>() {
                      @Override
                      public io.v.x.ref.examples.rps.GameId apply(Object[] _results) {

                        return (io.v.x.ref.examples.rps.GameId) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.examples.rps.PlayerAction, io.v.x.ref.examples.rps.JudgeAction,
          io.v.x.ref.examples.rps.PlayResult>
      play(io.v.v23.context.VContext _context, final io.v.x.ref.examples.rps.GameId Id) {
    return play(_context, Id, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.examples.rps.PlayerAction, io.v.x.ref.examples.rps.JudgeAction,
          io.v.x.ref.examples.rps.PlayResult>
      play(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameId Id,
          io.v.v23.Options _opts) {
    return play(_context, Id, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.examples.rps.PlayerAction, io.v.x.ref.examples.rps.JudgeAction,
          io.v.x.ref.examples.rps.PlayResult>
      play(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.examples.rps.GameId Id,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {Id};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.x.ref.examples.rps.GameId.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "play", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        io.v.x.ref.examples.rps.PlayerAction, io.v.x.ref.examples.rps.JudgeAction,
        io.v.x.ref.examples.rps.PlayResult>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final io.v.x.ref.examples.rps.PlayerAction item) {
        final java.lang.reflect.Type type = io.v.x.ref.examples.rps.PlayerAction.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.JudgeAction>
          recv() {
        final java.lang.reflect.Type recvType = io.v.x.ref.examples.rps.JudgeAction.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, io.v.x.ref.examples.rps.JudgeAction>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.examples.rps.JudgeAction>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, io.v.x.ref.examples.rps.JudgeAction>() {
                          @Override
                          public io.v.x.ref.examples.rps.JudgeAction apply(Object result) {
                            return (io.v.x.ref.examples.rps.JudgeAction) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.examples.rps.PlayResult>
          finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              io.v.x.ref.examples.rps.PlayResult.class,
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, io.v.x.ref.examples.rps.PlayResult>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.examples.rps.PlayResult>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<
                            Object[], io.v.x.ref.examples.rps.PlayResult>() {
                          @Override
                          public io.v.x.ref.examples.rps.PlayResult apply(Object[] _results) {

                            return (io.v.x.ref.examples.rps.PlayResult) _results[0];
                          }
                        });
                  }
                }));
      }
    };
  }
}
