// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.x.ref.examples.rps;

/**
 * GameOptions specifies the parameters of a game.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/examples/rps.GameOptions")
public class GameOptions extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumRounds", index = 0)
  private int numRounds;

  @io.v.v23.vdl.GeneratedFromVdl(name = "GameType", index = 1)
  private io.v.x.ref.examples.rps.GameTypeTag gameType;

  /**
   * Vdl type for {@link GameOptions}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(GameOptions.class);

  /**
   * Creates a new zero-value instance of {@link GameOptions}.
   */
  public GameOptions() {
    super(VDL_TYPE);

    this.numRounds = 0;

    this.gameType = new io.v.x.ref.examples.rps.GameTypeTag();
  }

  /**
   * Creates a new instance of {@link GameOptions} with the provided field values.
   */
  public GameOptions(int numRounds, io.v.x.ref.examples.rps.GameTypeTag gameType) {
    super(VDL_TYPE);

    this.numRounds = numRounds;

    this.gameType = gameType;
  }

  /**
   * The number of rounds that a player must win to win the game.
   */
  public int getNumRounds() {
    return this.numRounds;
  }

  /**
   * The number of rounds that a player must win to win the game.
   */
  public void setNumRounds(int numRounds) {
    this.numRounds = numRounds;
  }

  /**
   * The type of game to play: Classic or LizardSpock.
   */
  public io.v.x.ref.examples.rps.GameTypeTag getGameType() {
    return this.gameType;
  }

  /**
   * The type of game to play: Classic or LizardSpock.
   */
  public void setGameType(io.v.x.ref.examples.rps.GameTypeTag gameType) {
    this.gameType = gameType;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    GameOptions other = (GameOptions) obj;

    if (this.numRounds != other.numRounds) {
      return false;
    }

    if (this.gameType == null) {
      if (other.gameType != null) {
        return false;
      }
    } else if (!this.gameType.equals(other.gameType)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + this.numRounds;

    result = prime * result + (this.gameType == null ? 0 : this.gameType.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "numRounds:" + this.numRounds;

    result += ", ";

    result += "gameType:" + this.gameType;

    return result + "}";
  }
}
