// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  test_base.vdl
package io.v.x.ref.cmd.vrpc.internal;

/**
 * Implementation of the {@link TypeTesterClient} interface.
 */
final class TypeTesterClientImpl implements io.v.x.ref.cmd.vrpc.internal.TypeTesterClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link TypeTesterClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public TypeTesterClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface TypeTesterClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> echoBool(
      io.v.v23.context.VContext _context, final boolean I1) {
    return echoBool(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> echoBool(
      final io.v.v23.context.VContext _context, final boolean I1, io.v.v23.Options _opts) {
    return echoBool(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> echoBool(
      final io.v.v23.context.VContext _context,
      final boolean I1,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Boolean.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoBool", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Boolean>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Boolean.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Boolean>() {
                      @Override
                      public java.lang.Boolean apply(Object[] _results) {

                        return (java.lang.Boolean) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Float> echoFloat32(
      io.v.v23.context.VContext _context, final float I1) {
    return echoFloat32(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Float> echoFloat32(
      final io.v.v23.context.VContext _context, final float I1, io.v.v23.Options _opts) {
    return echoFloat32(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Float> echoFloat32(
      final io.v.v23.context.VContext _context, final float I1, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Float.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoFloat32", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Float>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Float> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Float.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Float>() {
                      @Override
                      public java.lang.Float apply(Object[] _results) {

                        return (java.lang.Float) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> echoFloat64(
      io.v.v23.context.VContext _context, final double I1) {
    return echoFloat64(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> echoFloat64(
      final io.v.v23.context.VContext _context, final double I1, io.v.v23.Options _opts) {
    return echoFloat64(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> echoFloat64(
      final io.v.v23.context.VContext _context,
      final double I1,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Double.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoFloat64", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Double>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Double.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Double>() {
                      @Override
                      public java.lang.Double apply(Object[] _results) {

                        return (java.lang.Double) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> echoInt32(
      io.v.v23.context.VContext _context, final int I1) {
    return echoInt32(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> echoInt32(
      final io.v.v23.context.VContext _context, final int I1, io.v.v23.Options _opts) {
    return echoInt32(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> echoInt32(
      final io.v.v23.context.VContext _context, final int I1, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Integer.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoInt32", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Integer>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Integer.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Integer>() {
                      @Override
                      public java.lang.Integer apply(Object[] _results) {

                        return (java.lang.Integer) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> echoInt64(
      io.v.v23.context.VContext _context, final long I1) {
    return echoInt64(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> echoInt64(
      final io.v.v23.context.VContext _context, final long I1, io.v.v23.Options _opts) {
    return echoInt64(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> echoInt64(
      final io.v.v23.context.VContext _context, final long I1, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Long.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoInt64", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Long>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Long.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Long>() {
                      @Override
                      public java.lang.Long apply(Object[] _results) {

                        return (java.lang.Long) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> echoString(
      io.v.v23.context.VContext _context, final java.lang.String I1) {
    return echoString(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> echoString(
      final io.v.v23.context.VContext _context, final java.lang.String I1, io.v.v23.Options _opts) {
    return echoString(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> echoString(
      final io.v.v23.context.VContext _context,
      final java.lang.String I1,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.String.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoString", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Byte> echoByte(
      io.v.v23.context.VContext _context, final byte I1) {
    return echoByte(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Byte> echoByte(
      final io.v.v23.context.VContext _context, final byte I1, io.v.v23.Options _opts) {
    return echoByte(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Byte> echoByte(
      final io.v.v23.context.VContext _context, final byte I1, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Byte.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoByte", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Byte>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Byte> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Byte.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Byte>() {
                      @Override
                      public java.lang.Byte apply(Object[] _results) {

                        return (java.lang.Byte) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint32> echoUint32(
      io.v.v23.context.VContext _context, final io.v.v23.vdl.VdlUint32 I1) {
    return echoUint32(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint32> echoUint32(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlUint32 I1,
      io.v.v23.Options _opts) {
    return echoUint32(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint32> echoUint32(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlUint32 I1,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.vdl.VdlUint32.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoUint32", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.vdl.VdlUint32>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint32>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.vdl.VdlUint32.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.vdl.VdlUint32>() {
                      @Override
                      public io.v.v23.vdl.VdlUint32 apply(Object[] _results) {

                        return (io.v.v23.vdl.VdlUint32) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint64> echoUint64(
      io.v.v23.context.VContext _context, final io.v.v23.vdl.VdlUint64 I1) {
    return echoUint64(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint64> echoUint64(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlUint64 I1,
      io.v.v23.Options _opts) {
    return echoUint64(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint64> echoUint64(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlUint64 I1,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.vdl.VdlUint64.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "echoUint64", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.vdl.VdlUint64>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlUint64>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.vdl.VdlUint64.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.vdl.VdlUint64>() {
                      @Override
                      public io.v.v23.vdl.VdlUint64 apply(Object[] _results) {

                        return (io.v.v23.vdl.VdlUint64) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.cmd.vrpc.internal.Array2Int>
      xEchoArray(
          io.v.v23.context.VContext _context, final io.v.x.ref.cmd.vrpc.internal.Array2Int I1) {
    return xEchoArray(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.cmd.vrpc.internal.Array2Int>
      xEchoArray(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.cmd.vrpc.internal.Array2Int I1,
          io.v.v23.Options _opts) {
    return xEchoArray(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.cmd.vrpc.internal.Array2Int>
      xEchoArray(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.cmd.vrpc.internal.Array2Int I1,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.x.ref.cmd.vrpc.internal.Array2Int.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "xEchoArray", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.ref.cmd.vrpc.internal.Array2Int>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.cmd.vrpc.internal.Array2Int>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.cmd.vrpc.internal.Array2Int.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.cmd.vrpc.internal.Array2Int>() {
                      @Override
                      public io.v.x.ref.cmd.vrpc.internal.Array2Int apply(Object[] _results) {

                        return (io.v.x.ref.cmd.vrpc.internal.Array2Int) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.Integer, java.lang.String>>
      xEchoMap(
          io.v.v23.context.VContext _context,
          final java.util.Map<java.lang.Integer, java.lang.String> I1) {
    return xEchoMap(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.Integer, java.lang.String>>
      xEchoMap(
          final io.v.v23.context.VContext _context,
          final java.util.Map<java.lang.Integer, java.lang.String> I1,
          io.v.v23.Options _opts) {
    return xEchoMap(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.Integer, java.lang.String>>
      xEchoMap(
          final io.v.v23.context.VContext _context,
          final java.util.Map<java.lang.Integer, java.lang.String> I1,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<
              java.util.Map<java.lang.Integer, java.lang.String>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "xEchoMap", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.Map<java.lang.Integer, java.lang.String>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.Map<java.lang.Integer, java.lang.String>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.Map<java.lang.Integer, java.lang.String>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.Map<java.lang.Integer, java.lang.String>>() {
                      @Override
                      public java.util.Map<java.lang.Integer, java.lang.String> apply(
                          Object[] _results) {

                        return (java.util.Map<java.lang.Integer, java.lang.String>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.Set<java.lang.Integer>>
      xEchoSet(io.v.v23.context.VContext _context, final java.util.Set<java.lang.Integer> I1) {
    return xEchoSet(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.Set<java.lang.Integer>>
      xEchoSet(
          final io.v.v23.context.VContext _context,
          final java.util.Set<java.lang.Integer> I1,
          io.v.v23.Options _opts) {
    return xEchoSet(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.Set<java.lang.Integer>>
      xEchoSet(
          final io.v.v23.context.VContext _context,
          final java.util.Set<java.lang.Integer> I1,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<java.util.Set<java.lang.Integer>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "xEchoSet", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.Set<java.lang.Integer>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.Set<java.lang.Integer>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.Set<java.lang.Integer>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.Set<java.lang.Integer>>() {
                      @Override
                      public java.util.Set<java.lang.Integer> apply(Object[] _results) {

                        return (java.util.Set<java.lang.Integer>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.Integer>>
      xEchoSlice(io.v.v23.context.VContext _context, final java.util.List<java.lang.Integer> I1) {
    return xEchoSlice(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.Integer>>
      xEchoSlice(
          final io.v.v23.context.VContext _context,
          final java.util.List<java.lang.Integer> I1,
          io.v.v23.Options _opts) {
    return xEchoSlice(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.Integer>>
      xEchoSlice(
          final io.v.v23.context.VContext _context,
          final java.util.List<java.lang.Integer> I1,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<java.util.List<java.lang.Integer>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "xEchoSlice", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.List<java.lang.Integer>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.List<java.lang.Integer>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.List<java.lang.Integer>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.List<java.lang.Integer>>() {
                      @Override
                      public java.util.List<java.lang.Integer> apply(Object[] _results) {

                        return (java.util.List<java.lang.Integer>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.cmd.vrpc.internal.Struct>
      xEchoStruct(
          io.v.v23.context.VContext _context, final io.v.x.ref.cmd.vrpc.internal.Struct I1) {
    return xEchoStruct(_context, I1, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.cmd.vrpc.internal.Struct>
      xEchoStruct(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.cmd.vrpc.internal.Struct I1,
          io.v.v23.Options _opts) {
    return xEchoStruct(_context, I1, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.cmd.vrpc.internal.Struct>
      xEchoStruct(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.cmd.vrpc.internal.Struct I1,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.x.ref.cmd.vrpc.internal.Struct.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "xEchoStruct", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.ref.cmd.vrpc.internal.Struct>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.cmd.vrpc.internal.Struct>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.cmd.vrpc.internal.Struct.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.cmd.vrpc.internal.Struct>() {
                      @Override
                      public io.v.x.ref.cmd.vrpc.internal.Struct apply(Object[] _results) {

                        return (io.v.x.ref.cmd.vrpc.internal.Struct) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut>
      yMultiArg(io.v.v23.context.VContext _context, final int I1, final int I2) {
    return yMultiArg(_context, I1, I2, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut>
      yMultiArg(
          final io.v.v23.context.VContext _context,
          final int I1,
          final int I2,
          io.v.v23.Options _opts) {
    return yMultiArg(_context, I1, I2, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut>
      yMultiArg(
          final io.v.v23.context.VContext _context,
          final int I1,
          final int I2,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {I1, I2};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {java.lang.Integer.class, java.lang.Integer.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "yMultiArg", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Integer.class, java.lang.Integer.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut>() {
                      @Override
                      public io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut apply(
                          Object[] _results) {

                        io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut _ret =
                            new io.v.x.ref.cmd.vrpc.internal.TypeTesterClient.YMultiArgOut();

                        _ret.o1 = (java.lang.Integer) _results[0];

                        _ret.o2 = (java.lang.Integer) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> yNoArgs(
      io.v.v23.context.VContext _context) {
    return yNoArgs(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> yNoArgs(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return yNoArgs(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> yNoArgs(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "yNoArgs", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Boolean, java.lang.Void> zStream(
      io.v.v23.context.VContext _context, final int NumStreamItems, final boolean StreamItem) {
    return zStream(_context, NumStreamItems, StreamItem, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Boolean, java.lang.Void> zStream(
      final io.v.v23.context.VContext _context,
      final int NumStreamItems,
      final boolean StreamItem,
      io.v.v23.Options _opts) {
    return zStream(
        _context, NumStreamItems, StreamItem, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Boolean, java.lang.Void> zStream(
      final io.v.v23.context.VContext _context,
      final int NumStreamItems,
      final boolean StreamItem,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {NumStreamItems, StreamItem};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {java.lang.Integer.class, java.lang.Boolean.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "zStream", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<java.lang.Void, java.lang.Boolean, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> recv() {
        final java.lang.reflect.Type recvType = java.lang.Boolean.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Boolean>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, java.lang.Boolean>() {
                          @Override
                          public java.lang.Boolean apply(Object result) {
                            return (java.lang.Boolean) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }
}
