// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: fortune.vdl
package io.v.x.jni.test.fortune;

/**
 * Fortune allows clients to Get and Add fortune strings.
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.x.jni.test.fortune.FortuneServerWrapper.class)
public interface FortuneServer {

  /**
   * Add stores a fortune in the set used by Get.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final java.lang.String Fortune);

  /**
   * Get returns the last-added fortune.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> get(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * ParameterizedGet returns the last-added fortune as a map (which is a parameterized
   * type in Java).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, java.lang.String>>
      parameterizedGet(io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * StreamingGet returns a stream that can be used to obtain fortunes, and returns the
   * total number of items sent.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> streamingGet(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      io.v.v23.vdl.ServerStream<java.lang.String, java.lang.Boolean> stream);

  /**
   * Multi-return value for method {@link #multipleGet}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class MultipleGetOut {

    public java.lang.String fortune;

    public java.lang.String another;
  }

  /**
   * MultipleGet returns the same fortune twice.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.jni.test.fortune.FortuneServer.MultipleGetOut>
      multipleGet(io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Multi-return value for method {@link #multipleStreamingGet}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class MultipleStreamingGetOut {

    public int total;

    public int another;
  }

  /**
   * MultipleStreamingGet returns a stream that can be used to obtain fortunes, and returns
   * the total number of items sent, twice.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.jni.test.fortune.FortuneServer.MultipleStreamingGetOut>
      multipleStreamingGet(
          io.v.v23.context.VContext context,
          io.v.v23.rpc.ServerCall call,
          io.v.v23.vdl.ServerStream<java.lang.String, java.lang.Boolean> stream);

  /**
   * GetComplexError returns (always!) ErrComplex.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> getComplexError(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * NoTags is a method without tags.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> noTags(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * TestServerCall is a method used for testing that the server receives a
   * correct ServerCall.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> testServerCall(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * GetServerThread returns a name of the server thread that executes this method.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> getServerThread(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);
}
