// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  fortune.vdl
package io.v.x.jni.test.fortune;

/**
 * Implementation of the {@link FortuneClient} interface.
 */
final class FortuneClientImpl implements io.v.x.jni.test.fortune.FortuneClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link FortuneClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public FortuneClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface FortuneClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      io.v.v23.context.VContext _context, final java.lang.String Fortune) {
    return add(_context, Fortune, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      final io.v.v23.context.VContext _context,
      final java.lang.String Fortune,
      io.v.v23.Options _opts) {
    return add(_context, Fortune, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      final io.v.v23.context.VContext _context,
      final java.lang.String Fortune,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {Fortune};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.String.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "add", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> get(
      io.v.v23.context.VContext _context) {
    return get(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> get(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return get(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> get(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "get", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, java.lang.String>>
      parameterizedGet(io.v.v23.context.VContext _context) {
    return parameterizedGet(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, java.lang.String>>
      parameterizedGet(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return parameterizedGet(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, java.lang.String>>
      parameterizedGet(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "parameterizedGet", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.Map<java.lang.String, java.lang.String>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.Map<java.lang.String, java.lang.String>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.Map<java.lang.String, java.lang.String>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.Map<java.lang.String, java.lang.String>>() {
                      @Override
                      public java.util.Map<java.lang.String, java.lang.String> apply(
                          Object[] _results) {

                        return (java.util.Map<java.lang.String, java.lang.String>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Boolean, java.lang.String, java.lang.Integer>
      streamingGet(io.v.v23.context.VContext _context) {
    return streamingGet(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Boolean, java.lang.String, java.lang.Integer>
      streamingGet(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return streamingGet(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Boolean, java.lang.String, java.lang.Integer>
      streamingGet(final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "streamingGet", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<java.lang.Boolean, java.lang.String, java.lang.Integer>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Boolean item) {
        final java.lang.reflect.Type type = java.lang.Boolean.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.String> recv() {
        final java.lang.reflect.Type recvType = java.lang.String.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.String>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, java.lang.String>() {
                          @Override
                          public java.lang.String apply(Object result) {
                            return (java.lang.String) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              java.lang.Integer.class,
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Integer>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Integer>() {
                          @Override
                          public java.lang.Integer apply(Object[] _results) {

                            return (java.lang.Integer) _results[0];
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut>
      multipleGet(io.v.v23.context.VContext _context) {
    return multipleGet(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut>
      multipleGet(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return multipleGet(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut>
      multipleGet(final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "multipleGet", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class, java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut>() {
                      @Override
                      public io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut apply(
                          Object[] _results) {

                        io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut _ret =
                            new io.v.x.jni.test.fortune.FortuneClient.MultipleGetOut();

                        _ret.fortune = (java.lang.String) _results[0];

                        _ret.another = (java.lang.String) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          java.lang.Boolean, java.lang.String,
          io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>
      multipleStreamingGet(io.v.v23.context.VContext _context) {
    return multipleStreamingGet(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<
          java.lang.Boolean, java.lang.String,
          io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>
      multipleStreamingGet(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return multipleStreamingGet(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          java.lang.Boolean, java.lang.String,
          io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>
      multipleStreamingGet(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "multipleStreamingGet", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Boolean, java.lang.String,
        io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Boolean item) {
        final java.lang.reflect.Type type = java.lang.Boolean.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.String> recv() {
        final java.lang.reflect.Type recvType = java.lang.String.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.String>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, java.lang.String>() {
                          @Override
                          public java.lang.String apply(Object result) {
                            return (java.lang.String) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>
          finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              java.lang.Integer.class, java.lang.Integer.class,
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall,
                    io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<
                            Object[],
                            io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut>() {
                          @Override
                          public io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut
                              apply(Object[] _results) {

                            io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut _ret =
                                new io.v.x.jni.test.fortune.FortuneClient.MultipleStreamingGetOut();

                            _ret.total = (java.lang.Integer) _results[0];

                            _ret.another = (java.lang.Integer) _results[1];

                            return _ret;
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> getComplexError(
      io.v.v23.context.VContext _context) {
    return getComplexError(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> getComplexError(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return getComplexError(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> getComplexError(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "getComplexError", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> noTags(
      io.v.v23.context.VContext _context) {
    return noTags(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> noTags(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return noTags(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> noTags(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "noTags", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> testServerCall(
      io.v.v23.context.VContext _context) {
    return testServerCall(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> testServerCall(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return testServerCall(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> testServerCall(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "testServerCall", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> getServerThread(
      io.v.v23.context.VContext _context) {
    return getServerThread(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> getServerThread(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return getServerThread(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> getServerThread(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "getServerThread", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }
}
