// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.vtrace;

/**
 * A SpanRecord is the wire format for a Span.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/vtrace.SpanRecord")
public class SpanRecord extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private io.v.v23.uniqueid.Id id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Parent", index = 1)
  private io.v.v23.uniqueid.Id parent;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Name", index = 2)
  private java.lang.String name;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Start", index = 3)
  private org.joda.time.DateTime start;

  @io.v.v23.vdl.GeneratedFromVdl(name = "End", index = 4)
  private org.joda.time.DateTime end;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Annotations", index = 5)
  private java.util.List<io.v.v23.vtrace.Annotation> annotations;

  /**
   * Vdl type for {@link SpanRecord}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SpanRecord.class);

  /**
   * Creates a new zero-value instance of {@link SpanRecord}.
   */
  public SpanRecord() {
    super(VDL_TYPE);

    this.id = new io.v.v23.uniqueid.Id();

    this.parent = new io.v.v23.uniqueid.Id();

    this.name = "";

    this.start = null;

    this.end = null;

    this.annotations = new java.util.ArrayList<io.v.v23.vtrace.Annotation>();
  }

  /**
   * Creates a new instance of {@link SpanRecord} with the provided field values.
   */
  public SpanRecord(
      io.v.v23.uniqueid.Id id,
      io.v.v23.uniqueid.Id parent,
      java.lang.String name,
      org.joda.time.DateTime start,
      org.joda.time.DateTime end,
      java.util.List<io.v.v23.vtrace.Annotation> annotations) {
    super(VDL_TYPE);

    this.id = id;

    this.parent = parent;

    this.name = name;

    this.start = start;

    this.end = end;

    this.annotations = annotations;
  }

  /**
   * The Id of the Span.
   */
  public io.v.v23.uniqueid.Id getId() {
    return this.id;
  }

  /**
   * The Id of the Span.
   */
  public void setId(io.v.v23.uniqueid.Id id) {
    this.id = id;
  }

  /**
   * The Id of this Span's parent.
   */
  public io.v.v23.uniqueid.Id getParent() {
    return this.parent;
  }

  /**
   * The Id of this Span's parent.
   */
  public void setParent(io.v.v23.uniqueid.Id parent) {
    this.parent = parent;
  }

  /**
   * The Name of this span.
   */
  public java.lang.String getName() {
    return this.name;
  }

  /**
   * The Name of this span.
   */
  public void setName(java.lang.String name) {
    this.name = name;
  }

  /**
   * The start time of this span.
   */
  public org.joda.time.DateTime getStart() {
    return this.start;
  }

  /**
   * The start time of this span.
   */
  public void setStart(org.joda.time.DateTime start) {
    this.start = start;
  }

  /**
   * The end time of this span.
   */
  public org.joda.time.DateTime getEnd() {
    return this.end;
  }

  /**
   * The end time of this span.
   */
  public void setEnd(org.joda.time.DateTime end) {
    this.end = end;
  }

  /**
   * A series of annotations.
   */
  public java.util.List<io.v.v23.vtrace.Annotation> getAnnotations() {
    return this.annotations;
  }

  /**
   * A series of annotations.
   */
  public void setAnnotations(java.util.List<io.v.v23.vtrace.Annotation> annotations) {
    this.annotations = annotations;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SpanRecord other = (SpanRecord) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (this.parent == null) {
      if (other.parent != null) {
        return false;
      }
    } else if (!this.parent.equals(other.parent)) {
      return false;
    }

    if (this.name == null) {
      if (other.name != null) {
        return false;
      }
    } else if (!this.name.equals(other.name)) {
      return false;
    }

    if (this.start == null) {
      if (other.start != null) {
        return false;
      }
    } else if (!this.start.equals(other.start)) {
      return false;
    }

    if (this.end == null) {
      if (other.end != null) {
        return false;
      }
    } else if (!this.end.equals(other.end)) {
      return false;
    }

    if (this.annotations == null) {
      if (other.annotations != null) {
        return false;
      }
    } else if (!this.annotations.equals(other.annotations)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + (this.parent == null ? 0 : this.parent.hashCode());

    result = prime * result + (this.name == null ? 0 : this.name.hashCode());

    result = prime * result + (this.start == null ? 0 : this.start.hashCode());

    result = prime * result + (this.end == null ? 0 : this.end.hashCode());

    result = prime * result + (this.annotations == null ? 0 : this.annotations.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "parent:" + this.parent;

    result += ", ";

    result += "name:" + this.name;

    result += ", ";

    result += "start:" + this.start;

    result += ", ";

    result += "end:" + this.end;

    result += ", ";

    result += "annotations:" + this.annotations;

    return result + "}";
  }
}
