// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.vtrace;

/**
 * Request is the object that carries trace informtion between processes.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/vtrace.Request")
public class Request extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "SpanId", index = 0)
  private io.v.v23.uniqueid.Id spanId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "TraceId", index = 1)
  private io.v.v23.uniqueid.Id traceId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Flags", index = 2)
  private io.v.v23.vtrace.TraceFlags flags;

  @io.v.v23.vdl.GeneratedFromVdl(name = "LogLevel", index = 3)
  private int logLevel;

  /**
   * Vdl type for {@link Request}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Request.class);

  /**
   * Creates a new zero-value instance of {@link Request}.
   */
  public Request() {
    super(VDL_TYPE);

    this.spanId = new io.v.v23.uniqueid.Id();

    this.traceId = new io.v.v23.uniqueid.Id();

    this.flags = new io.v.v23.vtrace.TraceFlags();

    this.logLevel = 0;
  }

  /**
   * Creates a new instance of {@link Request} with the provided field values.
   */
  public Request(
      io.v.v23.uniqueid.Id spanId,
      io.v.v23.uniqueid.Id traceId,
      io.v.v23.vtrace.TraceFlags flags,
      int logLevel) {
    super(VDL_TYPE);

    this.spanId = spanId;

    this.traceId = traceId;

    this.flags = flags;

    this.logLevel = logLevel;
  }

  /**
   * The Id of the span that originated the RPC call.
   */
  public io.v.v23.uniqueid.Id getSpanId() {
    return this.spanId;
  }

  /**
   * The Id of the span that originated the RPC call.
   */
  public void setSpanId(io.v.v23.uniqueid.Id spanId) {
    this.spanId = spanId;
  }

  /**
   * The Id of the trace this call is a part of.
   */
  public io.v.v23.uniqueid.Id getTraceId() {
    return this.traceId;
  }

  /**
   * The Id of the trace this call is a part of.
   */
  public void setTraceId(io.v.v23.uniqueid.Id traceId) {
    this.traceId = traceId;
  }

  public io.v.v23.vtrace.TraceFlags getFlags() {
    return this.flags;
  }

  public void setFlags(io.v.v23.vtrace.TraceFlags flags) {
    this.flags = flags;
  }

  public int getLogLevel() {
    return this.logLevel;
  }

  public void setLogLevel(int logLevel) {
    this.logLevel = logLevel;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Request other = (Request) obj;

    if (this.spanId == null) {
      if (other.spanId != null) {
        return false;
      }
    } else if (!this.spanId.equals(other.spanId)) {
      return false;
    }

    if (this.traceId == null) {
      if (other.traceId != null) {
        return false;
      }
    } else if (!this.traceId.equals(other.traceId)) {
      return false;
    }

    if (this.flags == null) {
      if (other.flags != null) {
        return false;
      }
    } else if (!this.flags.equals(other.flags)) {
      return false;
    }

    if (this.logLevel != other.logLevel) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.spanId == null ? 0 : this.spanId.hashCode());

    result = prime * result + (this.traceId == null ? 0 : this.traceId.hashCode());

    result = prime * result + (this.flags == null ? 0 : this.flags.hashCode());

    result = prime * result + this.logLevel;

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "spanId:" + this.spanId;

    result += ", ";

    result += "traceId:" + this.traceId;

    result += ", ";

    result += "flags:" + this.flags;

    result += ", ";

    result += "logLevel:" + this.logLevel;

    return result + "}";
  }
}
