// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s): vomdata.vdl
package io.v.v23.vom.testdata.data81;

/**
 * Constants defined in all VDL files in this package.
 */
public final class Constants {

  /* The following constants originate in file: vomdata.vdl */

  /**
   * Tests contains the testcases to use to test vom encoding and decoding.
   */
  public static final java.util.List<io.v.v23.vom.testdata.types.TestCase> TESTS =
      new com.google.common.collect.ImmutableList.Builder<io.v.v23.vom.testdata.types.TestCase>()
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "true",
                  new io.v.v23.vdl.VdlAny(java.lang.Boolean.class, true),
                  "bool",
                  "810201",
                  "81",
                  "",
                  "0201"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "false",
                  new io.v.v23.vdl.VdlAny(java.lang.Boolean.class, false),
                  "bool",
                  "810200",
                  "81",
                  "",
                  "0200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "\"\"",
                  new io.v.v23.vdl.VdlAny(java.lang.String.class, ""),
                  "string",
                  "810600",
                  "81",
                  "",
                  "0600"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "\"abc\"",
                  new io.v.v23.vdl.VdlAny(java.lang.String.class, "abc"),
                  "string",
                  "810603616263",
                  "81",
                  "",
                  "0603616263"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]byte(\"\")",
                  new io.v.v23.vdl.VdlAny(byte[].class, new byte[] {}),
                  "[]byte",
                  "814e00",
                  "81",
                  "",
                  "4e00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]byte(\"\\xff\\x00\\x01\")",
                  new io.v.v23.vdl.VdlAny(
                      byte[].class, new byte[] {(byte) 0xff, (byte) 0, (byte) 0x1}),
                  "[]byte",
                  "814e03ff0001",
                  "81",
                  "",
                  "4e03ff0001"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]byte(\"adef\")",
                  new io.v.v23.vdl.VdlAny(
                      byte[].class,
                      new byte[] {(byte) 0x61, (byte) 0x64, (byte) 0x65, (byte) 0x66}),
                  "[]byte",
                  "814e0461646566",
                  "81",
                  "",
                  "4e0461646566"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "byte(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Byte.class, (byte) 0),
                  "byte",
                  "810400",
                  "81",
                  "",
                  "0400"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "byte(127)",
                  new io.v.v23.vdl.VdlAny(java.lang.Byte.class, (byte) 0x7f),
                  "byte",
                  "81047f",
                  "81",
                  "",
                  "047f"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "byte(255)",
                  new io.v.v23.vdl.VdlAny(java.lang.Byte.class, (byte) 0xff),
                  "byte",
                  "8104ffff",
                  "81",
                  "",
                  "04ffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16()),
                  "uint16",
                  "810800",
                  "81",
                  "",
                  "0800"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(1)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 1)),
                  "uint16",
                  "810801",
                  "81",
                  "",
                  "0801"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(2)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 2)),
                  "uint16",
                  "810802",
                  "81",
                  "",
                  "0802"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(63)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 63)),
                  "uint16",
                  "81083f",
                  "81",
                  "",
                  "083f"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 64)),
                  "uint16",
                  "810840",
                  "81",
                  "",
                  "0840"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(127)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 127)),
                  "uint16",
                  "81087f",
                  "81",
                  "",
                  "087f"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(128)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 128)),
                  "uint16",
                  "8108ff80",
                  "81",
                  "",
                  "08ff80"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(255)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 255)),
                  "uint16",
                  "8108ffff",
                  "81",
                  "",
                  "08ffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(256)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 256)),
                  "uint16",
                  "8108fe0100",
                  "81",
                  "",
                  "08fe0100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(32766)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 32766)),
                  "uint16",
                  "8108fe7ffe",
                  "81",
                  "",
                  "08fe7ffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(32767)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 32767)),
                  "uint16",
                  "8108fe7fff",
                  "81",
                  "",
                  "08fe7fff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(65534)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 65534)),
                  "uint16",
                  "8108fefffe",
                  "81",
                  "",
                  "08fefffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(65535)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 65535)),
                  "uint16",
                  "8108feffff",
                  "81",
                  "",
                  "08feffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32()),
                  "uint32",
                  "810a00",
                  "81",
                  "",
                  "0a00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(8388606)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 8388606L)),
                  "uint32",
                  "810afd7ffffe",
                  "81",
                  "",
                  "0afd7ffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(8388607)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 8388607L)),
                  "uint32",
                  "810afd7fffff",
                  "81",
                  "",
                  "0afd7fffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(16777214)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 16777214L)),
                  "uint32",
                  "810afdfffffe",
                  "81",
                  "",
                  "0afdfffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(16777215)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 16777215L)),
                  "uint32",
                  "810afdffffff",
                  "81",
                  "",
                  "0afdffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(2147483646)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 2147483646L)),
                  "uint32",
                  "810afc7ffffffe",
                  "81",
                  "",
                  "0afc7ffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(2147483647)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 2147483647L)),
                  "uint32",
                  "810afc7fffffff",
                  "81",
                  "",
                  "0afc7fffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(4294967294)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 4294967294L)),
                  "uint32",
                  "810afcfffffffe",
                  "81",
                  "",
                  "0afcfffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(4294967295)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 4294967295L)),
                  "uint32",
                  "810afcffffffff",
                  "81",
                  "",
                  "0afcffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64()),
                  "uint64",
                  "810c00",
                  "81",
                  "",
                  "0c00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(549755813886)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(549755813886L)),
                  "uint64",
                  "810cfb7ffffffffe",
                  "81",
                  "",
                  "0cfb7ffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(549755813887)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(549755813887L)),
                  "uint64",
                  "810cfb7fffffffff",
                  "81",
                  "",
                  "0cfb7fffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(1099511627774)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(1099511627774L)),
                  "uint64",
                  "810cfbfffffffffe",
                  "81",
                  "",
                  "0cfbfffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(1099511627775)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(1099511627775L)),
                  "uint64",
                  "810cfbffffffffff",
                  "81",
                  "",
                  "0cfbffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(140737488355326)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(140737488355326L)),
                  "uint64",
                  "810cfa7ffffffffffe",
                  "81",
                  "",
                  "0cfa7ffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(140737488355327)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(140737488355327L)),
                  "uint64",
                  "810cfa7fffffffffff",
                  "81",
                  "",
                  "0cfa7fffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(281474976710654)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(281474976710654L)),
                  "uint64",
                  "810cfafffffffffffe",
                  "81",
                  "",
                  "0cfafffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(281474976710655)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(281474976710655L)),
                  "uint64",
                  "810cfaffffffffffff",
                  "81",
                  "",
                  "0cfaffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(36028797018963966)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(36028797018963966L)),
                  "uint64",
                  "810cf97ffffffffffffe",
                  "81",
                  "",
                  "0cf97ffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(36028797018963967)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(36028797018963967L)),
                  "uint64",
                  "810cf97fffffffffffff",
                  "81",
                  "",
                  "0cf97fffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(72057594037927934)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(72057594037927934L)),
                  "uint64",
                  "810cf9fffffffffffffe",
                  "81",
                  "",
                  "0cf9fffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(72057594037927935)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(72057594037927935L)),
                  "uint64",
                  "810cf9ffffffffffffff",
                  "81",
                  "",
                  "0cf9ffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(9223372036854775806)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class,
                      new io.v.v23.vdl.VdlUint64(9223372036854775806L)),
                  "uint64",
                  "810cf87ffffffffffffffe",
                  "81",
                  "",
                  "0cf87ffffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(9223372036854775807)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class,
                      new io.v.v23.vdl.VdlUint64(9223372036854775807L)),
                  "uint64",
                  "810cf87fffffffffffffff",
                  "81",
                  "",
                  "0cf87fffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(18446744073709551614)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(-2L)),
                  "uint64",
                  "810cf8fffffffffffffffe",
                  "81",
                  "",
                  "0cf8fffffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(18446744073709551615)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(-1L)),
                  "uint64",
                  "810cf8ffffffffffffffff",
                  "81",
                  "",
                  "0cf8ffffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 0),
                  "int16",
                  "810e00",
                  "81",
                  "",
                  "0e00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 1),
                  "int16",
                  "810e02",
                  "81",
                  "",
                  "0e02"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(2)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 2),
                  "int16",
                  "810e04",
                  "81",
                  "",
                  "0e04"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(63)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 63),
                  "int16",
                  "810e7e",
                  "81",
                  "",
                  "0e7e"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(64)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 64),
                  "int16",
                  "810eff80",
                  "81",
                  "",
                  "0eff80"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(127)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 127),
                  "int16",
                  "810efffe",
                  "81",
                  "",
                  "0efffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(128)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 128),
                  "int16",
                  "810efe0100",
                  "81",
                  "",
                  "0efe0100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(255)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 255),
                  "int16",
                  "810efe01fe",
                  "81",
                  "",
                  "0efe01fe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(256)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 256),
                  "int16",
                  "810efe0200",
                  "81",
                  "",
                  "0efe0200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(32766)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 32766),
                  "int16",
                  "810efefffc",
                  "81",
                  "",
                  "0efefffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(32767)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 32767),
                  "int16",
                  "810efefffe",
                  "81",
                  "",
                  "0efefffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 0),
                  "int32",
                  "811000",
                  "81",
                  "",
                  "1000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(8388606)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 8388606),
                  "int32",
                  "8110fdfffffc",
                  "81",
                  "",
                  "10fdfffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(8388607)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 8388607),
                  "int32",
                  "8110fdfffffe",
                  "81",
                  "",
                  "10fdfffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(16777214)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 16777214),
                  "int32",
                  "8110fc01fffffc",
                  "81",
                  "",
                  "10fc01fffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(16777215)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 16777215),
                  "int32",
                  "8110fc01fffffe",
                  "81",
                  "",
                  "10fc01fffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(2147483646)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 2147483646),
                  "int32",
                  "8110fcfffffffc",
                  "81",
                  "",
                  "10fcfffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(2147483647)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 2147483647),
                  "int32",
                  "8110fcfffffffe",
                  "81",
                  "",
                  "10fcfffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 0L),
                  "int64",
                  "811200",
                  "81",
                  "",
                  "1200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 1L),
                  "int64",
                  "811202",
                  "81",
                  "",
                  "1202"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(2)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 2L),
                  "int64",
                  "811204",
                  "81",
                  "",
                  "1204"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(549755813886)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 549755813886L),
                  "int64",
                  "8112fbfffffffffc",
                  "81",
                  "",
                  "12fbfffffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(549755813887)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 549755813887L),
                  "int64",
                  "8112fbfffffffffe",
                  "81",
                  "",
                  "12fbfffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(1099511627774)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 1099511627774L),
                  "int64",
                  "8112fa01fffffffffc",
                  "81",
                  "",
                  "12fa01fffffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(1099511627775)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 1099511627775L),
                  "int64",
                  "8112fa01fffffffffe",
                  "81",
                  "",
                  "12fa01fffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(140737488355326)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 140737488355326L),
                  "int64",
                  "8112fafffffffffffc",
                  "81",
                  "",
                  "12fafffffffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(140737488355327)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 140737488355327L),
                  "int64",
                  "8112fafffffffffffe",
                  "81",
                  "",
                  "12fafffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(281474976710654)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 281474976710654L),
                  "int64",
                  "8112f901fffffffffffc",
                  "81",
                  "",
                  "12f901fffffffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(281474976710655)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 281474976710655L),
                  "int64",
                  "8112f901fffffffffffe",
                  "81",
                  "",
                  "12f901fffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(36028797018963966)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 36028797018963966L),
                  "int64",
                  "8112f9fffffffffffffc",
                  "81",
                  "",
                  "12f9fffffffffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(36028797018963967)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 36028797018963967L),
                  "int64",
                  "8112f9fffffffffffffe",
                  "81",
                  "",
                  "12f9fffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(72057594037927934)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 72057594037927934L),
                  "int64",
                  "8112f801fffffffffffffc",
                  "81",
                  "",
                  "12f801fffffffffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(72057594037927935)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 72057594037927935L),
                  "int64",
                  "8112f801fffffffffffffe",
                  "81",
                  "",
                  "12f801fffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(9223372036854775806)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 9223372036854775806L),
                  "int64",
                  "8112f8fffffffffffffffc",
                  "81",
                  "",
                  "12f8fffffffffffffffc"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(9223372036854775807)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 9223372036854775807L),
                  "int64",
                  "8112f8fffffffffffffffe",
                  "81",
                  "",
                  "12f8fffffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -1),
                  "int16",
                  "810e01",
                  "81",
                  "",
                  "0e01"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-2)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -2),
                  "int16",
                  "810e03",
                  "81",
                  "",
                  "0e03"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-64)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -64),
                  "int16",
                  "810e7f",
                  "81",
                  "",
                  "0e7f"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-65)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -65),
                  "int16",
                  "810eff81",
                  "81",
                  "",
                  "0eff81"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-128)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -128),
                  "int16",
                  "810effff",
                  "81",
                  "",
                  "0effff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-129)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -129),
                  "int16",
                  "810efe0101",
                  "81",
                  "",
                  "0efe0101"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-256)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -256),
                  "int16",
                  "810efe01ff",
                  "81",
                  "",
                  "0efe01ff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-257)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -257),
                  "int16",
                  "810efe0201",
                  "81",
                  "",
                  "0efe0201"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-32767)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -32767),
                  "int16",
                  "810efefffd",
                  "81",
                  "",
                  "0efefffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(-32768)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) -32768),
                  "int16",
                  "810efeffff",
                  "81",
                  "",
                  "0efeffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(-8388607)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, -8388607),
                  "int32",
                  "8110fdfffffd",
                  "81",
                  "",
                  "10fdfffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(-8388608)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, -8388608),
                  "int32",
                  "8110fdffffff",
                  "81",
                  "",
                  "10fdffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(-16777215)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, -16777215),
                  "int32",
                  "8110fc01fffffd",
                  "81",
                  "",
                  "10fc01fffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(-16777216)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, -16777216),
                  "int32",
                  "8110fc01ffffff",
                  "81",
                  "",
                  "10fc01ffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(-2147483647)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, -2147483647),
                  "int32",
                  "8110fcfffffffd",
                  "81",
                  "",
                  "10fcfffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(-2147483648)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, -2147483648),
                  "int32",
                  "8110fcffffffff",
                  "81",
                  "",
                  "10fcffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -1L),
                  "int64",
                  "811201",
                  "81",
                  "",
                  "1201"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-2)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -2L),
                  "int64",
                  "811203",
                  "81",
                  "",
                  "1203"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-549755813887)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -549755813887L),
                  "int64",
                  "8112fbfffffffffd",
                  "81",
                  "",
                  "12fbfffffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-549755813888)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -549755813888L),
                  "int64",
                  "8112fbffffffffff",
                  "81",
                  "",
                  "12fbffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-1099511627775)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -1099511627775L),
                  "int64",
                  "8112fa01fffffffffd",
                  "81",
                  "",
                  "12fa01fffffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-1099511627776)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -1099511627776L),
                  "int64",
                  "8112fa01ffffffffff",
                  "81",
                  "",
                  "12fa01ffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-140737488355327)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -140737488355327L),
                  "int64",
                  "8112fafffffffffffd",
                  "81",
                  "",
                  "12fafffffffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-140737488355328)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -140737488355328L),
                  "int64",
                  "8112faffffffffffff",
                  "81",
                  "",
                  "12faffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-281474976710655)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -281474976710655L),
                  "int64",
                  "8112f901fffffffffffd",
                  "81",
                  "",
                  "12f901fffffffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-281474976710656)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -281474976710656L),
                  "int64",
                  "8112f901ffffffffffff",
                  "81",
                  "",
                  "12f901ffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-36028797018963967)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -36028797018963967L),
                  "int64",
                  "8112f9fffffffffffffd",
                  "81",
                  "",
                  "12f9fffffffffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-36028797018963968)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -36028797018963968L),
                  "int64",
                  "8112f9ffffffffffffff",
                  "81",
                  "",
                  "12f9ffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-72057594037927935)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -72057594037927935L),
                  "int64",
                  "8112f801fffffffffffffd",
                  "81",
                  "",
                  "12f801fffffffffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-72057594037927936)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -72057594037927936L),
                  "int64",
                  "8112f801ffffffffffffff",
                  "81",
                  "",
                  "12f801ffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-9223372036854775807)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -9223372036854775807L),
                  "int64",
                  "8112f8fffffffffffffffd",
                  "81",
                  "",
                  "12f8fffffffffffffffd"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(-9223372036854775808)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, -9223372036854775808L),
                  "int64",
                  "8112f8ffffffffffffffff",
                  "81",
                  "",
                  "12f8ffffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float32(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Float.class, 0.0f),
                  "float32",
                  "811400",
                  "81",
                  "",
                  "1400"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float32(32.5)",
                  new io.v.v23.vdl.VdlAny(java.lang.Float.class, 32.5f),
                  "float32",
                  "8114fd404040",
                  "81",
                  "",
                  "14fd404040"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float32(-32.5)",
                  new io.v.v23.vdl.VdlAny(java.lang.Float.class, -32.5f),
                  "float32",
                  "8114fd4040c0",
                  "81",
                  "",
                  "14fd4040c0"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float64(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Double.class, 0.0),
                  "float64",
                  "811600",
                  "81",
                  "",
                  "1600"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float64(64.5)",
                  new io.v.v23.vdl.VdlAny(java.lang.Double.class, 64.5),
                  "float64",
                  "8116fd205040",
                  "81",
                  "",
                  "16fd205040"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float64(-64.5)",
                  new io.v.v23.vdl.VdlAny(java.lang.Double.class, -64.5),
                  "float64",
                  "8116fd2050c0",
                  "81",
                  "",
                  "16fd2050c0"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NBool(true)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NBool.class,
                      new io.v.v23.vom.testdata.types.NBool(true)),
                  "v.io/v23/vom/testdata/types.NBool bool",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15201",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e1",
                  "5201"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NBool(false)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NBool.class,
                      new io.v.v23.vom.testdata.types.NBool()),
                  "v.io/v23/vom/testdata/types.NBool bool",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15200",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NString(\"\")",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NString.class,
                      new io.v.v23.vom.testdata.types.NString()),
                  "v.io/v23/vom/testdata/types.NString string",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e537472696e670103e15200",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e537472696e670103e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NString(\"abc\")",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NString.class,
                      new io.v.v23.vom.testdata.types.NString("abc")),
                  "v.io/v23/vom/testdata/types.NString string",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e537472696e670103e15203616263",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e537472696e670103e1",
                  "5203616263"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteSlice(\"\")",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NByteSlice>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NByteSlice()),
                  "v.io/v23/vom/testdata/types.NByteSlice []byte",
                  "81512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465536c6963650102e15200",
                  "81",
                  "512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465536c6963650102e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteSlice(\"\\xff\\x00\\x01\")",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NByteSlice>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NByteSlice(
                          new com.google.common.collect.ImmutableList.Builder<java.lang.Byte>()
                              .add((byte) 0xff)
                              .add((byte) 0)
                              .add((byte) 0x1)
                              .build())),
                  "v.io/v23/vom/testdata/types.NByteSlice []byte",
                  "81512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465536c6963650102e15203ff0001",
                  "81",
                  "512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465536c6963650102e1",
                  "5203ff0001"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteSlice(\"abc\")",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NByteSlice>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NByteSlice(
                          new com.google.common.collect.ImmutableList.Builder<java.lang.Byte>()
                              .add((byte) 0x61)
                              .add((byte) 0x62)
                              .add((byte) 0x63)
                              .build())),
                  "v.io/v23/vom/testdata/types.NByteSlice []byte",
                  "81512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465536c6963650102e15203616263",
                  "81",
                  "512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465536c6963650102e1",
                  "5203616263"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteArray(\"\\x00\\x00\\x00\\x00\")",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByteArray.class,
                      new io.v.v23.vom.testdata.types.NByteArray()),
                  "v.io/v23/vom/testdata/types.NByteArray [4]byte",
                  "81512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1520000000000",
                  "81",
                  "512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1",
                  "520000000000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteArray(\"\\xff\\x00\\x01\\x00\")",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByteArray.class,
                      new io.v.v23.vom.testdata.types.NByteArray(
                          new byte[] {(byte) 0xff, (byte) 0, (byte) 0x1, (byte) 0})),
                  "v.io/v23/vom/testdata/types.NByteArray [4]byte",
                  "81512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e15200ff000100",
                  "81",
                  "512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1",
                  "5200ff000100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteArray(\"abcd\")",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByteArray.class,
                      new io.v.v23.vom.testdata.types.NByteArray(
                          new byte[] {(byte) 0x61, (byte) 0x62, (byte) 0x63, (byte) 0x64})),
                  "v.io/v23/vom/testdata/types.NByteArray [4]byte",
                  "81512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1520061626364",
                  "81",
                  "512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1",
                  "520061626364"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByte(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByte.class,
                      new io.v.v23.vom.testdata.types.NByte()),
                  "v.io/v23/vom/testdata/types.NByte byte",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e427974650102e15200",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e427974650102e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByte(127)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByte.class,
                      new io.v.v23.vom.testdata.types.NByte((byte) 0x7f)),
                  "v.io/v23/vom/testdata/types.NByte byte",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e427974650102e1527f",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e427974650102e1",
                  "527f"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByte(255)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByte.class,
                      new io.v.v23.vom.testdata.types.NByte((byte) 0xff)),
                  "v.io/v23/vom/testdata/types.NByte byte",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e427974650102e152ffff",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e427974650102e1",
                  "52ffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUint16(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUint16.class,
                      new io.v.v23.vom.testdata.types.NUint16()),
                  "v.io/v23/vom/testdata/types.NUint16 uint16",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7431360104e15200",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7431360104e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUint16(65535)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUint16.class,
                      new io.v.v23.vom.testdata.types.NUint16((short) 65535)),
                  "v.io/v23/vom/testdata/types.NUint16 uint16",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7431360104e152feffff",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7431360104e1",
                  "52feffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUint32(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUint32.class,
                      new io.v.v23.vom.testdata.types.NUint32()),
                  "v.io/v23/vom/testdata/types.NUint32 uint32",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7433320105e15200",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7433320105e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUint32(4294967295)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUint32.class,
                      new io.v.v23.vom.testdata.types.NUint32((int) 4294967295L)),
                  "v.io/v23/vom/testdata/types.NUint32 uint32",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7433320105e152fcffffffff",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7433320105e1",
                  "52fcffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUint64(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUint64.class,
                      new io.v.v23.vom.testdata.types.NUint64()),
                  "v.io/v23/vom/testdata/types.NUint64 uint64",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7436340106e15200",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7436340106e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUint64(18446744073709551615)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUint64.class,
                      new io.v.v23.vom.testdata.types.NUint64(-1L)),
                  "v.io/v23/vom/testdata/types.NUint64 uint64",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7436340106e152f8ffffffffffffffff",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7436340106e1",
                  "52f8ffffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt16(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt16.class,
                      new io.v.v23.vom.testdata.types.NInt16()),
                  "v.io/v23/vom/testdata/types.NInt16 int16",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e15200",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt16(32767)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt16.class,
                      new io.v.v23.vom.testdata.types.NInt16((short) 32767)),
                  "v.io/v23/vom/testdata/types.NInt16 int16",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e152fefffe",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e1",
                  "52fefffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt16(-32768)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt16.class,
                      new io.v.v23.vom.testdata.types.NInt16((short) -32768)),
                  "v.io/v23/vom/testdata/types.NInt16 int16",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e152feffff",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e1",
                  "52feffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt32(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt32.class,
                      new io.v.v23.vom.testdata.types.NInt32()),
                  "v.io/v23/vom/testdata/types.NInt32 int32",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e15200",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt32(2147483647)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt32.class,
                      new io.v.v23.vom.testdata.types.NInt32(2147483647)),
                  "v.io/v23/vom/testdata/types.NInt32 int32",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e152fcfffffffe",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e1",
                  "52fcfffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt32(-2147483648)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt32.class,
                      new io.v.v23.vom.testdata.types.NInt32(-2147483648)),
                  "v.io/v23/vom/testdata/types.NInt32 int32",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e152fcffffffff",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e1",
                  "52fcffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt64(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt64.class,
                      new io.v.v23.vom.testdata.types.NInt64()),
                  "v.io/v23/vom/testdata/types.NInt64 int64",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e15200",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt64(9223372036854775807)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt64.class,
                      new io.v.v23.vom.testdata.types.NInt64(9223372036854775807L)),
                  "v.io/v23/vom/testdata/types.NInt64 int64",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e152f8fffffffffffffffe",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e1",
                  "52f8fffffffffffffffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt64(-9223372036854775808)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt64.class,
                      new io.v.v23.vom.testdata.types.NInt64(-9223372036854775808L)),
                  "v.io/v23/vom/testdata/types.NInt64 int64",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e152f8ffffffffffffffff",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e1",
                  "52f8ffffffffffffffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NFloat32(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NFloat32.class,
                      new io.v.v23.vom.testdata.types.NFloat32()),
                  "v.io/v23/vom/testdata/types.NFloat32 float32",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae15200",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NFloat32(32.5)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NFloat32.class,
                      new io.v.v23.vom.testdata.types.NFloat32(32.5f)),
                  "v.io/v23/vom/testdata/types.NFloat32 float32",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae152fd404040",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae1",
                  "52fd404040"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NFloat32(-32.5)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NFloat32.class,
                      new io.v.v23.vom.testdata.types.NFloat32(-32.5f)),
                  "v.io/v23/vom/testdata/types.NFloat32 float32",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae152fd4040c0",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae1",
                  "52fd4040c0"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NFloat64(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NFloat64.class,
                      new io.v.v23.vom.testdata.types.NFloat64()),
                  "v.io/v23/vom/testdata/types.NFloat64 float64",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be15200",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NFloat64(64.5)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NFloat64.class,
                      new io.v.v23.vom.testdata.types.NFloat64(64.5)),
                  "v.io/v23/vom/testdata/types.NFloat64 float64",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be152fd205040",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be1",
                  "52fd205040"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NFloat64(-64.5)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NFloat64.class,
                      new io.v.v23.vom.testdata.types.NFloat64(-64.5)),
                  "v.io/v23/vom/testdata/types.NFloat64 float64",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be152fd2050c0",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be1",
                  "52fd2050c0"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NArray2Uint64{1, 2}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NArray2Uint64.class,
                      new io.v.v23.vom.testdata.types.NArray2Uint64(
                          new io.v.v23.vdl.VdlUint64[] {
                            new io.v.v23.vdl.VdlUint64(1L), new io.v.v23.vdl.VdlUint64(2L)
                          })),
                  "v.io/v23/vom/testdata/types.NArray2Uint64 [2]uint64",
                  "815131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e15203000102",
                  "81",
                  "5131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e1",
                  "5203000102"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]uint64{1, 2}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          java.util.List<io.v.v23.vdl.VdlUint64>>() {}.getType(),
                      new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlUint64>()
                          .add(new io.v.v23.vdl.VdlUint64(1L))
                          .add(new io.v.v23.vdl.VdlUint64(2L))
                          .build()),
                  "[]uint64",
                  "815104030106e15203020102",
                  "81",
                  "5104030106e1",
                  "5203020102"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NListUint64{1, 2}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NListUint64>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NListUint64(
                          new com.google.common.collect.ImmutableList.Builder<
                                  io.v.v23.vdl.VdlUint64>()
                              .add(new io.v.v23.vdl.VdlUint64(1L))
                              .add(new io.v.v23.vdl.VdlUint64(2L))
                              .build())),
                  "v.io/v23/vom/testdata/types.NListUint64 []uint64",
                  "81512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e15203020102",
                  "81",
                  "512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1",
                  "5203020102"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "set[uint64]{1}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          java.util.Set<io.v.v23.vdl.VdlUint64>>() {}.getType(),
                      new com.google.common.collect.ImmutableSet.Builder<io.v.v23.vdl.VdlUint64>()
                          .add(new io.v.v23.vdl.VdlUint64(1L))
                          .build()),
                  "set[uint64]",
                  "815104040106e152020101",
                  "81",
                  "5104040106e1",
                  "52020101"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NSetUint64{1}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NSetUint64>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NSetUint64(
                          new com.google.common.collect.ImmutableSet.Builder<
                                  io.v.v23.vdl.VdlUint64>()
                              .add(new io.v.v23.vdl.VdlUint64(1L))
                              .build())),
                  "v.io/v23/vom/testdata/types.NSetUint64 set[uint64]",
                  "81512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e152020101",
                  "81",
                  "512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e1",
                  "52020101"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "map[uint64]string{1: \"abc\"}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          java.util.Map<io.v.v23.vdl.VdlUint64, java.lang.String>>() {}.getType(),
                      new com.google.common.collect.ImmutableMap.Builder<
                              io.v.v23.vdl.VdlUint64, java.lang.String>()
                          .put(new io.v.v23.vdl.VdlUint64(1L), "abc")
                          .build()),
                  "map[uint64]string",
                  "8151060501060203e15206010103616263",
                  "81",
                  "51060501060203e1",
                  "5206010103616263"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NMapUint64String{1: \"abc\"}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NMapUint64String>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NMapUint64String(
                          new com.google.common.collect.ImmutableMap.Builder<
                                  io.v.v23.vdl.VdlUint64, java.lang.String>()
                              .put(new io.v.v23.vdl.VdlUint64(1L), "abc")
                              .build())),
                  "v.io/v23/vom/testdata/types.NMapUint64String map[uint64]string",
                  "81513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e15206010103616263",
                  "81",
                  "513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1",
                  "5206010103616263"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NStruct{A: true, B: \"abc\", C: 123}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NStruct.class,
                      new io.v.v23.vom.testdata.types.NStruct(true, "abc", 123L)),
                  "v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64}",
                  "81513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1520b0001010361626302fff6e1",
                  "81",
                  "513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1",
                  "520b0001010361626302fff6e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "?types.NStruct(nil)",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vdl.VdlOptional<
                              io.v.v23.vom.testdata.types.NStruct>>() {}.getType(),
                      new io.v.v23.vdl.VdlOptional<io.v.v23.vom.testdata.types.NStruct>(
                          new com.google.common.reflect.TypeToken<
                              io.v.v23.vdl.VdlOptional<
                                  io.v.v23.vom.testdata.types.NStruct>>() {}.getType())),
                  "?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64}",
                  "81533b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1510408012ae15201e0",
                  "81",
                  "533b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1510408012ae1",
                  "5201e0"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NEnum.A",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NEnum.class, io.v.v23.vom.testdata.types.NEnum.A),
                  "v.io/v23/vom/testdata/types.NEnum enum{A;B;C}",
                  "81512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e15200",
                  "81",
                  "512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NEnum.B",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NEnum.class, io.v.v23.vom.testdata.types.NEnum.B),
                  "v.io/v23/vom/testdata/types.NEnum enum{A;B;C}",
                  "81512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e15201",
                  "81",
                  "512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1",
                  "5201"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NEnum.C",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NEnum.class, io.v.v23.vom.testdata.types.NEnum.C),
                  "v.io/v23/vom/testdata/types.NEnum enum{A;B;C}",
                  "81512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e15202",
                  "81",
                  "512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1",
                  "5202"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{A: true}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.A(true)),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152020001",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52020001"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{A: false}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.A()),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152020000",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52020000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{B: \"\"}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.B("")),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152020100",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52020100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{B: \"abc\"}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.B("abc")),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152050103616263",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52050103616263"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{C: 0}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.C(0L)),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152020200",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52020200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{C: 123}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.C(123L)),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1520302fff6",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "520302fff6"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{C: -123}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.C(-123L)),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1520302fff5",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "520302fff5"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MBool(true)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MBool.class,
                      new io.v.v23.vom.testdata.types.MBool(true)),
                  "v.io/v23/vom/testdata/types.MBool bool",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e15201",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1",
                  "5201"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MBool(false)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MBool.class,
                      new io.v.v23.vom.testdata.types.MBool()),
                  "v.io/v23/vom/testdata/types.MBool bool",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e15200",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MStruct{A: true, B: true, C: true}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MStruct.class,
                      new io.v.v23.vom.testdata.types.MStruct(
                          true,
                          new io.v.v23.vom.testdata.types.NBool(true),
                          new io.v.v23.vom.testdata.types.MBool(true),
                          new io.v.v23.vdl.VdlOptional<io.v.v23.vom.testdata.types.NStruct>(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vdl.VdlOptional<
                                      io.v.v23.vom.testdata.types.NStruct>>() {}.getType()),
                          new io.v.v23.vdl.VdlTypeObject(),
                          new io.v.v23.vdl.VdlAny())),
                  "v.io/v23/vom/testdata/types.MStruct struct{A bool;B v.io/v23/vom/testdata/types.NBool bool;C v.io/v23/vom/testdata/types.MBool bool;D ?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};E typeobject;F any}",
                  "815327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e152000007000101010201e1",
                  "81",
                  "5327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e1",
                  "52000007000101010201e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MStruct{}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MStruct.class,
                      new io.v.v23.vom.testdata.types.MStruct()),
                  "v.io/v23/vom/testdata/types.MStruct struct{A bool;B v.io/v23/vom/testdata/types.NBool bool;C v.io/v23/vom/testdata/types.MBool bool;D ?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};E typeobject;F any}",
                  "815327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e152000001e1",
                  "81",
                  "5327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e1",
                  "52000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MStruct{D: {}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MStruct.class,
                      new io.v.v23.vom.testdata.types.MStruct(
                          false,
                          new io.v.v23.vom.testdata.types.NBool(),
                          new io.v.v23.vom.testdata.types.MBool(),
                          io.v.v23.vdl.VdlOptional.of(new io.v.v23.vom.testdata.types.NStruct()),
                          new io.v.v23.vdl.VdlTypeObject(),
                          new io.v.v23.vdl.VdlAny())),
                  "v.io/v23/vom/testdata/types.MStruct struct{A bool;B v.io/v23/vom/testdata/types.NBool bool;C v.io/v23/vom/testdata/types.MBool bool;D ?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};E typeobject;F any}",
                  "815327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e15200000303e1e1",
                  "81",
                  "5327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e1",
                  "5200000303e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MStruct{D: {A: true, B: \"abc\", C: 123}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MStruct.class,
                      new io.v.v23.vom.testdata.types.MStruct(
                          false,
                          new io.v.v23.vom.testdata.types.NBool(),
                          new io.v.v23.vom.testdata.types.MBool(),
                          io.v.v23.vdl.VdlOptional.of(
                              new io.v.v23.vom.testdata.types.NStruct(true, "abc", 123L)),
                          new io.v.v23.vdl.VdlTypeObject(),
                          new io.v.v23.vdl.VdlAny())),
                  "v.io/v23/vom/testdata/types.MStruct struct{A bool;B v.io/v23/vom/testdata/types.NBool bool;C v.io/v23/vom/testdata/types.MBool bool;D ?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};E typeobject;F any}",
                  "815327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e15200000d030001010361626302fff6e1e1",
                  "81",
                  "5327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e1",
                  "5200000d030001010361626302fff6e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MStruct{F: \"abc\"}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MStruct.class,
                      new io.v.v23.vom.testdata.types.MStruct(
                          false,
                          new io.v.v23.vom.testdata.types.NBool(),
                          new io.v.v23.vom.testdata.types.MBool(),
                          new io.v.v23.vdl.VdlOptional<io.v.v23.vom.testdata.types.NStruct>(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vdl.VdlOptional<
                                      io.v.v23.vom.testdata.types.NStruct>>() {}.getType()),
                          new io.v.v23.vdl.VdlTypeObject(),
                          new io.v.v23.vdl.VdlAny(java.lang.String.class, "abc"))),
                  "v.io/v23/vom/testdata/types.MStruct struct{A bool;B v.io/v23/vom/testdata/types.NBool bool;C v.io/v23/vom/testdata/types.MBool bool;D ?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};E typeobject;F any}",
                  "815327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e152010301040805000003616263e1",
                  "81",
                  "5327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e1",
                  "52010301040805000003616263e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MStruct{F: types.MBool(true)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MStruct.class,
                      new io.v.v23.vom.testdata.types.MStruct(
                          false,
                          new io.v.v23.vom.testdata.types.NBool(),
                          new io.v.v23.vom.testdata.types.MBool(),
                          new io.v.v23.vdl.VdlOptional<io.v.v23.vom.testdata.types.NStruct>(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vdl.VdlOptional<
                                      io.v.v23.vom.testdata.types.NStruct>>() {}.getType()),
                          new io.v.v23.vdl.VdlTypeObject(),
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.MBool.class,
                              new io.v.v23.vom.testdata.types.MBool(true)))),
                  "v.io/v23/vom/testdata/types.MStruct struct{A bool;B v.io/v23/vom/testdata/types.NBool bool;C v.io/v23/vom/testdata/types.MBool bool;D ?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};E typeobject;F any}",
                  "815327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e152012b01010505000001e1",
                  "81",
                  "5327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e1",
                  "52012b01010505000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MStruct{F: ?types.NStruct{B: \"abc\"}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.MStruct.class,
                      new io.v.v23.vom.testdata.types.MStruct(
                          false,
                          new io.v.v23.vom.testdata.types.NBool(),
                          new io.v.v23.vom.testdata.types.MBool(),
                          new io.v.v23.vdl.VdlOptional<io.v.v23.vom.testdata.types.NStruct>(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vdl.VdlOptional<
                                      io.v.v23.vom.testdata.types.NStruct>>() {}.getType()),
                          new io.v.v23.vdl.VdlTypeObject(),
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vdl.VdlOptional<
                                      io.v.v23.vom.testdata.types.NStruct>>() {}.getType(),
                              io.v.v23.vdl.VdlOptional.of(
                                  new io.v.v23.vom.testdata.types.NStruct(false, "abc", 0L))))),
                  "v.io/v23/vom/testdata/types.MStruct struct{A bool;B v.io/v23/vom/testdata/types.NBool bool;C v.io/v23/vom/testdata/types.MBool bool;D ?v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};E typeobject;F any}",
                  "815327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e152012c01060a0500000103616263e1e1",
                  "81",
                  "5327000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e15527000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d426f6f6c0101e1593b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1570408012de1514d060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d53747275637401060001410101e1000142012ae1000143012be1000144012ce1000145010ee1000146010fe1e1",
                  "52012c01060a0500000103616263e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MList{{4, 2}, {}, {99}}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.MList>() {}.getType(),
                      new io.v.v23.vom.testdata.types.MList(
                          new com.google.common.collect.ImmutableList.Builder<
                                  io.v.v23.vom.testdata.types.NListUint64>()
                              .add(
                                  new io.v.v23.vom.testdata.types.NListUint64(
                                      new com.google.common.collect.ImmutableList.Builder<
                                              io.v.v23.vdl.VdlUint64>()
                                          .add(new io.v.v23.vdl.VdlUint64(4L))
                                          .add(new io.v.v23.vdl.VdlUint64(2L))
                                          .build()))
                              .add(new io.v.v23.vom.testdata.types.NListUint64())
                              .add(
                                  new io.v.v23.vom.testdata.types.NListUint64(
                                      new com.google.common.collect.ImmutableList.Builder<
                                              io.v.v23.vdl.VdlUint64>()
                                          .add(new io.v.v23.vdl.VdlUint64(99L))
                                          .build()))
                              .build())),
                  "v.io/v23/vom/testdata/types.MList []v.io/v23/vom/testdata/types.NListUint64 []uint64",
                  "81532d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e15127030021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d4c697374012ae1520703020402000163",
                  "81",
                  "532d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e15127030021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d4c697374012ae1",
                  "520703020402000163"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MMap{4.5: {2, 3}}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.MMap>() {}.getType(),
                      new io.v.v23.vom.testdata.types.MMap(
                          new com.google.common.collect.ImmutableMap.Builder<
                                  io.v.v23.vom.testdata.types.NFloat32,
                                  io.v.v23.vom.testdata.types.NListUint64>()
                              .put(
                                  new io.v.v23.vom.testdata.types.NFloat32(4.5f),
                                  new io.v.v23.vom.testdata.types.NListUint64(
                                      new com.google.common.collect.ImmutableList.Builder<
                                              io.v.v23.vdl.VdlUint64>()
                                          .add(new io.v.v23.vdl.VdlUint64(2L))
                                          .add(new io.v.v23.vdl.VdlUint64(3L))
                                          .build()))
                              .build())),
                  "v.io/v23/vom/testdata/types.MMap map[v.io/v23/vom/testdata/types.NFloat32 float32]v.io/v23/vom/testdata/types.NListUint64 []uint64",
                  "81532a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae1552d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e15128050020762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d4d6170012a022be1520701fe1240020203",
                  "81",
                  "532a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae1552d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e15128050020762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d4d6170012a022be1",
                  "520701fe1240020203"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.RecA{{}, {{}}}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.RecA>() {}.getType(),
                      new io.v.v23.vom.testdata.types.RecA(
                          new com.google.common.collect.ImmutableList.Builder<
                                  io.v.v23.vom.testdata.types.RecA>()
                              .add(new io.v.v23.vom.testdata.types.RecA())
                              .add(
                                  new io.v.v23.vom.testdata.types.RecA(
                                      new com.google.common.collect.ImmutableList.Builder<
                                              io.v.v23.vom.testdata.types.RecA>()
                                          .add(new io.v.v23.vom.testdata.types.RecA())
                                          .build()))
                              .build())),
                  "v.io/v23/vom/testdata/types.RecA []v.io/v23/vom/testdata/types.RecA",
                  "815126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563410129e1520402000100",
                  "81",
                  "5126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563410129e1",
                  "520402000100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.RecX{{}, {{}, {}}}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.RecX>() {}.getType(),
                      new io.v.v23.vom.testdata.types.RecX(
                          new com.google.common.collect.ImmutableList.Builder<
                                  io.v.v23.vom.testdata.types.RecY>()
                              .add(new io.v.v23.vom.testdata.types.RecY())
                              .add(
                                  new io.v.v23.vom.testdata.types.RecY(
                                      new com.google.common.collect.ImmutableList.Builder<
                                              io.v.v23.vom.testdata.types.RecX>()
                                          .add(new io.v.v23.vom.testdata.types.RecX())
                                          .add(new io.v.v23.vom.testdata.types.RecX())
                                          .build()))
                              .build())),
                  "v.io/v23/vom/testdata/types.RecX []v.io/v23/vom/testdata/types.RecY []v.io/v23/vom/testdata/types.RecX",
                  "81e25326030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563590129e15126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656358012ae152050200020000",
                  "81",
                  "e25326030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563590129e15126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656358012ae1",
                  "52050200020000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.Rec1{{{{{}}}}}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.Rec1>() {}.getType(),
                      new io.v.v23.vom.testdata.types.Rec1(
                          new com.google.common.collect.ImmutableList.Builder<
                                  io.v.v23.vom.testdata.types.Rec2>()
                              .add(
                                  new io.v.v23.vom.testdata.types.Rec2(
                                      new com.google.common.collect.ImmutableList.Builder<
                                              io.v.v23.vom.testdata.types.Rec3>()
                                          .add(
                                              new io.v.v23.vom.testdata.types.Rec3(
                                                  new com.google.common.collect.ImmutableList
                                                              .Builder<
                                                          io.v.v23.vom.testdata.types.Rec4>()
                                                      .add(
                                                          new io.v.v23.vom.testdata.types.Rec4(
                                                              new com.google.common.collect
                                                                          .ImmutableList.Builder<
                                                                      io.v.v23.vom.testdata.types
                                                                          .Rec1>()
                                                                  .add(
                                                                      new io.v.v23.vom.testdata
                                                                          .types.Rec1())
                                                                  .build()))
                                                      .build()))
                                          .build()))
                              .build())),
                  "v.io/v23/vom/testdata/types.Rec1 []v.io/v23/vom/testdata/types.Rec2 []v.io/v23/vom/testdata/types.Rec3 []v.io/v23/vom/testdata/types.Rec4 []v.io/v23/vom/testdata/types.Rec1",
                  "81e25726030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563340129e1e25526030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656333012ce1e25326030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656332012be15126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331012ae152050101010100",
                  "81",
                  "e25726030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563340129e1e25526030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656333012ce1e25326030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656332012be15126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331012ae1",
                  "52050101010100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.RecStruct{A: {}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.RecStruct.class,
                      new io.v.v23.vom.testdata.types.RecStruct(
                          io.v.v23.vdl.VdlOptional.of(
                              new io.v.v23.vom.testdata.types.RecStruct()))),
                  "v.io/v23/vom/testdata/types.RecStruct struct{A ?v.io/v23/vom/testdata/types.RecStruct}",
                  "81e25304080129e15131060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5265635374727563740101000141012ae1e1520300e1e1",
                  "81",
                  "e25304080129e15131060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5265635374727563740101000141012ae1e1",
                  "520300e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.RecStruct{A: {A: {}}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.RecStruct.class,
                      new io.v.v23.vom.testdata.types.RecStruct(
                          io.v.v23.vdl.VdlOptional.of(
                              new io.v.v23.vom.testdata.types.RecStruct(
                                  io.v.v23.vdl.VdlOptional.of(
                                      new io.v.v23.vom.testdata.types.RecStruct()))))),
                  "v.io/v23/vom/testdata/types.RecStruct struct{A ?v.io/v23/vom/testdata/types.RecStruct}",
                  "81e25304080129e15131060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5265635374727563740101000141012ae1e152050000e1e1e1",
                  "81",
                  "e25304080129e15131060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5265635374727563740101000141012ae1e1",
                  "52050000e1e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.Rec1234All{A: {A: {{}}, Rec1234: {{}}}, B: {B: {{}}, Rec1234: {{R2: {{}}}}}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.Rec1234All.class,
                      new io.v.v23.vom.testdata.types.Rec1234All(
                          new io.v.v23.vom.testdata.types.Rec1234A(
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vom.testdata.types.Rec1234A>()
                                  .add(new io.v.v23.vom.testdata.types.Rec1234A())
                                  .build(),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vom.testdata.types.Rec1234>()
                                  .add(new io.v.v23.vom.testdata.types.Rec1234())
                                  .build()),
                          new io.v.v23.vom.testdata.types.Rec1234B(
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vom.testdata.types.Rec1234B>()
                                  .add(new io.v.v23.vom.testdata.types.Rec1234B())
                                  .build(),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vom.testdata.types.Rec1234>()
                                  .add(
                                      new io.v.v23.vom.testdata.types.Rec1234(
                                          new io.v.v23.vom.testdata.types.Rec1(),
                                          new io.v.v23.vom.testdata.types.Rec2(
                                              new com.google.common.collect.ImmutableList.Builder<
                                                      io.v.v23.vom.testdata.types.Rec3>()
                                                  .add(new io.v.v23.vom.testdata.types.Rec3())
                                                  .build()),
                                          new io.v.v23.vom.testdata.types.Rec3(),
                                          new io.v.v23.vom.testdata.types.Rec4()))
                                  .build()))),
                  "v.io/v23/vom/testdata/types.Rec1234All struct{A v.io/v23/vom/testdata/types.Rec1234A struct{A []v.io/v23/vom/testdata/types.Rec1234A;Rec1234 []v.io/v23/vom/testdata/types.Rec1234 struct{R1 v.io/v23/vom/testdata/types.Rec1 []v.io/v23/vom/testdata/types.Rec2 []v.io/v23/vom/testdata/types.Rec3 []v.io/v23/vom/testdata/types.Rec4 []v.io/v23/vom/testdata/types.Rec1;R2 v.io/v23/vom/testdata/types.Rec2;R3 v.io/v23/vom/testdata/types.Rec3;R4 v.io/v23/vom/testdata/types.Rec4}};B v.io/v23/vom/testdata/types.Rec1234B struct{B []v.io/v23/vom/testdata/types.Rec1234B;Rec1234 []v.io/v23/vom/testdata/types.Rec1234}}",
                  "81e2550403012ae1e26126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656334012ee1e25f26030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563330131e1e25d26030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563320130e15b26030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331012fe15945060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331323334010400025231012ee100025232012fe1000252330130e1000252340131e1e1570403012de1533c060024762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331323334410102000141012be1000752656331323334012ce1e1e26504030132e1633c060024762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563313233344201020001420133e1000752656331323334012ce1e15138060026762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331323334416c6c0102000141012ae10001420132e1e15214000001e10101e1e1010001e10101010100e1e1e1",
                  "81",
                  "e2550403012ae1e26126030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656334012ee1e25f26030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563330131e1e25d26030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563320130e15b26030020762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331012fe15945060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331323334010400025231012ee100025232012fe1000252330130e1000252340131e1e1570403012de1533c060024762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331323334410102000141012be1000752656331323334012ce1e1e26504030132e1633c060024762e696f2f7632332f766f6d2f74657374646174612f74797065732e526563313233344201020001420133e1000752656331323334012ce1e15138060026762e696f2f7632332f766f6d2f74657374646174612f74797065732e52656331323334416c6c0102000141012ae10001420132e1e1",
                  "5214000001e10101e1e1010001e10101010100e1e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(any)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class, new io.v.v23.vdl.VdlTypeObject()),
                  "typeobject",
                  "811c010f00",
                  "81",
                  "",
                  "1c010f00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(bool)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)),
                  "typeobject",
                  "811c010100",
                  "81",
                  "",
                  "1c010100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(uint16)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint16.class)),
                  "typeobject",
                  "811c010400",
                  "81",
                  "",
                  "1c010400"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(uint32)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint32.class)),
                  "typeobject",
                  "811c010500",
                  "81",
                  "",
                  "1c010500"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(uint64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint64.class)),
                  "typeobject",
                  "811c010600",
                  "81",
                  "",
                  "1c010600"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(int16)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Short.class)),
                  "typeobject",
                  "811c010700",
                  "81",
                  "",
                  "1c010700"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(int32)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)),
                  "typeobject",
                  "811c010800",
                  "81",
                  "",
                  "1c010800"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(int64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)),
                  "typeobject",
                  "811c010900",
                  "81",
                  "",
                  "1c010900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(int16)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Short.class)),
                  "typeobject",
                  "811c010700",
                  "81",
                  "",
                  "1c010700"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(int32)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)),
                  "typeobject",
                  "811c010800",
                  "81",
                  "",
                  "1c010800"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(int64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)),
                  "typeobject",
                  "811c010900",
                  "81",
                  "",
                  "1c010900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(float32)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Float.class)),
                  "typeobject",
                  "811c010a00",
                  "81",
                  "",
                  "1c010a00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(float64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Double.class)),
                  "typeobject",
                  "811c010b00",
                  "81",
                  "",
                  "1c010b00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NBool)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NBool.class)),
                  "typeobject",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e11c012900",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e426f6f6c0101e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NUint16)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUint16.class)),
                  "typeobject",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7431360104e11c012900",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7431360104e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NUint32)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUint32.class)),
                  "typeobject",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7433320105e11c012900",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7433320105e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NUint64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUint64.class)),
                  "typeobject",
                  "815129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7436340106e11c012900",
                  "81",
                  "5129000023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e55696e7436340106e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NInt16)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NInt16.class)),
                  "typeobject",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e11c012900",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NInt32)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NInt32.class)),
                  "typeobject",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e11c012900",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NInt64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NInt64.class)),
                  "typeobject",
                  "815128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e11c012900",
                  "81",
                  "5128000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NFloat32)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NFloat32.class)),
                  "typeobject",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae11c012900",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743332010ae1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NFloat64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NFloat64.class)),
                  "typeobject",
                  "81512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be11c012900",
                  "81",
                  "512a000024762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e466c6f61743634010be1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NArray2Uint64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(
                          io.v.v23.vom.testdata.types.NArray2Uint64.class)),
                  "typeobject",
                  "815131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e11c012900",
                  "81",
                  "5131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject([]uint64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(
                          new com.google.common.reflect.TypeToken<
                              java.util.List<io.v.v23.vdl.VdlUint64>>() {}.getType())),
                  "typeobject",
                  "815104030106e11c012900",
                  "81",
                  "5104030106e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NListUint64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(
                          new com.google.common.reflect.TypeToken<
                              io.v.v23.vom.testdata.types.NListUint64>() {}.getType())),
                  "typeobject",
                  "81512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e11c012900",
                  "81",
                  "512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(set[uint64])",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(
                          new com.google.common.reflect.TypeToken<
                              java.util.Set<io.v.v23.vdl.VdlUint64>>() {}.getType())),
                  "typeobject",
                  "815104040106e11c012900",
                  "81",
                  "5104040106e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NSetUint64)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(
                          new com.google.common.reflect.TypeToken<
                              io.v.v23.vom.testdata.types.NSetUint64>() {}.getType())),
                  "typeobject",
                  "81512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e11c012900",
                  "81",
                  "512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(map[uint64]string)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(
                          new com.google.common.reflect.TypeToken<
                              java.util.Map<
                                  io.v.v23.vdl.VdlUint64, java.lang.String>>() {}.getType())),
                  "typeobject",
                  "8151060501060203e11c012900",
                  "81",
                  "51060501060203e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NMapUint64String)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(
                          new com.google.common.reflect.TypeToken<
                              io.v.v23.vom.testdata.types.NMapUint64String>() {}.getType())),
                  "typeobject",
                  "81513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e11c012900",
                  "81",
                  "513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NStruct)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NStruct.class)),
                  "typeobject",
                  "81513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e11c012900",
                  "81",
                  "513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NEnum)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NEnum.class)),
                  "typeobject",
                  "81512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e11c012900",
                  "81",
                  "512d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(types.NUnion)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUnion.class)),
                  "typeobject",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e11c012900",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "1c012900"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]typeobject{typeobject(any), typeobject(bool)}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          java.util.List<io.v.v23.vdl.VdlTypeObject>>() {}.getType(),
                      new com.google.common.collect.ImmutableList.Builder<
                              io.v.v23.vdl.VdlTypeObject>()
                          .add(new io.v.v23.vdl.VdlTypeObject())
                          .add(new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class))
                          .build()),
                  "[]typeobject",
                  "81510403010ee152020f0103020001",
                  "81",
                  "510403010ee1",
                  "52020f0103020001"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny()),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: false}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Boolean.class, false))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010101010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010101010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: int16(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 0))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010701010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010701010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: int32(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 0))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010801010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010801010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: int64(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Long.class, 0L))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010901010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010901010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: uint16(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010401010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010401010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: uint32(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010501010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010501010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: uint64(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010601010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010601010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: float32(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Float.class, 0.0f))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010a01010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010a01010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: float64(0)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Double.class, 0.0))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010b01010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010b01010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: \"\"}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.String.class, ""))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010301010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010301010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: []byte(\"\")}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(byte[].class, new byte[] {}))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152012701010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52012701010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.FoodEnum.Bean}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.FoodEnum.class,
                              io.v.v23.vom.testdata.types.FoodEnum.Bean))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e152012a01010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1",
                  "52012a01010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NListUint64{}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NListUint64>() {}.getType(),
                              new io.v.v23.vom.testdata.types.NListUint64()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e152012a01010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1",
                  "52012a01010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NByteArray(\"\\x00\\x00\\x00\\x00\")}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NByteArray.class,
                              new io.v.v23.vom.testdata.types.NByteArray()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e152012a0105090000000000000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1",
                  "52012a0105090000000000000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NArray2Uint64{}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NArray2Uint64.class,
                              new io.v.v23.vom.testdata.types.NArray2Uint64()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e15331020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e152012a010307000000000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e15331020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e1",
                  "52012a010307000000000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NSetUint64{}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NSetUint64>() {}.getType(),
                              new io.v.v23.vom.testdata.types.NSetUint64()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e152012a01010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e1",
                  "52012a01010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NMapUint64String{}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NMapUint64String>() {}.getType(),
                              new io.v.v23.vom.testdata.types.NMapUint64String()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e152012a01010500000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1",
                  "52012a01010500000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NStruct{}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NStruct.class,
                              new io.v.v23.vom.testdata.types.NStruct()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e152012a010105000000e1e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1",
                  "52012a010105000000e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NUnion{A: false}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NUnion.class,
                              new io.v.v23.vom.testdata.types.NUnion.A()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152012a0102060000000000e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52012a0102060000000000e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: ?types.NStruct(nil)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vdl.VdlOptional<
                                      io.v.v23.vom.testdata.types.NStruct>>() {}.getType(),
                              new io.v.v23.vdl.VdlOptional<io.v.v23.vom.testdata.types.NStruct>(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vdl.VdlOptional<
                                          io.v.v23.vom.testdata.types.NStruct>>() {}.getType())))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1553b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1530408012be152012a010105000000e0e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1553b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1530408012be1",
                  "52012a010105000000e0e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: ?types.NStruct{}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vdl.VdlOptional<
                                      io.v.v23.vom.testdata.types.NStruct>>() {}.getType(),
                              io.v.v23.vdl.VdlOptional.of(
                                  new io.v.v23.vom.testdata.types.NStruct())))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1553b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1530408012be152012a010105000000e1e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1553b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1530408012be1",
                  "52012a010105000000e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.StructMap{}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.StructMap.class,
                              new io.v.v23.vom.testdata.types.StructMap()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e155060501090209e15333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d6170010100034d6170012be1e152012a010105000000e1e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e155060501090209e15333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d6170010100034d6170012be1e1",
                  "52012a010105000000e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.StructMap{Map: {0: 0}}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.StructMap.class,
                              new io.v.v23.vom.testdata.types.StructMap(
                                  new com.google.common.collect.ImmutableMap.Builder<
                                          java.lang.Long, java.lang.Long>()
                                      .put(0L, 0L)
                                      .build())))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e155060501090209e15333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d6170010100034d6170012be1e152012a01050900000000010000e1e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e155060501090209e15333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d6170010100034d6170012be1e1",
                  "52012a01050900000000010000e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: typeobject(any)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlTypeObject.class, new io.v.v23.vdl.VdlTypeObject()))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152020e0f01010500000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52020e0f01010500000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "?types.StructAny(nil)",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vdl.VdlOptional<
                              io.v.v23.vom.testdata.types.StructAny>>() {}.getType(),
                      new io.v.v23.vdl.VdlOptional<io.v.v23.vom.testdata.types.StructAny>(
                          new com.google.common.reflect.TypeToken<
                              io.v.v23.vdl.VdlOptional<
                                  io.v.v23.vom.testdata.types.StructAny>>() {}.getType())),
                  "?v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1510408012ae152000001e0",
                  "81",
                  "5333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1510408012ae1",
                  "52000001e0"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: true}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Boolean.class, true))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010101010500000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010101010500000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: byte(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Byte.class, (byte) 0x1))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010201010500000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010201010500000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: int16(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 1))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010701010500000002e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010701010500000002e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: int32(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 1))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010801010500000002e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010801010500000002e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: int64(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Long.class, 1L))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010901010500000002e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010901010500000002e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: uint16(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlUint16.class,
                              new io.v.v23.vdl.VdlUint16((short) 1)))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010401010500000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010401010500000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: uint32(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 1L)))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010501010500000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010501010500000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: uint64(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(1L)))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010601010500000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010601010500000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: float32(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Float.class, 1.0f))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010a010307000000fef03fe1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010a010307000000fef03fe1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: float64(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.Double.class, 1.0))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152010b010307000000fef03fe1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52010b010307000000fef03fe1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: \"A\"}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(java.lang.String.class, "A"))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e15201030102060000000141e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "5201030102060000000141e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: []byte(\"A\")}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(byte[].class, new byte[] {(byte) 0x41}))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e15201270102060000000141e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "5201270102060000000141e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.FoodEnum.Cherry}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.FoodEnum.class,
                              io.v.v23.vom.testdata.types.FoodEnum.Cherry))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e152012a01010500000002e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1",
                  "52012a01010500000002e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NListUint64{1}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NListUint64>() {}.getType(),
                              new io.v.v23.vom.testdata.types.NListUint64(
                                  new com.google.common.collect.ImmutableList.Builder<
                                          io.v.v23.vdl.VdlUint64>()
                                      .add(new io.v.v23.vdl.VdlUint64(1L))
                                      .build())))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e152012a0102060000000101e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1",
                  "52012a0102060000000101e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NByteArray(\"Abcd\")}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NByteArray.class,
                              new io.v.v23.vom.testdata.types.NByteArray(
                                  new byte[] {
                                    (byte) 0x41, (byte) 0x62, (byte) 0x63, (byte) 0x64
                                  })))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e152012a0105090000000041626364e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1",
                  "52012a0105090000000041626364e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NArray2Uint64{0, 1}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NArray2Uint64.class,
                              new io.v.v23.vom.testdata.types.NArray2Uint64(
                                  new io.v.v23.vdl.VdlUint64[] {
                                    new io.v.v23.vdl.VdlUint64(), new io.v.v23.vdl.VdlUint64(1L)
                                  })))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e15331020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e152012a010307000000000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e15331020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e1",
                  "52012a010307000000000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NSetUint64{1}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NSetUint64>() {}.getType(),
                              new io.v.v23.vom.testdata.types.NSetUint64(
                                  new com.google.common.collect.ImmutableSet.Builder<
                                          io.v.v23.vdl.VdlUint64>()
                                      .add(new io.v.v23.vdl.VdlUint64(1L))
                                      .build())))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e152012a0102060000000101e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1532c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e1",
                  "52012a0102060000000101e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NMapUint64String{1: \"A\"}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NMapUint64String>() {}.getType(),
                              new io.v.v23.vom.testdata.types.NMapUint64String(
                                  new com.google.common.collect.ImmutableMap.Builder<
                                          io.v.v23.vdl.VdlUint64, java.lang.String>()
                                      .put(new io.v.v23.vdl.VdlUint64(1L), "A")
                                      .build())))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e152012a01040800000001010141e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1",
                  "52012a01040800000001010141e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NStruct{A: true}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NStruct.class,
                              new io.v.v23.vom.testdata.types.NStruct(true, "", 0L)))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e152012a0103070000000001e1e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1",
                  "52012a0103070000000001e1e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: types.NUnion{A: true}}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vom.testdata.types.NUnion.class,
                              new io.v.v23.vom.testdata.types.NUnion.A(true)))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152012a0102060000000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1533a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52012a0102060000000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: typeobject(bool)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlTypeObject.class,
                              new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152020e0101010500000001e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52020e0101010500000001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "any(nil)",
                  new io.v.v23.vdl.VdlAny(),
                  "any",
                  "811e000001e0",
                  "81",
                  "",
                  "1e000001e0"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "false",
                  new io.v.v23.vdl.VdlAny(java.lang.Boolean.class, false),
                  "bool",
                  "810200",
                  "81",
                  "",
                  "0200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "byte(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Byte.class, (byte) 0),
                  "byte",
                  "810400",
                  "81",
                  "",
                  "0400"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 0),
                  "int16",
                  "810e00",
                  "81",
                  "",
                  "0e00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 0),
                  "int32",
                  "811000",
                  "81",
                  "",
                  "1000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 0L),
                  "int64",
                  "811200",
                  "81",
                  "",
                  "1200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16()),
                  "uint16",
                  "810800",
                  "81",
                  "",
                  "0800"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32()),
                  "uint32",
                  "810a00",
                  "81",
                  "",
                  "0a00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64()),
                  "uint64",
                  "810c00",
                  "81",
                  "",
                  "0c00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float32(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Float.class, 0.0f),
                  "float32",
                  "811400",
                  "81",
                  "",
                  "1400"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float64(0)",
                  new io.v.v23.vdl.VdlAny(java.lang.Double.class, 0.0),
                  "float64",
                  "811600",
                  "81",
                  "",
                  "1600"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "\"\"",
                  new io.v.v23.vdl.VdlAny(java.lang.String.class, ""),
                  "string",
                  "810600",
                  "81",
                  "",
                  "0600"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]byte(\"\")",
                  new io.v.v23.vdl.VdlAny(byte[].class, new byte[] {}),
                  "[]byte",
                  "814e00",
                  "81",
                  "",
                  "4e00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.FoodEnum.Bean",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.FoodEnum.class,
                      io.v.v23.vom.testdata.types.FoodEnum.Bean),
                  "v.io/v23/vom/testdata/types.FoodEnum enum{Bean;Brie;Cherry}",
                  "81513b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e15200",
                  "81",
                  "513b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NListUint64{}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NListUint64>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NListUint64()),
                  "v.io/v23/vom/testdata/types.NListUint64 []uint64",
                  "81512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1520100",
                  "81",
                  "512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1",
                  "520100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteArray(\"\\x00\\x00\\x00\\x00\")",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByteArray.class,
                      new io.v.v23.vom.testdata.types.NByteArray()),
                  "v.io/v23/vom/testdata/types.NByteArray [4]byte",
                  "81512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1520000000000",
                  "81",
                  "512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1",
                  "520000000000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NArray2Uint64{}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NArray2Uint64.class,
                      new io.v.v23.vom.testdata.types.NArray2Uint64()),
                  "v.io/v23/vom/testdata/types.NArray2Uint64 [2]uint64",
                  "815131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e15203000000",
                  "81",
                  "5131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e1",
                  "5203000000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NSetUint64{}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NSetUint64>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NSetUint64()),
                  "v.io/v23/vom/testdata/types.NSetUint64 set[uint64]",
                  "81512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e1520100",
                  "81",
                  "512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e1",
                  "520100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NMapUint64String{}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NMapUint64String>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NMapUint64String()),
                  "v.io/v23/vom/testdata/types.NMapUint64String map[uint64]string",
                  "81513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1520100",
                  "81",
                  "513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1",
                  "520100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NStruct{}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NStruct.class,
                      new io.v.v23.vom.testdata.types.NStruct()),
                  "v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64}",
                  "81513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e15201e1",
                  "81",
                  "513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1",
                  "5201e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{A: false}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.A()),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152020000",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52020000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(any)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class, new io.v.v23.vdl.VdlTypeObject()),
                  "typeobject",
                  "811c010f00",
                  "81",
                  "",
                  "1c010f00"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "true",
                  new io.v.v23.vdl.VdlAny(java.lang.Boolean.class, true),
                  "bool",
                  "810201",
                  "81",
                  "",
                  "0201"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "byte(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Byte.class, (byte) 0x1),
                  "byte",
                  "810401",
                  "81",
                  "",
                  "0401"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int16(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Short.class, (short) 1),
                  "int16",
                  "810e02",
                  "81",
                  "",
                  "0e02"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int32(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 1),
                  "int32",
                  "811002",
                  "81",
                  "",
                  "1002"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int64(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Long.class, 1L),
                  "int64",
                  "811202",
                  "81",
                  "",
                  "1202"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint16(1)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint16.class, new io.v.v23.vdl.VdlUint16((short) 1)),
                  "uint16",
                  "810801",
                  "81",
                  "",
                  "0801"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint32(1)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint32.class, new io.v.v23.vdl.VdlUint32((int) 1L)),
                  "uint32",
                  "810a01",
                  "81",
                  "",
                  "0a01"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "uint64(1)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlUint64.class, new io.v.v23.vdl.VdlUint64(1L)),
                  "uint64",
                  "810c01",
                  "81",
                  "",
                  "0c01"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float32(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Float.class, 1.0f),
                  "float32",
                  "8114fef03f",
                  "81",
                  "",
                  "14fef03f"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "float64(1)",
                  new io.v.v23.vdl.VdlAny(java.lang.Double.class, 1.0),
                  "float64",
                  "8116fef03f",
                  "81",
                  "",
                  "16fef03f"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "\"A\"",
                  new io.v.v23.vdl.VdlAny(java.lang.String.class, "A"),
                  "string",
                  "81060141",
                  "81",
                  "",
                  "060141"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]byte(\"A\")",
                  new io.v.v23.vdl.VdlAny(byte[].class, new byte[] {(byte) 0x41}),
                  "[]byte",
                  "814e0141",
                  "81",
                  "",
                  "4e0141"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.FoodEnum.Cherry",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.FoodEnum.class,
                      io.v.v23.vom.testdata.types.FoodEnum.Cherry),
                  "v.io/v23/vom/testdata/types.FoodEnum enum{Bean;Brie;Cherry}",
                  "81513b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e15202",
                  "81",
                  "513b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1",
                  "5202"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NListUint64{1}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NListUint64>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NListUint64(
                          new com.google.common.collect.ImmutableList.Builder<
                                  io.v.v23.vdl.VdlUint64>()
                              .add(new io.v.v23.vdl.VdlUint64(1L))
                              .build())),
                  "v.io/v23/vom/testdata/types.NListUint64 []uint64",
                  "81512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e152020101",
                  "81",
                  "512d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1",
                  "52020101"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NByteArray(\"Abcd\")",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NByteArray.class,
                      new io.v.v23.vom.testdata.types.NByteArray(
                          new byte[] {(byte) 0x41, (byte) 0x62, (byte) 0x63, (byte) 0x64})),
                  "v.io/v23/vom/testdata/types.NByteArray [4]byte",
                  "81512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1520041626364",
                  "81",
                  "512e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e1",
                  "520041626364"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NArray2Uint64{0, 1}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NArray2Uint64.class,
                      new io.v.v23.vom.testdata.types.NArray2Uint64(
                          new io.v.v23.vdl.VdlUint64[] {
                            new io.v.v23.vdl.VdlUint64(), new io.v.v23.vdl.VdlUint64(1L)
                          })),
                  "v.io/v23/vom/testdata/types.NArray2Uint64 [2]uint64",
                  "815131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e15203000001",
                  "81",
                  "5131020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e1",
                  "5203000001"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NSetUint64{1}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NSetUint64>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NSetUint64(
                          new com.google.common.collect.ImmutableSet.Builder<
                                  io.v.v23.vdl.VdlUint64>()
                              .add(new io.v.v23.vdl.VdlUint64(1L))
                              .build())),
                  "v.io/v23/vom/testdata/types.NSetUint64 set[uint64]",
                  "81512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e152020101",
                  "81",
                  "512c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e1",
                  "52020101"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NMapUint64String{1: \"A\"}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.NMapUint64String>() {}.getType(),
                      new io.v.v23.vom.testdata.types.NMapUint64String(
                          new com.google.common.collect.ImmutableMap.Builder<
                                  io.v.v23.vdl.VdlUint64, java.lang.String>()
                              .put(new io.v.v23.vdl.VdlUint64(1L), "A")
                              .build())),
                  "v.io/v23/vom/testdata/types.NMapUint64String map[uint64]string",
                  "81513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1520401010141",
                  "81",
                  "513405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1",
                  "520401010141"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NStruct{A: true}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NStruct.class,
                      new io.v.v23.vom.testdata.types.NStruct(true, "", 0L)),
                  "v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64}",
                  "81513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e152030001e1",
                  "81",
                  "513b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1",
                  "52030001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NUnion{A: true}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NUnion.class,
                      new io.v.v23.vom.testdata.types.NUnion.A(true)),
                  "v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64}",
                  "81513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e152020001",
                  "81",
                  "513a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e1",
                  "52020001"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(bool)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)),
                  "typeobject",
                  "811c010100",
                  "81",
                  "",
                  "1c010100"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructManyTypes{}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructManyTypes.class,
                      new io.v.v23.vom.testdata.types.StructManyTypes()),
                  "v.io/v23/vom/testdata/types.StructManyTypes struct{Bool bool;AByte byte;Int16 int16;Int32 int32;Int64 int64;Uint16 uint16;Uint32 uint32;Uint64 uint64;String string;Bytes []byte;Float32 float32;Float64 float64;FoodEnum v.io/v23/vom/testdata/types.FoodEnum enum{Bean;Brie;Cherry};NEnum v.io/v23/vom/testdata/types.NEnum enum{A;B;C};NListUint64 v.io/v23/vom/testdata/types.NListUint64 []uint64;NByteArray v.io/v23/vom/testdata/types.NByteArray [4]byte;NArray2Uint64 v.io/v23/vom/testdata/types.NArray2Uint64 [2]uint64;NSetUint64 v.io/v23/vom/testdata/types.NSetUint64 set[uint64];NMapUint64String v.io/v23/vom/testdata/types.NMapUint64String map[uint64]string;NStruct v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};NUnion v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64};TypeObject typeobject}",
                  "81533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1552d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1572d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1592e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e15b31020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e15d2c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e15f3405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1613b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1633a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e151fe014206002b762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d616e79547970657301160004426f6f6c0101e1000541427974650102e10005496e7431360107e10005496e7433320108e10005496e7436340109e1000655696e7431360104e1000655696e7433320105e1000655696e7436340106e10006537472696e670103e1000542797465730127e10007466c6f61743332010ae10007466c6f61743634010be10008466f6f64456e756d012ae100054e456e756d012be1000b4e4c69737455696e743634012ce1000a4e427974654172726179012de1000d4e41727261793255696e743634012ee1000a4e53657455696e743634012fe100104e4d617055696e743634537472696e670130e100074e5374727563740131e100064e556e696f6e0132e1000a547970654f626a656374010ee1e1520001e1",
                  "81",
                  "533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1552d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1572d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1592e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e15b31020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e15d2c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e15f3405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1613b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1633a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e151fe014206002b762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d616e79547970657301160004426f6f6c0101e1000541427974650102e10005496e7431360107e10005496e7433320108e10005496e7436340109e1000655696e7431360104e1000655696e7433320105e1000655696e7436340106e10006537472696e670103e1000542797465730127e10007466c6f61743332010ae10007466c6f61743634010be10008466f6f64456e756d012ae100054e456e756d012be1000b4e4c69737455696e743634012ce1000a4e427974654172726179012de1000d4e41727261793255696e743634012ee1000a4e53657455696e743634012fe100104e4d617055696e743634537472696e670130e100074e5374727563740131e100064e556e696f6e0132e1000a547970654f626a656374010ee1e1",
                  "520001e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructManyTypes{Bool: true, AByte: 1, Int16: 1, Int32: 1, Int64: 1, Uint16: 1, Uint32: 1, Uint64: 1, String: \"A\", Bytes: \"A\", Float32: 1, Float64: 1, FoodEnum: types.FoodEnum.Cherry, NListUint64: {1}, NByteArray: \"Abcd\", NArray2Uint64: {0, 1}, NSetUint64: {1}, NMapUint64String: {1: \"A\"}, NStruct: {A: true}, NUnion: {A: true}, TypeObject: typeobject(bool)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructManyTypes.class,
                      new io.v.v23.vom.testdata.types.StructManyTypes(
                          true,
                          (byte) 0x1,
                          (short) 1,
                          1,
                          1L,
                          new io.v.v23.vdl.VdlUint16((short) 1),
                          new io.v.v23.vdl.VdlUint32((int) 1L),
                          new io.v.v23.vdl.VdlUint64(1L),
                          "A",
                          new byte[] {(byte) 0x41},
                          1.0f,
                          1.0,
                          io.v.v23.vom.testdata.types.FoodEnum.Cherry,
                          io.v.v23.vom.testdata.types.NEnum.A,
                          new io.v.v23.vom.testdata.types.NListUint64(
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlUint64>()
                                  .add(new io.v.v23.vdl.VdlUint64(1L))
                                  .build()),
                          new io.v.v23.vom.testdata.types.NByteArray(
                              new byte[] {(byte) 0x41, (byte) 0x62, (byte) 0x63, (byte) 0x64}),
                          new io.v.v23.vom.testdata.types.NArray2Uint64(
                              new io.v.v23.vdl.VdlUint64[] {
                                new io.v.v23.vdl.VdlUint64(), new io.v.v23.vdl.VdlUint64(1L)
                              }),
                          new io.v.v23.vom.testdata.types.NSetUint64(
                              new com.google.common.collect.ImmutableSet.Builder<
                                      io.v.v23.vdl.VdlUint64>()
                                  .add(new io.v.v23.vdl.VdlUint64(1L))
                                  .build()),
                          new io.v.v23.vom.testdata.types.NMapUint64String(
                              new com.google.common.collect.ImmutableMap.Builder<
                                      io.v.v23.vdl.VdlUint64, java.lang.String>()
                                  .put(new io.v.v23.vdl.VdlUint64(1L), "A")
                                  .build()),
                          new io.v.v23.vom.testdata.types.NStruct(true, "", 0L),
                          new io.v.v23.vom.testdata.types.NUnion.A(true),
                          new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class))),
                  "v.io/v23/vom/testdata/types.StructManyTypes struct{Bool bool;AByte byte;Int16 int16;Int32 int32;Int64 int64;Uint16 uint16;Uint32 uint32;Uint64 uint64;String string;Bytes []byte;Float32 float32;Float64 float64;FoodEnum v.io/v23/vom/testdata/types.FoodEnum enum{Bean;Brie;Cherry};NEnum v.io/v23/vom/testdata/types.NEnum enum{A;B;C};NListUint64 v.io/v23/vom/testdata/types.NListUint64 []uint64;NByteArray v.io/v23/vom/testdata/types.NByteArray [4]byte;NArray2Uint64 v.io/v23/vom/testdata/types.NArray2Uint64 [2]uint64;NSetUint64 v.io/v23/vom/testdata/types.NSetUint64 set[uint64];NMapUint64String v.io/v23/vom/testdata/types.NMapUint64String map[uint64]string;NStruct v.io/v23/vom/testdata/types.NStruct struct{A bool;B string;C int64};NUnion v.io/v23/vom/testdata/types.NUnion union{A bool;B string;C int64};TypeObject typeobject}",
                  "81533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1552d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1572d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1592e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e15b31020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e15d2c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e15f3405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1613b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1633a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e151fe014206002b762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d616e79547970657301160004426f6f6c0101e1000541427974650102e10005496e7431360107e10005496e7433320108e10005496e7436340109e1000655696e7431360104e1000655696e7433320105e1000655696e7436340106e10006537472696e670103e1000542797465730127e10007466c6f61743332010ae10007466c6f61743634010be10008466f6f64456e756d012ae100054e456e756d012be1000b4e4c69737455696e743634012ce1000a4e427974654172726179012de1000d4e41727261793255696e743634012ee1000a4e53657455696e743634012fe100104e4d617055696e743634537472696e670130e100074e5374727563740131e100064e556e696f6e0132e1000a547970654f626a656374010ee1e15201013f000101010202030204020501060107010801410901410afef03f0bfef03f0c020e01010f0041626364100000011101011201010141130001e11400011500e1",
                  "81",
                  "533b010024762e696f2f7632332f766f6d2f74657374646174612f74797065732e466f6f64456e756d0103044265616e044272696506436865727279e1552d010021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e456e756d0103014101420143e1572d030027762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4c69737455696e7436340106e1592e020026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e42797465417272617901020204e15b31020029762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e41727261793255696e74363401060202e15d2c040026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53657455696e7436340106e15f3405002c762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e4d617055696e743634537472696e6701060203e1613b060023762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e53747275637401030001410101e10001420103e10001430109e1e1633a070022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e556e696f6e01030001410101e10001420103e10001430109e1e151fe014206002b762e696f2f7632332f766f6d2f74657374646174612f74797065732e5374727563744d616e79547970657301160004426f6f6c0101e1000541427974650102e10005496e7431360107e10005496e7433320108e10005496e7436340109e1000655696e7431360104e1000655696e7433320105e1000655696e7436340106e10006537472696e670103e1000542797465730127e10007466c6f61743332010ae10007466c6f61743634010be10008466f6f64456e756d012ae100054e456e756d012be1000b4e4c69737455696e743634012ce1000a4e427974654172726179012de1000d4e41727261793255696e743634012ee1000a4e53657455696e743634012fe100104e4d617055696e743634537472696e670130e100074e5374727563740131e100064e556e696f6e0132e1000a547970654f626a656374010ee1e1",
                  "5201013f000101010202030204020501060107010801410901410afef03f0bfef03f0c020e01010f0041626364100000011101011201010141130001e11400011500e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.AnySlice{types.NInt16(1), types.NInt32(2), types.NInt64(3), types.NInt32(4)}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.AnySlice>() {}.getType(),
                      new io.v.v23.vom.testdata.types.AnySlice(
                          new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlAny>()
                              .add(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt16.class,
                                      new io.v.v23.vom.testdata.types.NInt16((short) 1)))
                              .add(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt32.class,
                                      new io.v.v23.vom.testdata.types.NInt32(2)))
                              .add(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt64.class,
                                      new io.v.v23.vom.testdata.types.NInt64(3L)))
                              .add(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt32.class,
                                      new io.v.v23.vom.testdata.types.NInt32(4)))
                              .build())),
                  "v.io/v23/vom/testdata/types.AnySlice []any",
                  "81512a030024762e696f2f7632332f766f6d2f74657374646174612f74797065732e416e79536c696365010fe15328000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e15528000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e15728000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e152032a2b2c04010101010d04000002010104020206010308",
                  "81",
                  "512a030024762e696f2f7632332f766f6d2f74657374646174612f74797065732e416e79536c696365010fe15328000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e15528000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e15728000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e1",
                  "52032a2b2c04010101010d04000002010104020206010308"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "[]types.StructAny{{Any: types.NInt16(1)}, {Any: types.NInt32(2)}, {Any: types.NInt64(3)}, {Any: types.NInt32(4)}}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          java.util.List<io.v.v23.vom.testdata.types.StructAny>>() {}.getType(),
                      new com.google.common.collect.ImmutableList.Builder<
                              io.v.v23.vom.testdata.types.StructAny>()
                          .add(
                              new io.v.v23.vom.testdata.types.StructAny(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt16.class,
                                      new io.v.v23.vom.testdata.types.NInt16((short) 1))))
                          .add(
                              new io.v.v23.vom.testdata.types.StructAny(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt32.class,
                                      new io.v.v23.vom.testdata.types.NInt32(2))))
                          .add(
                              new io.v.v23.vom.testdata.types.StructAny(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt64.class,
                                      new io.v.v23.vom.testdata.types.NInt64(3L))))
                          .add(
                              new io.v.v23.vom.testdata.types.StructAny(
                                  new io.v.v23.vdl.VdlAny(
                                      io.v.v23.vom.testdata.types.NInt32.class,
                                      new io.v.v23.vom.testdata.types.NInt32(4))))
                          .build()),
                  "[]v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1510403012ae15528000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e15728000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e15928000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e152032b2c2d0401010101150400000002e100010104e100020206e100010308e1",
                  "81",
                  "5333060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1510403012ae15528000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7431360107e15728000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7433320108e15928000022762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e7436340109e1",
                  "52032b2c2d0401010101150400000002e100010104e100020206e100010308e1"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int8(0)",
                  new io.v.v23.vdl.VdlAny(io.v.v23.vdl.VdlInt8.class, new io.v.v23.vdl.VdlInt8()),
                  "int8",
                  "812000",
                  "81",
                  "",
                  "2000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int8(-128)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlInt8.class, new io.v.v23.vdl.VdlInt8((byte) -128)),
                  "int8",
                  "8120ffff",
                  "81",
                  "",
                  "20ffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int8(127)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlInt8.class, new io.v.v23.vdl.VdlInt8((byte) 127)),
                  "int8",
                  "8120fffe",
                  "81",
                  "",
                  "20fffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt8(0)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt8.class,
                      new io.v.v23.vom.testdata.types.NInt8()),
                  "v.io/v23/vom/testdata/types.NInt8 int8",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e74380110e15200",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e74380110e1",
                  "5200"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt8(-128)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt8.class,
                      new io.v.v23.vom.testdata.types.NInt8((byte) -128)),
                  "v.io/v23/vom/testdata/types.NInt8 int8",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e74380110e152ffff",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e74380110e1",
                  "52ffff"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.NInt8(127)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.NInt8.class,
                      new io.v.v23.vom.testdata.types.NInt8((byte) 127)),
                  "v.io/v23/vom/testdata/types.NInt8 int8",
                  "815127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e74380110e152fffe",
                  "81",
                  "5127000021762e696f2f7632332f766f6d2f74657374646174612f74797065732e4e496e74380110e1",
                  "52fffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int8(0)",
                  new io.v.v23.vdl.VdlAny(io.v.v23.vdl.VdlInt8.class, new io.v.v23.vdl.VdlInt8()),
                  "int8",
                  "812000",
                  "81",
                  "",
                  "2000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "int8(1)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlInt8.class, new io.v.v23.vdl.VdlInt8((byte) 1)),
                  "int8",
                  "812002",
                  "81",
                  "",
                  "2002"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "typeobject(int8)",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vdl.VdlTypeObject.class,
                      new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlInt8.class)),
                  "typeobject",
                  "811c011000",
                  "81",
                  "",
                  "1c011000"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.MInt8Slice{-128, -1, 0, 127}",
                  new io.v.v23.vdl.VdlAny(
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.vom.testdata.types.MInt8Slice>() {}.getType(),
                      new io.v.v23.vom.testdata.types.MInt8Slice(
                          new com.google.common.collect.ImmutableList.Builder<
                                  io.v.v23.vdl.VdlInt8>()
                              .add(new io.v.v23.vdl.VdlInt8((byte) -128))
                              .add(new io.v.v23.vdl.VdlInt8((byte) -1))
                              .add(new io.v.v23.vdl.VdlInt8())
                              .add(new io.v.v23.vdl.VdlInt8((byte) 127))
                              .build())),
                  "v.io/v23/vom/testdata/types.MInt8Slice []int8",
                  "81512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d496e7438536c6963650110e1520704ffff0100fffe",
                  "81",
                  "512c030026762e696f2f7632332f766f6d2f74657374646174612f74797065732e4d496e7438536c6963650110e1",
                  "520704ffff0100fffe"))
          .add(
              new io.v.v23.vom.testdata.types.TestCase(
                  "types.StructAny{Any: int8(1)}",
                  new io.v.v23.vdl.VdlAny(
                      io.v.v23.vom.testdata.types.StructAny.class,
                      new io.v.v23.vom.testdata.types.StructAny(
                          new io.v.v23.vdl.VdlAny(
                              io.v.v23.vdl.VdlInt8.class, new io.v.v23.vdl.VdlInt8((byte) 1)))),
                  "v.io/v23/vom/testdata/types.StructAny struct{Any any}",
                  "815133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e152011001010500000002e1",
                  "81",
                  "5133060025762e696f2f7632332f766f6d2f74657374646174612f74797065732e537472756374416e7901010003416e79010fe1e1",
                  "52011001010500000002e1"))
          .build();

  /**
   * CompatTests contains the testcases to use to test vom type compatibility.
   * CompatTests maps TestName (string) to CompatibleTypeSet ([]typeobject)
   * Each CompatibleTypeSet contains types compatible with each other. However,
   * types from different CompatibleTypeSets are incompatible.
   */
  public static final java.util.Map<java.lang.String, java.util.List<io.v.v23.vdl.VdlTypeObject>>
      COMPAT_TESTS =
          new com.google.common.collect.ImmutableMap.Builder<
                  java.lang.String, java.util.List<io.v.v23.vdl.VdlTypeObject>>()
              .put(
                  "bool",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NBool.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.MBool.class))
                      .build())
              .put(
                  "map[X]bool/set[X]",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.SetOnlyMap>() {}.getType()))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.MapOnlySet>() {}.getType()))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.SometimesSetMap>() {}.getType()))
                      .build())
              .put(
                  "map[string]X/struct",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.MapOnlyStruct.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.StructOnlyMap>() {}.getType()))
                      .build())
              .put(
                  "map[string]bool/set[string]/struct",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.MapSetStruct.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.SetStructMap>() {}.getType()))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.MapStructSet>() {}.getType()))
                      .build())
              .put(
                  "number list/array",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  java.util.List<java.lang.Integer>>() {}.getType()))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.NArray2Uint64.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NListUint64>() {}.getType()))
                      .build())
              .put(
                  "number",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint16.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint32.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint64.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(java.lang.Short.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(java.lang.Float.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(java.lang.Double.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUint16.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUint32.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUint64.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NInt16.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NInt32.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NInt64.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.NFloat32.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.NFloat64.class))
                      .build())
              .put(
                  "string list/array",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  java.util.List<java.lang.String>>() {}.getType()))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.ListString>() {}.getType()))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.Array3String.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.Array4String.class))
                      .build())
              .put(
                  "string/[]byte/enum",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(new io.v.v23.vdl.VdlTypeObject(java.lang.String.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NString.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(byte[].class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              new com.google.common.reflect.TypeToken<
                                  io.v.v23.vom.testdata.types.NByteSlice>() {}.getType()))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.NByteArray.class))
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NEnum.class))
                      .build())
              .put(
                  "struct A",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NStruct.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.AbcStruct.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.AdeStruct.class))
                      .build())
              .put(
                  "struct Z",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.XyzStruct.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.YzStruct.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.ZStruct.class))
                      .build())
              .put(
                  "typeobject",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlTypeObject.class))
                      .build())
              .put(
                  "union B",
                  new com.google.common.collect.ImmutableList.Builder<io.v.v23.vdl.VdlTypeObject>()
                      .add(new io.v.v23.vdl.VdlTypeObject(io.v.v23.vom.testdata.types.NUnion.class))
                      .add(
                          new io.v.v23.vdl.VdlTypeObject(
                              io.v.v23.vom.testdata.types.BdeUnion.class))
                      .build())
              .build();

  /**
   * ConvertTests contains the testcases to check vom value convertibility.
   * ConvertTests maps TestName (string) to ConvertGroups ([]ConvertGroup)
   * Each ConvertGroup is a struct with 'Name', 'PrimaryType', and 'Values'.
   * The values within a ConvertGroup can convert between themselves w/o error.
   * However, values in higher-indexed ConvertGroups will error when converting up
   * to the primary type of the lower-indexed ConvertGroups.
   */
  public static final java.util.Map<
          java.lang.String, java.util.List<io.v.v23.vom.testdata.types.ConvertGroup>>
      CONVERT_TESTS =
          new com.google.common.collect.ImmutableMap.Builder<
                  java.lang.String, java.util.List<io.v.v23.vom.testdata.types.ConvertGroup>>()
              .put(
                  "array/list",
                  new com.google.common.collect.ImmutableList.Builder<
                          io.v.v23.vom.testdata.types.ConvertGroup>()
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "[3]string",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.Array3String.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.Array3String.class,
                                          new io.v.v23.vom.testdata.types.Array3String(
                                              new java.lang.String[] {"A", "B", "C"})))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              java.util.List<java.lang.String>>() {}.getType(),
                                          new com.google.common.collect.ImmutableList.Builder<
                                                  java.lang.String>()
                                              .add("A")
                                              .add("B")
                                              .add("C")
                                              .build()))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "[4]string",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.Array4String.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.Array4String.class,
                                          new io.v.v23.vom.testdata.types.Array4String(
                                              new java.lang.String[] {"D", "E", "F", "G"})))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "ByteArray",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.NByteArray.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NByteArray.class,
                                          new io.v.v23.vom.testdata.types.NByteArray(
                                              new byte[] {
                                                (byte) 0x5, (byte) 0x2, (byte) 0, (byte) 0x4
                                              })))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          byte[].class,
                                          new byte[] {
                                            (byte) 0x5, (byte) 0x2, (byte) 0, (byte) 0x4
                                          }))
                                  .build()))
                      .build())
              .put(
                  "bool",
                  new com.google.common.collect.ImmutableList.Builder<
                          io.v.v23.vom.testdata.types.ConvertGroup>()
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "bool",
                              new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Boolean.class, true))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NBool.class,
                                          new io.v.v23.vom.testdata.types.NBool(true)))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.MBool.class,
                                          new io.v.v23.vom.testdata.types.MBool(true)))
                                  .build()))
                      .build())
              .put(
                  "number",
                  new com.google.common.collect.ImmutableList.Builder<
                          io.v.v23.vom.testdata.types.ConvertGroup>()
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "byte",
                              new io.v.v23.vdl.VdlTypeObject(java.lang.Byte.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Byte.class, (byte) 0x3))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vdl.VdlUint16.class,
                                          new io.v.v23.vdl.VdlUint16((short) 3)))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 3))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Double.class, 3.0))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Long.class, 3L))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "uint16",
                              new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint16.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vdl.VdlUint16.class,
                                          new io.v.v23.vdl.VdlUint16((short) 256)))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Integer.class, 256))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Double.class, 256.0))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Long.class, 256L))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "int32",
                              new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Integer.class, -5))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Double.class, -5.0))
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Long.class, -5L))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "float64",
                              new io.v.v23.vdl.VdlTypeObject(java.lang.Double.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.Double.class, 3.3))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "int64",
                              new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          java.lang.Long.class, -9223372036854775808L))
                                  .build()))
                      .build())
              .put(
                  "string and enum",
                  new com.google.common.collect.ImmutableList.Builder<
                          io.v.v23.vom.testdata.types.ConvertGroup>()
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "enum (A)",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.NEnum.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.String.class, "A"))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NString.class,
                                          new io.v.v23.vom.testdata.types.NString("A")))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NEnum.class,
                                          io.v.v23.vom.testdata.types.NEnum.A))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "enum (brie)",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.BrieEnum.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.String.class, "Brie"))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NString.class,
                                          new io.v.v23.vom.testdata.types.NString("Brie")))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.BrieEnum.class,
                                          io.v.v23.vom.testdata.types.BrieEnum.Brie))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.FoodEnum.class,
                                          io.v.v23.vom.testdata.types.FoodEnum.Brie))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "string",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.NString.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(new io.v.v23.vdl.VdlAny(java.lang.String.class, "Cherry"))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NString.class,
                                          new io.v.v23.vom.testdata.types.NString("Cherry")))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.FoodEnum.class,
                                          io.v.v23.vom.testdata.types.FoodEnum.Cherry))
                                  .build()))
                      .build())
              .put(
                  "struct, map, and set",
                  new com.google.common.collect.ImmutableList.Builder<
                          io.v.v23.vom.testdata.types.ConvertGroup>()
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "map[uint32]uint32",
                              new io.v.v23.vdl.VdlTypeObject(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vom.testdata.types.MapOnlyA>() {}.getType()),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.MapOnlyA>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.MapOnlyA(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      io.v.v23.vdl.VdlUint32,
                                                      io.v.v23.vdl.VdlUint32>()
                                                  .put(
                                                      new io.v.v23.vdl.VdlUint32((int) 4L),
                                                      new io.v.v23.vdl.VdlUint32())
                                                  .put(
                                                      new io.v.v23.vdl.VdlUint32((int) 6L),
                                                      new io.v.v23.vdl.VdlUint32((int) 7L))
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.MapOnlyA2>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.MapOnlyA2(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      java.lang.Long, java.lang.Double>()
                                                  .put(4L, 0.0)
                                                  .put(6L, 7.0)
                                                  .build())))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "map[bool]string",
                              new io.v.v23.vdl.VdlTypeObject(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vom.testdata.types.MapOnlyB>() {}.getType()),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.MapOnlyB>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.MapOnlyB(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      java.lang.Boolean, java.lang.String>()
                                                  .put(true, "hello")
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.MapOnlyB2>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.MapOnlyB2(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      io.v.v23.vom.testdata.types.NBool,
                                                      io.v.v23.vom.testdata.types.NString>()
                                                  .put(
                                                      new io.v.v23.vom.testdata.types.NBool(true),
                                                      new io.v.v23.vom.testdata.types.NString(
                                                          "hello"))
                                                  .build())))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "set[bool]",
                              new io.v.v23.vdl.VdlTypeObject(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vom.testdata.types.SetOnlyA>() {}.getType()),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.SetOnlyA>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SetOnlyA(
                                              new com.google.common.collect.ImmutableSet.Builder<
                                                      java.lang.Boolean>()
                                                  .add(false)
                                                  .add(true)
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.SetOnlyA2>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SetOnlyA2(
                                              new com.google.common.collect.ImmutableSet.Builder<
                                                      io.v.v23.vom.testdata.types.NBool>()
                                                  .add(new io.v.v23.vom.testdata.types.NBool())
                                                  .add(new io.v.v23.vom.testdata.types.NBool(true))
                                                  .build())))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "set[int16]",
                              new io.v.v23.vdl.VdlTypeObject(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vom.testdata.types.SetOnlyB>() {}.getType()),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.SetOnlyB>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SetOnlyB(
                                              new com.google.common.collect.ImmutableSet.Builder<
                                                      java.lang.Short>()
                                                  .add((short) 4)
                                                  .add((short) 6)
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types.SetOnlyB2>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SetOnlyB2(
                                              new com.google.common.collect.ImmutableSet.Builder<
                                                      io.v.v23.vom.testdata.types.NInt16>()
                                                  .add(
                                                      new io.v.v23.vom.testdata.types.NInt16(
                                                          (short) 4))
                                                  .add(
                                                      new io.v.v23.vom.testdata.types.NInt16(
                                                          (short) 6))
                                                  .build())))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "structABC",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.AbcStruct.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.AbcStruct.class,
                                          new io.v.v23.vom.testdata.types.AbcStruct(true, "", 0L)))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.AdeStruct.class,
                                          new io.v.v23.vom.testdata.types.AdeStruct(
                                              true,
                                              new io.v.v23.vdl.VdlAny(),
                                              new io.v.v23.vdl.VdlTypeObject())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NStruct.class,
                                          new io.v.v23.vom.testdata.types.NStruct(true, "", 0L)))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "structYz",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.YzStruct.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.XyzStruct.class,
                                          new io.v.v23.vom.testdata.types.XyzStruct(
                                              false,
                                              new io.v.v23.vom.testdata.types.MBool(),
                                              "ahoy")))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.YzStruct.class,
                                          new io.v.v23.vom.testdata.types.YzStruct(
                                              new io.v.v23.vom.testdata.types.NBool(),
                                              new io.v.v23.vom.testdata.types.NString("ahoy"))))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.ZStruct.class,
                                          new io.v.v23.vom.testdata.types.ZStruct("ahoy")))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "struct+map",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.MapOnlyStruct.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types
                                                  .StructOnlyMap>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.StructOnlyMap(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      java.lang.String, io.v.v23.vdl.VdlUint64>()
                                                  .put("Key1", new io.v.v23.vdl.VdlUint64(4L))
                                                  .put("Key2", new io.v.v23.vdl.VdlUint64(5L))
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.MapOnlyStruct.class,
                                          new io.v.v23.vom.testdata.types.MapOnlyStruct(
                                              4L, new io.v.v23.vdl.VdlUint32((int) 5L))))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "map+set",
                              new io.v.v23.vdl.VdlTypeObject(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vom.testdata.types.MapOnlySet>() {}.getType()),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types
                                                  .MapOnlySet>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.MapOnlySet(
                                              new com.google.common.collect.ImmutableSet.Builder<
                                                      java.lang.Double>()
                                                  .add(3.14)
                                                  .add(8.0)
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types
                                                  .SometimesSetMap>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SometimesSetMap(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      java.lang.Double, io.v.v23.vdl.VdlAny>()
                                                  .put(
                                                      3.14,
                                                      new io.v.v23.vdl.VdlAny(
                                                          java.lang.Boolean.class, true))
                                                  .put(
                                                      8.0,
                                                      new io.v.v23.vdl.VdlAny(
                                                          java.lang.Boolean.class, true))
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types
                                                  .SetOnlyMap>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SetOnlyMap(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      java.lang.Double, java.lang.Boolean>()
                                                  .put(3.14, true)
                                                  .put(8.0, true)
                                                  .build())))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "map-set",
                              new io.v.v23.vdl.VdlTypeObject(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vom.testdata.types.SetOnlyMap>() {}.getType()),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types
                                                  .SometimesSetMap>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SometimesSetMap(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      java.lang.Double, io.v.v23.vdl.VdlAny>()
                                                  .put(
                                                      3.14,
                                                      new io.v.v23.vdl.VdlAny(
                                                          java.lang.String.class,
                                                          "cannot be a set anymore"))
                                                  .put(
                                                      8.0,
                                                      new io.v.v23.vdl.VdlAny(
                                                          java.lang.Boolean.class, true))
                                                  .build())))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "struct+map+set",
                              new io.v.v23.vdl.VdlTypeObject(
                                  new com.google.common.reflect.TypeToken<
                                      io.v.v23.vom.testdata.types.MapStructSet>() {}.getType()),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types
                                                  .MapStructSet>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.MapStructSet(
                                              new com.google.common.collect.ImmutableSet.Builder<
                                                      java.lang.String>()
                                                  .add("Eel")
                                                  .add("Feat")
                                                  .add("Tire")
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          new com.google.common.reflect.TypeToken<
                                              io.v.v23.vom.testdata.types
                                                  .SetStructMap>() {}.getType(),
                                          new io.v.v23.vom.testdata.types.SetStructMap(
                                              new com.google.common.collect.ImmutableMap.Builder<
                                                      java.lang.String, java.lang.Boolean>()
                                                  .put("Eel", true)
                                                  .put("Feat", true)
                                                  .put("Tire", true)
                                                  .build())))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.MapSetStruct.class,
                                          new io.v.v23.vom.testdata.types.MapSetStruct(
                                              true, true, true)))
                                  .build()))
                      .build())
              .put(
                  "typeobject",
                  new com.google.common.collect.ImmutableList.Builder<
                          io.v.v23.vom.testdata.types.ConvertGroup>()
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "typeobject(any)",
                              new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlTypeObject.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vdl.VdlTypeObject.class,
                                          new io.v.v23.vdl.VdlTypeObject()))
                                  .build()))
                      .build())
              .put(
                  "union",
                  new com.google.common.collect.ImmutableList.Builder<
                          io.v.v23.vom.testdata.types.ConvertGroup>()
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "BdeUnion",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.BdeUnion.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.BdeUnion.class,
                                          new io.v.v23.vom.testdata.types.BdeUnion.B("bde")))
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NUnion.class,
                                          new io.v.v23.vom.testdata.types.NUnion.B("bde")))
                                  .build()))
                      .add(
                          new io.v.v23.vom.testdata.types.ConvertGroup(
                              "BdeUnion fail",
                              new io.v.v23.vdl.VdlTypeObject(
                                  io.v.v23.vom.testdata.types.NUnion.class),
                              new com.google.common.collect.ImmutableList.Builder<
                                      io.v.v23.vdl.VdlAny>()
                                  .add(
                                      new io.v.v23.vdl.VdlAny(
                                          io.v.v23.vom.testdata.types.NUnion.class,
                                          new io.v.v23.vom.testdata.types.NUnion.A(true)))
                                  .build()))
                      .build())
              .build();

  private Constants() {}
}
