// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: wiretype.vdl
package io.v.v23.vom;

/**
 * The wireType union is used to encode the payload part of each type message,
 * using the regular rules for encoding union values.  But unlike our regular
 * encoding, the type message for wireType itself (and its fields) are never
 * encoded; we need to bootstrap the system.  Thus unlike regular values, the
 * ordering of fields within the wire* types cannot be changed.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/vom.wireType")
class WireType extends io.v.v23.vdl.VdlUnion {
  private static final long serialVersionUID = 1L;

  /**
   * FIELD INDICES MUST NOT BE CHANGED.
   * INDEX = 0
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "NamedT", index = 0)
  public static class NamedT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireNamed elem;

    public NamedT(io.v.v23.vom.WireNamed elem) {
      super(0, elem);
      this.elem = elem;
    }

    public NamedT() {
      this(new io.v.v23.vom.WireNamed());
    }

    @Override
    public io.v.v23.vom.WireNamed getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 1
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "EnumT", index = 1)
  public static class EnumT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireEnum elem;

    public EnumT(io.v.v23.vom.WireEnum elem) {
      super(1, elem);
      this.elem = elem;
    }

    public EnumT() {
      this(new io.v.v23.vom.WireEnum());
    }

    @Override
    public io.v.v23.vom.WireEnum getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 2
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "ArrayT", index = 2)
  public static class ArrayT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireArray elem;

    public ArrayT(io.v.v23.vom.WireArray elem) {
      super(2, elem);
      this.elem = elem;
    }

    public ArrayT() {
      this(new io.v.v23.vom.WireArray());
    }

    @Override
    public io.v.v23.vom.WireArray getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 3
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "ListT", index = 3)
  public static class ListT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireList elem;

    public ListT(io.v.v23.vom.WireList elem) {
      super(3, elem);
      this.elem = elem;
    }

    public ListT() {
      this(new io.v.v23.vom.WireList());
    }

    @Override
    public io.v.v23.vom.WireList getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 4
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "SetT", index = 4)
  public static class SetT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireSet elem;

    public SetT(io.v.v23.vom.WireSet elem) {
      super(4, elem);
      this.elem = elem;
    }

    public SetT() {
      this(new io.v.v23.vom.WireSet());
    }

    @Override
    public io.v.v23.vom.WireSet getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 5
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "MapT", index = 5)
  public static class MapT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireMap elem;

    public MapT(io.v.v23.vom.WireMap elem) {
      super(5, elem);
      this.elem = elem;
    }

    public MapT() {
      this(new io.v.v23.vom.WireMap());
    }

    @Override
    public io.v.v23.vom.WireMap getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 6
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "StructT", index = 6)
  public static class StructT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireStruct elem;

    public StructT(io.v.v23.vom.WireStruct elem) {
      super(6, elem);
      this.elem = elem;
    }

    public StructT() {
      this(new io.v.v23.vom.WireStruct());
    }

    @Override
    public io.v.v23.vom.WireStruct getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 7
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "UnionT", index = 7)
  public static class UnionT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireUnion elem;

    public UnionT(io.v.v23.vom.WireUnion elem) {
      super(7, elem);
      this.elem = elem;
    }

    public UnionT() {
      this(new io.v.v23.vom.WireUnion());
    }

    @Override
    public io.v.v23.vom.WireUnion getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * INDEX = 8
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "OptionalT", index = 8)
  public static class OptionalT extends WireType {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.WireOptional elem;

    public OptionalT(io.v.v23.vom.WireOptional elem) {
      super(8, elem);
      this.elem = elem;
    }

    public OptionalT() {
      this(new io.v.v23.vom.WireOptional());
    }

    @Override
    public io.v.v23.vom.WireOptional getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireType.class);

  public WireType(int index, Object value) {
    super(VDL_TYPE, index, value);
  }
}
