// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: dump.vdl
package io.v.v23.vom;

/**
 * Primitive represents one of the primitive vom values.  All vom values are
 * composed of combinations of these primitives.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/vom.Primitive")
public class Primitive extends io.v.v23.vdl.VdlUnion {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PBool", index = 0)
  public static class PBool extends Primitive {
    private static final long serialVersionUID = 1L;
    private boolean elem;

    public PBool(boolean elem) {
      super(0, elem);
      this.elem = elem;
    }

    public PBool() {
      this(false);
    }

    @Override
    public java.lang.Boolean getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return java.lang.Boolean.valueOf(elem).hashCode();
    }
  }

  @io.v.v23.vdl.GeneratedFromVdl(name = "PByte", index = 1)
  public static class PByte extends Primitive {
    private static final long serialVersionUID = 1L;
    private byte elem;

    public PByte(byte elem) {
      super(1, elem);
      this.elem = elem;
    }

    public PByte() {
      this((byte) 0);
    }

    @Override
    public java.lang.Byte getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (int) elem;
    }
  }

  @io.v.v23.vdl.GeneratedFromVdl(name = "PUint", index = 2)
  public static class PUint extends Primitive {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vdl.VdlUint64 elem;

    public PUint(io.v.v23.vdl.VdlUint64 elem) {
      super(2, elem);
      this.elem = elem;
    }

    public PUint() {
      this(new io.v.v23.vdl.VdlUint64());
    }

    @Override
    public io.v.v23.vdl.VdlUint64 getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  @io.v.v23.vdl.GeneratedFromVdl(name = "PInt", index = 3)
  public static class PInt extends Primitive {
    private static final long serialVersionUID = 1L;
    private long elem;

    public PInt(long elem) {
      super(3, elem);
      this.elem = elem;
    }

    public PInt() {
      this(0L);
    }

    @Override
    public java.lang.Long getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return java.lang.Long.valueOf(elem).hashCode();
    }
  }

  @io.v.v23.vdl.GeneratedFromVdl(name = "PFloat", index = 4)
  public static class PFloat extends Primitive {
    private static final long serialVersionUID = 1L;
    private double elem;

    public PFloat(double elem) {
      super(4, elem);
      this.elem = elem;
    }

    public PFloat() {
      this(0.0);
    }

    @Override
    public java.lang.Double getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return java.lang.Double.valueOf(elem).hashCode();
    }
  }

  @io.v.v23.vdl.GeneratedFromVdl(name = "PString", index = 5)
  public static class PString extends Primitive {
    private static final long serialVersionUID = 1L;
    private java.lang.String elem;

    public PString(java.lang.String elem) {
      super(5, elem);
      this.elem = elem;
    }

    public PString() {
      this("");
    }

    @Override
    public java.lang.String getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  @io.v.v23.vdl.GeneratedFromVdl(name = "PControl", index = 6)
  public static class PControl extends Primitive {
    private static final long serialVersionUID = 1L;
    private io.v.v23.vom.ControlKind elem;

    public PControl(io.v.v23.vom.ControlKind elem) {
      super(6, elem);
      this.elem = elem;
    }

    public PControl() {
      this(io.v.v23.vom.ControlKind.Nil);
    }

    @Override
    public io.v.v23.vom.ControlKind getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Primitive.class);

  public Primitive(int index, Object value) {
    super(VDL_TYPE, index, value);
  }
}
