// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: dump.vdl
package io.v.v23.vom;

/**
 * DumpAtom describes a single indivisible piece of the vom encoding.  The vom
 * encoding is composed of a stream of these atoms.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/vom.DumpAtom")
public class DumpAtom extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Kind", index = 0)
  private io.v.v23.vom.DumpKind kind;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Bytes", index = 1)
  private byte[] bytes;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Data", index = 2)
  private io.v.v23.vom.Primitive data;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Debug", index = 3)
  private java.lang.String debug;

  /**
   * Vdl type for {@link DumpAtom}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DumpAtom.class);

  /**
   * Creates a new zero-value instance of {@link DumpAtom}.
   */
  public DumpAtom() {
    super(VDL_TYPE);

    this.kind = io.v.v23.vom.DumpKind.Version;

    this.bytes = new byte[] {};

    this.data = new io.v.v23.vom.Primitive.PBool();

    this.debug = "";
  }

  /**
   * Creates a new instance of {@link DumpAtom} with the provided field values.
   */
  public DumpAtom(
      io.v.v23.vom.DumpKind kind,
      byte[] bytes,
      io.v.v23.vom.Primitive data,
      java.lang.String debug) {
    super(VDL_TYPE);

    this.kind = kind;

    this.bytes = bytes;

    this.data = data;

    this.debug = debug;
  }

  /**
   * The kind of this atom.
   */
  public io.v.v23.vom.DumpKind getKind() {
    return this.kind;
  }

  /**
   * The kind of this atom.
   */
  public void setKind(io.v.v23.vom.DumpKind kind) {
    this.kind = kind;
  }

  /**
   * Raw bytes in the vom encoding representing this atom.
   */
  public byte[] getBytes() {
    return this.bytes;
  }

  /**
   * Raw bytes in the vom encoding representing this atom.
   */
  public void setBytes(byte[] bytes) {
    this.bytes = bytes;
  }

  /**
   * Primitive data corresponding to the raw bytes.
   */
  public io.v.v23.vom.Primitive getData() {
    return this.data;
  }

  /**
   * Primitive data corresponding to the raw bytes.
   */
  public void setData(io.v.v23.vom.Primitive data) {
    this.data = data;
  }

  /**
   * Free-form debug string with more information.
   */
  public java.lang.String getDebug() {
    return this.debug;
  }

  /**
   * Free-form debug string with more information.
   */
  public void setDebug(java.lang.String debug) {
    this.debug = debug;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DumpAtom other = (DumpAtom) obj;

    if (this.kind == null) {
      if (other.kind != null) {
        return false;
      }
    } else if (!this.kind.equals(other.kind)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.bytes, other.bytes)) {
      return false;
    }

    if (this.data == null) {
      if (other.data != null) {
        return false;
      }
    } else if (!this.data.equals(other.data)) {
      return false;
    }

    if (this.debug == null) {
      if (other.debug != null) {
        return false;
      }
    } else if (!this.debug.equals(other.debug)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.kind == null ? 0 : this.kind.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.bytes);

    result = prime * result + (this.data == null ? 0 : this.data.hashCode());

    result = prime * result + (this.debug == null ? 0 : this.debug.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "kind:" + this.kind;

    result += ", ";

    result += "bytes:" + java.util.Arrays.toString(this.bytes);

    result += ", ";

    result += "data:" + this.data;

    result += ", ";

    result += "debug:" + this.debug;

    return result + "}";
  }
}
