// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s): common.vdl
package io.v.v23.verror;

/**
 * BadVersion means the version presented by the client (e.g. to a service
 * that supports content-hash-based caching or atomic read-modify-write) was
 * out of date or otherwise invalid, likely because some other request caused
 * the version at the server to change. The client should get a fresh version
 * and try again.
 */
public final class BadVersionException extends io.v.v23.verror.VException {
  public static final io.v.v23.verror.VException.IDAction ID_ACTION =
      io.v.v23.verror.VException.register(
          "v.io/v23/verror.BadVersion",
          io.v.v23.verror.VException.ActionCode.NO_RETRY,
          "{1:}{2:} Version is out of date");

  static {
    io.v.v23.i18n.Language.getDefaultCatalog()
        .setWithBase("en", ID_ACTION.getID(), "{1:}{2:} Version is out of date");
  }

  public BadVersionException(io.v.v23.context.VContext _ctx) {
    super(ID_ACTION, _ctx, new java.lang.Object[] {}, new java.lang.reflect.Type[] {});
  }

  public BadVersionException(String _language, String _componentName, String _opName) {
    super(
        ID_ACTION,
        _language,
        _componentName,
        _opName,
        new java.lang.Object[] {}); //, new java.lang.reflect.Type[]{  });
  }

  private BadVersionException(io.v.v23.verror.VException e) {
    super(e);
  }
}
