// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: config.vdl
package io.v.v23.vdlroot.vdltool;

/**
 * SwiftConfig specifies swift specific configuration for this package.
 * Note that despite the SwiftConfig options for a given package (which should be
 * very rare in practice), we still need to know the name of the swift module
 * that this package relates to to properly understand import boundaries between
 * projects/frameworks/modules.
 *<p>
 * We do this by defining a file called "swiftmodule" that contains JUST the
 * name of the Swift module at the root of your VDL packages. For example,
 * if you have the VDL files for your Xcode project/target called UberForCats
 * at /Users/aaron/uberforcats/vdl, then create
 * /Users/aaron/uberforcats/vdl/com.uberforcats/swiftmodule and have it just contain
 * "UberForCats". We then will treat any VDL files contained in that directory and
 * any subdirectories as part of the UberForCats Swift module, ultimately letting
 * the compiler and will automatically do the right thing if others import your package.
 * If you don't do this then nobody will be able to import your VDL types in Swift,
 * and you might end up with extra long class/pkg names (ComuberforcatsServicesProfit
 * instead of ServicesProfit for $VDLROOT/com.uberforcats/services/profit).
 *<p>
 * If you are creating multiple Swift modules for a given $VDLROOT then just place
 * swiftmodule files at the logical boundaries. For eample, we do this for v.io/v23
 * to be exported to the VanadiumCore framework, but everything under v.io/v23/services
 * lives in the VanadiumServices framework.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "vdltool.SwiftConfig")
public class SwiftConfig extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "WireToNativeTypes", index = 0)
  private java.util.Map<java.lang.String, java.lang.String> wireToNativeTypes;

  /**
   * Vdl type for {@link SwiftConfig}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SwiftConfig.class);

  /**
   * Creates a new zero-value instance of {@link SwiftConfig}.
   */
  public SwiftConfig() {
    super(VDL_TYPE);

    this.wireToNativeTypes = new java.util.HashMap<java.lang.String, java.lang.String>();
  }

  /**
   * Creates a new instance of {@link SwiftConfig} with the provided field values.
   */
  public SwiftConfig(java.util.Map<java.lang.String, java.lang.String> wireToNativeTypes) {
    super(VDL_TYPE);

    this.wireToNativeTypes = wireToNativeTypes;
  }

  /**
   * WireToNativeTypes specifies the mapping from a VDL wire type to its Swift
   * native type representation.  This is rarely used and easy to configure
   * incorrectly; usage is currently restricted to packages that are explicitly
   * whitelisted.
   *<p>
   * WireToNativeTypes are meant for scenarios where there is an idiomatic Swift
   * type used in your code, but you need a standard VDL representation for wire
   * compatibility.  E.g. the VDL time package defines Duration and Time for
   * wire compatibility, but we want the generated code to use NSDate or NSTimeInterval
   *<p>
   * The key of the map is the name of the VDL type (aka WireType), which must
   * be defined in the vdl package associated with the vdl.config file.
   *<p>
   * The code generator assumes that the conversion functions will be registered
   * in Swift vdl package.
   */
  public java.util.Map<java.lang.String, java.lang.String> getWireToNativeTypes() {
    return this.wireToNativeTypes;
  }

  /**
   * WireToNativeTypes specifies the mapping from a VDL wire type to its Swift
   * native type representation.  This is rarely used and easy to configure
   * incorrectly; usage is currently restricted to packages that are explicitly
   * whitelisted.
   *<p>
   * WireToNativeTypes are meant for scenarios where there is an idiomatic Swift
   * type used in your code, but you need a standard VDL representation for wire
   * compatibility.  E.g. the VDL time package defines Duration and Time for
   * wire compatibility, but we want the generated code to use NSDate or NSTimeInterval
   *<p>
   * The key of the map is the name of the VDL type (aka WireType), which must
   * be defined in the vdl package associated with the vdl.config file.
   *<p>
   * The code generator assumes that the conversion functions will be registered
   * in Swift vdl package.
   */
  public void setWireToNativeTypes(
      java.util.Map<java.lang.String, java.lang.String> wireToNativeTypes) {
    this.wireToNativeTypes = wireToNativeTypes;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SwiftConfig other = (SwiftConfig) obj;

    if (this.wireToNativeTypes == null) {
      if (other.wireToNativeTypes != null) {
        return false;
      }
    } else if (!this.wireToNativeTypes.equals(other.wireToNativeTypes)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result =
        prime * result + (this.wireToNativeTypes == null ? 0 : this.wireToNativeTypes.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "wireToNativeTypes:" + this.wireToNativeTypes;

    return result + "}";
  }
}
