// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: config.vdl
package io.v.v23.vdlroot.vdltool;

/**
 * GoZero describes Go zero value behavior.
 *<p>
 * REQUIRED: Either Mode == Unique or IsZero is set.  We will not perform
 * native/wire conversions to check zero values.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "vdltool.GoZero")
public class GoZero extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Mode", index = 0)
  private io.v.v23.vdlroot.vdltool.GoZeroMode mode;

  @io.v.v23.vdl.GeneratedFromVdl(name = "IsZero", index = 1)
  private java.lang.String isZero;

  /**
   * Vdl type for {@link GoZero}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(GoZero.class);

  /**
   * Creates a new zero-value instance of {@link GoZero}.
   */
  public GoZero() {
    super(VDL_TYPE);

    this.mode = io.v.v23.vdlroot.vdltool.GoZeroMode.Unknown;

    this.isZero = "";
  }

  /**
   * Creates a new instance of {@link GoZero} with the provided field values.
   */
  public GoZero(io.v.v23.vdlroot.vdltool.GoZeroMode mode, java.lang.String isZero) {
    super(VDL_TYPE);

    this.mode = mode;

    this.isZero = isZero;
  }

  public io.v.v23.vdlroot.vdltool.GoZeroMode getMode() {
    return this.mode;
  }

  public void setMode(io.v.v23.vdlroot.vdltool.GoZeroMode mode) {
    this.mode = mode;
  }

  /**
   * IsZero specifies a field, method or function that returns true iff the
   * native value represents the VDL zero value.
   *<p>
   * If IsZero starts with a dot (.), it is assumed to be a field or method.
   * The field type or method return type must be bool.  Generated code will
   * apply the IsZero string verbatim to expressions of the native type.
   *<p>
   * If IsZero doesn't start with a dot(.), it is assumed to be a function whose
   * return type must be bool.  Generated code will call the function with a
   * single argument that is an expression of the native type.
   *<p>
   * TODO(toddw): The function form of IsZero isn't implemented.
   */
  public java.lang.String getIsZero() {
    return this.isZero;
  }

  /**
   * IsZero specifies a field, method or function that returns true iff the
   * native value represents the VDL zero value.
   *<p>
   * If IsZero starts with a dot (.), it is assumed to be a field or method.
   * The field type or method return type must be bool.  Generated code will
   * apply the IsZero string verbatim to expressions of the native type.
   *<p>
   * If IsZero doesn't start with a dot(.), it is assumed to be a function whose
   * return type must be bool.  Generated code will call the function with a
   * single argument that is an expression of the native type.
   *<p>
   * TODO(toddw): The function form of IsZero isn't implemented.
   */
  public void setIsZero(java.lang.String isZero) {
    this.isZero = isZero;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    GoZero other = (GoZero) obj;

    if (this.mode == null) {
      if (other.mode != null) {
        return false;
      }
    } else if (!this.mode.equals(other.mode)) {
      return false;
    }

    if (this.isZero == null) {
      if (other.isZero != null) {
        return false;
      }
    } else if (!this.isZero.equals(other.isZero)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.mode == null ? 0 : this.mode.hashCode());

    result = prime * result + (this.isZero == null ? 0 : this.isZero.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "mode:" + this.mode;

    result += ", ";

    result += "isZero:" + this.isZero;

    return result + "}";
  }
}
