// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: config.vdl
package io.v.v23.vdlroot.vdltool;

/**
 * GoType describes the Go type information associated with a VDL type.
 * See v.io/x/ref/lib/vdl/testdata/native for examples.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "vdltool.GoType")
public class GoType extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Kind", index = 0)
  private io.v.v23.vdlroot.vdltool.GoKind kind;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Type", index = 1)
  private java.lang.String type;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Zero", index = 2)
  private io.v.v23.vdlroot.vdltool.GoZero zero;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ToNative", index = 3)
  private java.lang.String toNative;

  @io.v.v23.vdl.GeneratedFromVdl(name = "FromNative", index = 4)
  private java.lang.String fromNative;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Imports", index = 5)
  private java.util.List<io.v.v23.vdlroot.vdltool.GoImport> imports;

  /**
   * Vdl type for {@link GoType}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(GoType.class);

  /**
   * Creates a new zero-value instance of {@link GoType}.
   */
  public GoType() {
    super(VDL_TYPE);

    this.kind = io.v.v23.vdlroot.vdltool.GoKind.Struct;

    this.type = "";

    this.zero = new io.v.v23.vdlroot.vdltool.GoZero();

    this.toNative = "";

    this.fromNative = "";

    this.imports = new java.util.ArrayList<io.v.v23.vdlroot.vdltool.GoImport>();
  }

  /**
   * Creates a new instance of {@link GoType} with the provided field values.
   */
  public GoType(
      io.v.v23.vdlroot.vdltool.GoKind kind,
      java.lang.String type,
      io.v.v23.vdlroot.vdltool.GoZero zero,
      java.lang.String toNative,
      java.lang.String fromNative,
      java.util.List<io.v.v23.vdlroot.vdltool.GoImport> imports) {
    super(VDL_TYPE);

    this.kind = kind;

    this.type = type;

    this.zero = zero;

    this.toNative = toNative;

    this.fromNative = fromNative;

    this.imports = imports;
  }

  /**
   * Kind is the kind of Type.
   */
  public io.v.v23.vdlroot.vdltool.GoKind getKind() {
    return this.kind;
  }

  /**
   * Kind is the kind of Type.
   */
  public void setKind(io.v.v23.vdlroot.vdltool.GoKind kind) {
    this.kind = kind;
  }

  /**
   * Type is the Go type to use in generated code, instead of the VDL type.
   */
  public java.lang.String getType() {
    return this.type;
  }

  /**
   * Type is the Go type to use in generated code, instead of the VDL type.
   */
  public void setType(java.lang.String type) {
    this.type = type;
  }

  /**
   * Zero specifies zero value setting and checking behavior.
   */
  public io.v.v23.vdlroot.vdltool.GoZero getZero() {
    return this.zero;
  }

  /**
   * Zero specifies zero value setting and checking behavior.
   */
  public void setZero(io.v.v23.vdlroot.vdltool.GoZero zero) {
    this.zero = zero;
  }

  /**
   * ToNative and FromNative overrides the names of the native conversion
   * functions.  If unspecified, the default functions are of the form:
   *   WireTypeToNative(wire WireType, native *NativeType) error
   *   WireTypeFromNative(wire *WireType, native NativeType) error
   */
  public java.lang.String getToNative() {
    return this.toNative;
  }

  /**
   * ToNative and FromNative overrides the names of the native conversion
   * functions.  If unspecified, the default functions are of the form:
   *   WireTypeToNative(wire WireType, native *NativeType) error
   *   WireTypeFromNative(wire *WireType, native NativeType) error
   */
  public void setToNative(java.lang.String toNative) {
    this.toNative = toNative;
  }

  public java.lang.String getFromNative() {
    return this.fromNative;
  }

  public void setFromNative(java.lang.String fromNative) {
    this.fromNative = fromNative;
  }

  /**
   * Imports are the Go imports referenced by the Type, ToNative and FromNative
   * fields.  In each field, use the standard local package name, and specify
   * the import package here.  E.g. to specify the native type time.Time:
   *   GoType{
   *     Kind:    Struct,
   *     Type:    "time.Time",
   *     Zero:    {Mode: Canonical, IsZero: ".IsZero()"},
   *     Imports: {{Path: "time", Name: "time"}},
   *   }
   */
  public java.util.List<io.v.v23.vdlroot.vdltool.GoImport> getImports() {
    return this.imports;
  }

  /**
   * Imports are the Go imports referenced by the Type, ToNative and FromNative
   * fields.  In each field, use the standard local package name, and specify
   * the import package here.  E.g. to specify the native type time.Time:
   *   GoType{
   *     Kind:    Struct,
   *     Type:    "time.Time",
   *     Zero:    {Mode: Canonical, IsZero: ".IsZero()"},
   *     Imports: {{Path: "time", Name: "time"}},
   *   }
   */
  public void setImports(java.util.List<io.v.v23.vdlroot.vdltool.GoImport> imports) {
    this.imports = imports;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    GoType other = (GoType) obj;

    if (this.kind == null) {
      if (other.kind != null) {
        return false;
      }
    } else if (!this.kind.equals(other.kind)) {
      return false;
    }

    if (this.type == null) {
      if (other.type != null) {
        return false;
      }
    } else if (!this.type.equals(other.type)) {
      return false;
    }

    if (this.zero == null) {
      if (other.zero != null) {
        return false;
      }
    } else if (!this.zero.equals(other.zero)) {
      return false;
    }

    if (this.toNative == null) {
      if (other.toNative != null) {
        return false;
      }
    } else if (!this.toNative.equals(other.toNative)) {
      return false;
    }

    if (this.fromNative == null) {
      if (other.fromNative != null) {
        return false;
      }
    } else if (!this.fromNative.equals(other.fromNative)) {
      return false;
    }

    if (this.imports == null) {
      if (other.imports != null) {
        return false;
      }
    } else if (!this.imports.equals(other.imports)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.kind == null ? 0 : this.kind.hashCode());

    result = prime * result + (this.type == null ? 0 : this.type.hashCode());

    result = prime * result + (this.zero == null ? 0 : this.zero.hashCode());

    result = prime * result + (this.toNative == null ? 0 : this.toNative.hashCode());

    result = prime * result + (this.fromNative == null ? 0 : this.fromNative.hashCode());

    result = prime * result + (this.imports == null ? 0 : this.imports.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "kind:" + this.kind;

    result += ", ";

    result += "type:" + this.type;

    result += ", ";

    result += "zero:" + this.zero;

    result += ", ";

    result += "toNative:" + this.toNative;

    result += ", ";

    result += "fromNative:" + this.fromNative;

    result += ", ";

    result += "imports:" + this.imports;

    return result + "}";
  }
}
