// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: config.vdl
package io.v.v23.vdlroot.vdltool;

/**
 * Config specifies the configuration for the vdl tool.  This is typically
 * represented in optional "vdl.config" files in each vdl source package.  Each
 * vdl.config file implicitly imports this package.  E.g. you may refer to
 * vdltool.Config in the "vdl.config" file without explicitly importing vdltool.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "vdltool.Config")
public class Config extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "GenLanguages", index = 0)
  private java.util.Set<io.v.v23.vdlroot.vdltool.GenLanguage> genLanguages;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Go", index = 1)
  private io.v.v23.vdlroot.vdltool.GoConfig go;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Java", index = 2)
  private io.v.v23.vdlroot.vdltool.JavaConfig java;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Javascript", index = 3)
  private io.v.v23.vdlroot.vdltool.JavascriptConfig javascript;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Swift", index = 4)
  private io.v.v23.vdlroot.vdltool.SwiftConfig swift;

  /**
   * Vdl type for {@link Config}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Config.class);

  /**
   * Creates a new zero-value instance of {@link Config}.
   */
  public Config() {
    super(VDL_TYPE);

    this.genLanguages = new java.util.HashSet<io.v.v23.vdlroot.vdltool.GenLanguage>();

    this.go = new io.v.v23.vdlroot.vdltool.GoConfig();

    this.java = new io.v.v23.vdlroot.vdltool.JavaConfig();

    this.javascript = new io.v.v23.vdlroot.vdltool.JavascriptConfig();

    this.swift = new io.v.v23.vdlroot.vdltool.SwiftConfig();
  }

  /**
   * Creates a new instance of {@link Config} with the provided field values.
   */
  public Config(
      java.util.Set<io.v.v23.vdlroot.vdltool.GenLanguage> genLanguages,
      io.v.v23.vdlroot.vdltool.GoConfig go,
      io.v.v23.vdlroot.vdltool.JavaConfig java,
      io.v.v23.vdlroot.vdltool.JavascriptConfig javascript,
      io.v.v23.vdlroot.vdltool.SwiftConfig swift) {
    super(VDL_TYPE);

    this.genLanguages = genLanguages;

    this.go = go;

    this.java = java;

    this.javascript = javascript;

    this.swift = swift;
  }

  /**
   * GenLanguages restricts the set of code generation languages.  If the set is
   * empty, all supported languages are allowed to be generated.
   */
  public java.util.Set<io.v.v23.vdlroot.vdltool.GenLanguage> getGenLanguages() {
    return this.genLanguages;
  }

  /**
   * GenLanguages restricts the set of code generation languages.  If the set is
   * empty, all supported languages are allowed to be generated.
   */
  public void setGenLanguages(java.util.Set<io.v.v23.vdlroot.vdltool.GenLanguage> genLanguages) {
    this.genLanguages = genLanguages;
  }

  /**
   * Language-specific configurations.
   */
  public io.v.v23.vdlroot.vdltool.GoConfig getGo() {
    return this.go;
  }

  /**
   * Language-specific configurations.
   */
  public void setGo(io.v.v23.vdlroot.vdltool.GoConfig go) {
    this.go = go;
  }

  public io.v.v23.vdlroot.vdltool.JavaConfig getJava() {
    return this.java;
  }

  public void setJava(io.v.v23.vdlroot.vdltool.JavaConfig java) {
    this.java = java;
  }

  public io.v.v23.vdlroot.vdltool.JavascriptConfig getJavascript() {
    return this.javascript;
  }

  public void setJavascript(io.v.v23.vdlroot.vdltool.JavascriptConfig javascript) {
    this.javascript = javascript;
  }

  public io.v.v23.vdlroot.vdltool.SwiftConfig getSwift() {
    return this.swift;
  }

  public void setSwift(io.v.v23.vdlroot.vdltool.SwiftConfig swift) {
    this.swift = swift;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Config other = (Config) obj;

    if (this.genLanguages == null) {
      if (other.genLanguages != null) {
        return false;
      }
    } else if (!this.genLanguages.equals(other.genLanguages)) {
      return false;
    }

    if (this.go == null) {
      if (other.go != null) {
        return false;
      }
    } else if (!this.go.equals(other.go)) {
      return false;
    }

    if (this.java == null) {
      if (other.java != null) {
        return false;
      }
    } else if (!this.java.equals(other.java)) {
      return false;
    }

    if (this.javascript == null) {
      if (other.javascript != null) {
        return false;
      }
    } else if (!this.javascript.equals(other.javascript)) {
      return false;
    }

    if (this.swift == null) {
      if (other.swift != null) {
        return false;
      }
    } else if (!this.swift.equals(other.swift)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.genLanguages == null ? 0 : this.genLanguages.hashCode());

    result = prime * result + (this.go == null ? 0 : this.go.hashCode());

    result = prime * result + (this.java == null ? 0 : this.java.hashCode());

    result = prime * result + (this.javascript == null ? 0 : this.javascript.hashCode());

    result = prime * result + (this.swift == null ? 0 : this.swift.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "genLanguages:" + this.genLanguages;

    result += ", ";

    result += "go:" + this.go;

    result += ", ";

    result += "java:" + this.java;

    result += ", ";

    result += "javascript:" + this.javascript;

    result += ", ";

    result += "swift:" + this.swift;

    return result + "}";
  }
}
