// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: time.vdl
package io.v.v23.vdlroot.time;

/**
 * WireDeadline represents the deadline for an operation, where the operation is
 * expected to finish before the deadline.  The intended usage is for a client
 * to set a deadline on an operation, say one minute from "now", and send the
 * deadline to a server.  The server is expected to finish the operation before
 * the deadline.
 *<p>
 * On a single device, it is simplest to represent a deadline as an absolute
 * time; when the time now reaches the deadline, the deadline has expired.
 * However when sending a deadline between devices with potential clock skew, it
 * is often more robust to represent the deadline as a duration from "now".  The
 * sender computes the duration from its notion of "now", while the receiver
 * computes the absolute deadline from its own notion of "now".
 *<p>
 * This representation doesn't account for propagation delay, but does ensure
 * that the deadline used by the receiver is no earlier than the deadline
 * intended by the client.  In many common scenarios the propagation delay is
 * small compared to the potential clock skew, making this a simple but
 * effective approach.
 *<p>
 * WireDeadline typically has a native representation called Deadline that is an
 * absolute Time, which automatically performs the sender and receiver
 * conversions from "now".
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "time.WireDeadline")
public class WireDeadline extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "FromNow", index = 0)
  private org.joda.time.Duration fromNow;

  /**
   * Vdl type for {@link WireDeadline}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireDeadline.class);

  /**
   * Creates a new zero-value instance of {@link WireDeadline}.
   */
  public WireDeadline() {
    super(VDL_TYPE);

    this.fromNow = null;
  }

  /**
   * Creates a new instance of {@link WireDeadline} with the provided field values.
   */
  public WireDeadline(org.joda.time.Duration fromNow) {
    super(VDL_TYPE);

    this.fromNow = fromNow;
  }

  /**
   * FromNow represents the deadline as a duration from "now".  As a
   * special-case, the 0 duration indicates that there is no deadline; i.e. the
   * deadline is "infinite".
   */
  public org.joda.time.Duration getFromNow() {
    return this.fromNow;
  }

  /**
   * FromNow represents the deadline as a duration from "now".  As a
   * special-case, the 0 duration indicates that there is no deadline; i.e. the
   * deadline is "infinite".
   */
  public void setFromNow(org.joda.time.Duration fromNow) {
    this.fromNow = fromNow;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WireDeadline other = (WireDeadline) obj;

    if (this.fromNow == null) {
      if (other.fromNow != null) {
        return false;
      }
    } else if (!this.fromNow.equals(other.fromNow)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.fromNow == null ? 0 : this.fromNow.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "fromNow:" + this.fromNow;

    return result + "}";
  }
}
