// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: time.vdl
package io.v.v23.vdlroot.time;

/**
 * Time represents an absolute point in time with up to nanosecond precision.
 *<p>
 * Time is represented as the duration before or after a fixed epoch.  The zero
 * Time represents the epoch 0001-01-01T00:00:00.000000000Z.  This uses the
 * proleptic Gregorian calendar; the calendar runs on an exact 400 year cycle.
 * Leap seconds are "smeared", ensuring that no leap second table is necessary
 * for interpretation.
 *<p>
 * This is similar to Go time.Time, but always in the UTC location.
 * http://golang.org/pkg/time/#Time
 *<p>
 * This is similar to conventional "unix time", but with the epoch defined at
 * year 1 rather than year 1970.  This allows the zero Time to be used as a
 * natural sentry, since it isn't a valid time for many practical applications.
 * http://en.wikipedia.org/wiki/Unix_time
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "time.Time")
public class Time extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Seconds", index = 0)
  private long seconds;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Nanos", index = 1)
  private int nanos;

  /**
   * Vdl type for {@link Time}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Time.class);

  /**
   * Creates a new zero-value instance of {@link Time}.
   */
  public Time() {
    super(VDL_TYPE);

    this.seconds = 0L;

    this.nanos = 0;
  }

  /**
   * Creates a new instance of {@link Time} with the provided field values.
   */
  public Time(long seconds, int nanos) {
    super(VDL_TYPE);

    this.seconds = seconds;

    this.nanos = nanos;
  }

  public long getSeconds() {
    return this.seconds;
  }

  public void setSeconds(long seconds) {
    this.seconds = seconds;
  }

  public int getNanos() {
    return this.nanos;
  }

  public void setNanos(int nanos) {
    this.nanos = nanos;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Time other = (Time) obj;

    if (this.seconds != other.seconds) {
      return false;
    }

    if (this.nanos != other.nanos) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Long.valueOf(this.seconds).hashCode();

    result = prime * result + this.nanos;

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "seconds:" + this.seconds;

    result += ", ";

    result += "nanos:" + this.nanos;

    return result + "}";
  }
}
