// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: time.vdl
package io.v.v23.vdlroot.time;

/**
 * Duration represents the elapsed duration between two points in time, with
 * up to nanosecond precision.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "time.Duration")
public class Duration extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Seconds", index = 0)
  private long seconds;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Nanos", index = 1)
  private int nanos;

  /**
   * Vdl type for {@link Duration}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Duration.class);

  /**
   * Creates a new zero-value instance of {@link Duration}.
   */
  public Duration() {
    super(VDL_TYPE);

    this.seconds = 0L;

    this.nanos = 0;
  }

  /**
   * Creates a new instance of {@link Duration} with the provided field values.
   */
  public Duration(long seconds, int nanos) {
    super(VDL_TYPE);

    this.seconds = seconds;

    this.nanos = nanos;
  }

  /**
   * Seconds represents the seconds in the duration.  The range is roughly
   * +/-290 billion years, larger than the estimated age of the universe.
   */
  public long getSeconds() {
    return this.seconds;
  }

  /**
   * Seconds represents the seconds in the duration.  The range is roughly
   * +/-290 billion years, larger than the estimated age of the universe.
   */
  public void setSeconds(long seconds) {
    this.seconds = seconds;
  }

  /**
   * Nanos represents the fractions of a second at nanosecond resolution.  Must
   * be in the inclusive range between +/-999,999,999.
   *<p>
   * In normalized form, durations less than one second are represented with 0
   * Seconds and +/-Nanos.  For durations one second or more, the sign of Nanos
   * must match Seconds, or be 0.
   */
  public int getNanos() {
    return this.nanos;
  }

  /**
   * Nanos represents the fractions of a second at nanosecond resolution.  Must
   * be in the inclusive range between +/-999,999,999.
   *<p>
   * In normalized form, durations less than one second are represented with 0
   * Seconds and +/-Nanos.  For durations one second or more, the sign of Nanos
   * must match Seconds, or be 0.
   */
  public void setNanos(int nanos) {
    this.nanos = nanos;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Duration other = (Duration) obj;

    if (this.seconds != other.seconds) {
      return false;
    }

    if (this.nanos != other.nanos) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Long.valueOf(this.seconds).hashCode();

    result = prime * result + this.nanos;

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "seconds:" + this.seconds;

    result += ", ";

    result += "nanos:" + this.nanos;

    return result + "}";
  }
}
