// Copyright 2016 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: math.vdl
package io.v.v23.vdlroot.math;

/**
 * Complex64 is a complex number composed of 32-bit real and imaginary parts.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "math.Complex64")
public class Complex64 extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Real", index = 0)
  private float real;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Imag", index = 1)
  private float imag;

  /**
   * Vdl type for {@link Complex64}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Complex64.class);

  /**
   * Creates a new zero-value instance of {@link Complex64}.
   */
  public Complex64() {
    super(VDL_TYPE);

    this.real = 0.0f;

    this.imag = 0.0f;
  }

  /**
   * Creates a new instance of {@link Complex64} with the provided field values.
   */
  public Complex64(float real, float imag) {
    super(VDL_TYPE);

    this.real = real;

    this.imag = imag;
  }

  public float getReal() {
    return this.real;
  }

  public void setReal(float real) {
    this.real = real;
  }

  public float getImag() {
    return this.imag;
  }

  public void setImag(float imag) {
    this.imag = imag;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Complex64 other = (Complex64) obj;

    if (this.real != other.real) {
      return false;
    }

    if (this.imag != other.imag) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Float.valueOf(this.real).hashCode();

    result = prime * result + java.lang.Float.valueOf(this.imag).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "real:" + this.real;

    result += ", ";

    result += "imag:" + this.imag;

    return result + "}";
  }
}
