// Copyright 2016 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: math.vdl
package io.v.v23.vdlroot.math;

/**
 * Complex128 is a complex number composed of 64-bit real and imaginary parts.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "math.Complex128")
public class Complex128 extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Real", index = 0)
  private double real;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Imag", index = 1)
  private double imag;

  /**
   * Vdl type for {@link Complex128}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Complex128.class);

  /**
   * Creates a new zero-value instance of {@link Complex128}.
   */
  public Complex128() {
    super(VDL_TYPE);

    this.real = 0.0;

    this.imag = 0.0;
  }

  /**
   * Creates a new instance of {@link Complex128} with the provided field values.
   */
  public Complex128(double real, double imag) {
    super(VDL_TYPE);

    this.real = real;

    this.imag = imag;
  }

  public double getReal() {
    return this.real;
  }

  public void setReal(double real) {
    this.real = real;
  }

  public double getImag() {
    return this.imag;
  }

  public void setImag(double imag) {
    this.imag = imag;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Complex128 other = (Complex128) obj;

    if (this.real != other.real) {
      return false;
    }

    if (this.imag != other.imag) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Double.valueOf(this.real).hashCode();

    result = prime * result + java.lang.Double.valueOf(this.imag).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "real:" + this.real;

    result += ", ";

    result += "imag:" + this.imag;

    return result + "}";
  }
}
