// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: builtin.vdl
package io.v.v23.vdl;

/**
 * WireError is the wire representation for the built-in error type.  Errors and
 * exceptions in each programming environment are converted to this type to
 * ensure wire compatibility.  Generated code for each environment provides
 * automatic conversions into idiomatic native representations.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/vdl.WireError")
public class WireError extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private java.lang.String id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RetryCode", index = 1)
  private io.v.v23.vdl.WireRetryCode retryCode;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Msg", index = 2)
  private java.lang.String msg;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ParamList", index = 3)
  private java.util.List<io.v.v23.vdl.VdlAny> paramList;

  /**
   * Vdl type for {@link WireError}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireError.class);

  /**
   * Creates a new zero-value instance of {@link WireError}.
   */
  public WireError() {
    super(VDL_TYPE);

    this.id = "";

    this.retryCode = io.v.v23.vdl.WireRetryCode.NoRetry;

    this.msg = "";

    this.paramList = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();
  }

  /**
   * Creates a new instance of {@link WireError} with the provided field values.
   */
  public WireError(
      java.lang.String id,
      io.v.v23.vdl.WireRetryCode retryCode,
      java.lang.String msg,
      java.util.List<io.v.v23.vdl.VdlAny> paramList) {
    super(VDL_TYPE);

    this.id = id;

    this.retryCode = retryCode;

    this.msg = msg;

    this.paramList = paramList;
  }

  /**
   * Error Id, used to uniquely identify each error.
   */
  public java.lang.String getId() {
    return this.id;
  }

  /**
   * Error Id, used to uniquely identify each error.
   */
  public void setId(java.lang.String id) {
    this.id = id;
  }

  /**
   * Retry behavior suggested for the receiver.
   */
  public io.v.v23.vdl.WireRetryCode getRetryCode() {
    return this.retryCode;
  }

  /**
   * Retry behavior suggested for the receiver.
   */
  public void setRetryCode(io.v.v23.vdl.WireRetryCode retryCode) {
    this.retryCode = retryCode;
  }

  /**
   * Error message, may be empty.
   */
  public java.lang.String getMsg() {
    return this.msg;
  }

  /**
   * Error message, may be empty.
   */
  public void setMsg(java.lang.String msg) {
    this.msg = msg;
  }

  /**
   * Variadic parameters contained in the error.
   */
  public java.util.List<io.v.v23.vdl.VdlAny> getParamList() {
    return this.paramList;
  }

  /**
   * Variadic parameters contained in the error.
   */
  public void setParamList(java.util.List<io.v.v23.vdl.VdlAny> paramList) {
    this.paramList = paramList;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WireError other = (WireError) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (this.retryCode == null) {
      if (other.retryCode != null) {
        return false;
      }
    } else if (!this.retryCode.equals(other.retryCode)) {
      return false;
    }

    if (this.msg == null) {
      if (other.msg != null) {
        return false;
      }
    } else if (!this.msg.equals(other.msg)) {
      return false;
    }

    if (this.paramList == null) {
      if (other.paramList != null) {
        return false;
      }
    } else if (!this.paramList.equals(other.paramList)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + (this.retryCode == null ? 0 : this.retryCode.hashCode());

    result = prime * result + (this.msg == null ? 0 : this.msg.hashCode());

    result = prime * result + (this.paramList == null ? 0 : this.paramList.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "retryCode:" + this.retryCode;

    result += ", ";

    result += "msg:" + this.msg;

    result += ", ";

    result += "paramList:" + this.paramList;

    return result + "}";
  }
}
