// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.syncbase;

/**
 * Value contains a specific version of data for the row under conflict along
 * with the write timestamp and hints associated with the version.
 * State defines whether the value is empty or not. It can be empty for
 * reasons like Deleted or Unknown.
 * WriteTs is the write timestamp for this value.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/syncbase.Value")
public class Value extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "State", index = 0)
  private io.v.v23.services.syncbase.ValueState state;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Val", index = 1)
  private io.v.v23.vdl.VdlAny val;

  @io.v.v23.vdl.GeneratedFromVdl(name = "WriteTs", index = 2)
  private org.joda.time.DateTime writeTs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Selection", index = 3)
  private io.v.v23.services.syncbase.ValueSelection selection;

  /**
   * Vdl type for {@link Value}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Value.class);

  /**
   * Creates a new zero-value instance of {@link Value}.
   */
  public Value() {
    super(VDL_TYPE);

    this.state = io.v.v23.services.syncbase.ValueState.Exists;

    this.val = new io.v.v23.vdl.VdlAny();

    this.writeTs = null;

    this.selection = io.v.v23.services.syncbase.ValueSelection.Local;
  }

  /**
   * Creates a new instance of {@link Value} with the provided field values.
   */
  public Value(
      io.v.v23.services.syncbase.ValueState state,
      io.v.v23.vdl.VdlAny val,
      org.joda.time.DateTime writeTs,
      io.v.v23.services.syncbase.ValueSelection selection) {
    super(VDL_TYPE);

    this.state = state;

    this.val = val;

    this.writeTs = writeTs;

    this.selection = selection;
  }

  public io.v.v23.services.syncbase.ValueState getState() {
    return this.state;
  }

  public void setState(io.v.v23.services.syncbase.ValueState state) {
    this.state = state;
  }

  public io.v.v23.vdl.VdlAny getVal() {
    return this.val;
  }

  public void setVal(io.v.v23.vdl.VdlAny val) {
    this.val = val;
  }

  public org.joda.time.DateTime getWriteTs() {
    return this.writeTs;
  }

  public void setWriteTs(org.joda.time.DateTime writeTs) {
    this.writeTs = writeTs;
  }

  /**
   * TODO(jlodhia): Since field Selection cannot be package private in VDL,
   * review the ConflictResolution API to see if we should keep this field
   * or not.
   */
  public io.v.v23.services.syncbase.ValueSelection getSelection() {
    return this.selection;
  }

  /**
   * TODO(jlodhia): Since field Selection cannot be package private in VDL,
   * review the ConflictResolution API to see if we should keep this field
   * or not.
   */
  public void setSelection(io.v.v23.services.syncbase.ValueSelection selection) {
    this.selection = selection;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Value other = (Value) obj;

    if (this.state == null) {
      if (other.state != null) {
        return false;
      }
    } else if (!this.state.equals(other.state)) {
      return false;
    }

    if (this.val == null) {
      if (other.val != null) {
        return false;
      }
    } else if (!this.val.equals(other.val)) {
      return false;
    }

    if (this.writeTs == null) {
      if (other.writeTs != null) {
        return false;
      }
    } else if (!this.writeTs.equals(other.writeTs)) {
      return false;
    }

    if (this.selection == null) {
      if (other.selection != null) {
        return false;
      }
    } else if (!this.selection.equals(other.selection)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.state == null ? 0 : this.state.hashCode());

    result = prime * result + (this.val == null ? 0 : this.val.hashCode());

    result = prime * result + (this.writeTs == null ? 0 : this.writeTs.hashCode());

    result = prime * result + (this.selection == null ? 0 : this.selection.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "state:" + this.state;

    result += ", ";

    result += "val:" + this.val;

    result += ", ";

    result += "writeTs:" + this.writeTs;

    result += ", ";

    result += "selection:" + this.selection;

    return result + "}";
  }
}
