// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.syncbase;

/**
 * ConflictRowSet contains a set of rows under conflict. It provides two different
 * ways to access the same set.
 * ByKey is a map of ConflictRows keyed by the row key.
 * ByBatch is a map of []ConflictRows keyed by batch id. This map lets the client
 * access all ConflictRows within this set that contain a given hint.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/syncbase.ConflictRowSet")
public class ConflictRowSet extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ByKey", index = 0)
  private java.util.Map<java.lang.String, io.v.v23.syncbase.ConflictRow> byKey;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ByBatch", index = 1)
  private java.util.Map<io.v.v23.vdl.VdlUint64, java.util.List<io.v.v23.syncbase.ConflictRow>>
      byBatch;

  /**
   * Vdl type for {@link ConflictRowSet}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(ConflictRowSet.class);

  /**
   * Creates a new zero-value instance of {@link ConflictRowSet}.
   */
  public ConflictRowSet() {
    super(VDL_TYPE);

    this.byKey = new java.util.HashMap<java.lang.String, io.v.v23.syncbase.ConflictRow>();

    this.byBatch =
        new java.util.HashMap<
            io.v.v23.vdl.VdlUint64, java.util.List<io.v.v23.syncbase.ConflictRow>>();
  }

  /**
   * Creates a new instance of {@link ConflictRowSet} with the provided field values.
   */
  public ConflictRowSet(
      java.util.Map<java.lang.String, io.v.v23.syncbase.ConflictRow> byKey,
      java.util.Map<io.v.v23.vdl.VdlUint64, java.util.List<io.v.v23.syncbase.ConflictRow>>
          byBatch) {
    super(VDL_TYPE);

    this.byKey = byKey;

    this.byBatch = byBatch;
  }

  public java.util.Map<java.lang.String, io.v.v23.syncbase.ConflictRow> getByKey() {
    return this.byKey;
  }

  public void setByKey(java.util.Map<java.lang.String, io.v.v23.syncbase.ConflictRow> byKey) {
    this.byKey = byKey;
  }

  public java.util.Map<io.v.v23.vdl.VdlUint64, java.util.List<io.v.v23.syncbase.ConflictRow>>
      getByBatch() {
    return this.byBatch;
  }

  public void setByBatch(
      java.util.Map<io.v.v23.vdl.VdlUint64, java.util.List<io.v.v23.syncbase.ConflictRow>>
          byBatch) {
    this.byBatch = byBatch;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    ConflictRowSet other = (ConflictRowSet) obj;

    if (this.byKey == null) {
      if (other.byKey != null) {
        return false;
      }
    } else if (!this.byKey.equals(other.byKey)) {
      return false;
    }

    if (this.byBatch == null) {
      if (other.byBatch != null) {
        return false;
      }
    } else if (!this.byBatch.equals(other.byBatch)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.byKey == null ? 0 : this.byKey.hashCode());

    result = prime * result + (this.byBatch == null ? 0 : this.byBatch.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "byKey:" + this.byKey;

    result += ", ";

    result += "byBatch:" + this.byBatch;

    return result + "}";
  }
}
