// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.syncbase;

/**
 * ConflictRow represents a row under conflict.
 * Key is the key for the row.
 * LocalValue is the value present in the local db.
 * RemoteValue is the value received via sync.
 * AncestorValue is the value for the key which is the lowest common
 * ancestor of the two values represented by LocalValue and RemoteValue.
 * AncestorValue's state is NoExists if the ConflictRow is a part of the read set.
 * BatchIds is a list of ids of all the batches that this row belongs to.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/syncbase.ConflictRow")
public class ConflictRow extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Key", index = 0)
  private java.lang.String key;

  @io.v.v23.vdl.GeneratedFromVdl(name = "LocalValue", index = 1)
  private io.v.v23.syncbase.Value localValue;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RemoteValue", index = 2)
  private io.v.v23.syncbase.Value remoteValue;

  @io.v.v23.vdl.GeneratedFromVdl(name = "AncestorValue", index = 3)
  private io.v.v23.syncbase.Value ancestorValue;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BatchIds", index = 4)
  private java.util.List<io.v.v23.vdl.VdlUint64> batchIds;

  /**
   * Vdl type for {@link ConflictRow}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(ConflictRow.class);

  /**
   * Creates a new zero-value instance of {@link ConflictRow}.
   */
  public ConflictRow() {
    super(VDL_TYPE);

    this.key = "";

    this.localValue = new io.v.v23.syncbase.Value();

    this.remoteValue = new io.v.v23.syncbase.Value();

    this.ancestorValue = new io.v.v23.syncbase.Value();

    this.batchIds = new java.util.ArrayList<io.v.v23.vdl.VdlUint64>();
  }

  /**
   * Creates a new instance of {@link ConflictRow} with the provided field values.
   */
  public ConflictRow(
      java.lang.String key,
      io.v.v23.syncbase.Value localValue,
      io.v.v23.syncbase.Value remoteValue,
      io.v.v23.syncbase.Value ancestorValue,
      java.util.List<io.v.v23.vdl.VdlUint64> batchIds) {
    super(VDL_TYPE);

    this.key = key;

    this.localValue = localValue;

    this.remoteValue = remoteValue;

    this.ancestorValue = ancestorValue;

    this.batchIds = batchIds;
  }

  public java.lang.String getKey() {
    return this.key;
  }

  public void setKey(java.lang.String key) {
    this.key = key;
  }

  public io.v.v23.syncbase.Value getLocalValue() {
    return this.localValue;
  }

  public void setLocalValue(io.v.v23.syncbase.Value localValue) {
    this.localValue = localValue;
  }

  public io.v.v23.syncbase.Value getRemoteValue() {
    return this.remoteValue;
  }

  public void setRemoteValue(io.v.v23.syncbase.Value remoteValue) {
    this.remoteValue = remoteValue;
  }

  public io.v.v23.syncbase.Value getAncestorValue() {
    return this.ancestorValue;
  }

  public void setAncestorValue(io.v.v23.syncbase.Value ancestorValue) {
    this.ancestorValue = ancestorValue;
  }

  public java.util.List<io.v.v23.vdl.VdlUint64> getBatchIds() {
    return this.batchIds;
  }

  public void setBatchIds(java.util.List<io.v.v23.vdl.VdlUint64> batchIds) {
    this.batchIds = batchIds;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    ConflictRow other = (ConflictRow) obj;

    if (this.key == null) {
      if (other.key != null) {
        return false;
      }
    } else if (!this.key.equals(other.key)) {
      return false;
    }

    if (this.localValue == null) {
      if (other.localValue != null) {
        return false;
      }
    } else if (!this.localValue.equals(other.localValue)) {
      return false;
    }

    if (this.remoteValue == null) {
      if (other.remoteValue != null) {
        return false;
      }
    } else if (!this.remoteValue.equals(other.remoteValue)) {
      return false;
    }

    if (this.ancestorValue == null) {
      if (other.ancestorValue != null) {
        return false;
      }
    } else if (!this.ancestorValue.equals(other.ancestorValue)) {
      return false;
    }

    if (this.batchIds == null) {
      if (other.batchIds != null) {
        return false;
      }
    } else if (!this.batchIds.equals(other.batchIds)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.key == null ? 0 : this.key.hashCode());

    result = prime * result + (this.localValue == null ? 0 : this.localValue.hashCode());

    result = prime * result + (this.remoteValue == null ? 0 : this.remoteValue.hashCode());

    result = prime * result + (this.ancestorValue == null ? 0 : this.ancestorValue.hashCode());

    result = prime * result + (this.batchIds == null ? 0 : this.batchIds.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "key:" + this.key;

    result += ", ";

    result += "localValue:" + this.localValue;

    result += ", ";

    result += "remoteValue:" + this.remoteValue;

    result += ", ";

    result += "ancestorValue:" + this.ancestorValue;

    result += ", ";

    result += "batchIds:" + this.batchIds;

    return result + "}";
  }
}
