// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.syncbase;

/**
 * Conflict contains information to fully specify a conflict. Since syncbase
 * supports batches there can be one or more rows within the batch that has a
 * conflict. Each of these rows will be sent together as part of a single
 * conflict. Each row contains an Id of the batch to which it belongs,
 * enabling the client to group together rows that are part of a batch. Note
 * that a single row can be part of more than one batch.
 *<p>
 * WriteSet contains rows that were written.
 * ReadSet contains rows that were read within a batch corresponding to a row
 * within the write set.
 * ScanSet contains scans performed within a batch corresponding to a row
 * within the write set.
 * Batches is a map of unique ids to BatchInfo objects. The id is unique only in
 * the context of a given conflict and is otherwise meaningless.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/syncbase.Conflict")
public class Conflict extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ReadSet", index = 0)
  private io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> readSet;

  @io.v.v23.vdl.GeneratedFromVdl(name = "WriteSet", index = 1)
  private io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> writeSet;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ScanSet", index = 2)
  private io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictScanSet> scanSet;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Batches", index = 3)
  private java.util.Map<io.v.v23.vdl.VdlUint64, io.v.v23.services.syncbase.BatchInfo> batches;

  /**
   * Vdl type for {@link Conflict}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Conflict.class);

  /**
   * Creates a new zero-value instance of {@link Conflict}.
   */
  public Conflict() {
    super(VDL_TYPE);

    this.readSet =
        new io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet>(
            new com.google.common.reflect.TypeToken<
                io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet>>() {}.getType());

    this.writeSet =
        new io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet>(
            new com.google.common.reflect.TypeToken<
                io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet>>() {}.getType());

    this.scanSet =
        new io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictScanSet>(
            new com.google.common.reflect.TypeToken<
                io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictScanSet>>() {}.getType());

    this.batches =
        new java.util.HashMap<io.v.v23.vdl.VdlUint64, io.v.v23.services.syncbase.BatchInfo>();
  }

  /**
   * Creates a new instance of {@link Conflict} with the provided field values.
   */
  public Conflict(
      io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> readSet,
      io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> writeSet,
      io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictScanSet> scanSet,
      java.util.Map<io.v.v23.vdl.VdlUint64, io.v.v23.services.syncbase.BatchInfo> batches) {
    super(VDL_TYPE);

    this.readSet = readSet;

    this.writeSet = writeSet;

    this.scanSet = scanSet;

    this.batches = batches;
  }

  public io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> getReadSet() {
    return this.readSet;
  }

  public void setReadSet(io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> readSet) {
    this.readSet = readSet;
  }

  public io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> getWriteSet() {
    return this.writeSet;
  }

  public void setWriteSet(io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictRowSet> writeSet) {
    this.writeSet = writeSet;
  }

  public io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictScanSet> getScanSet() {
    return this.scanSet;
  }

  public void setScanSet(io.v.v23.vdl.VdlOptional<io.v.v23.syncbase.ConflictScanSet> scanSet) {
    this.scanSet = scanSet;
  }

  public java.util.Map<io.v.v23.vdl.VdlUint64, io.v.v23.services.syncbase.BatchInfo> getBatches() {
    return this.batches;
  }

  public void setBatches(
      java.util.Map<io.v.v23.vdl.VdlUint64, io.v.v23.services.syncbase.BatchInfo> batches) {
    this.batches = batches;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Conflict other = (Conflict) obj;

    if (this.readSet == null) {
      if (other.readSet != null) {
        return false;
      }
    } else if (!this.readSet.equals(other.readSet)) {
      return false;
    }

    if (this.writeSet == null) {
      if (other.writeSet != null) {
        return false;
      }
    } else if (!this.writeSet.equals(other.writeSet)) {
      return false;
    }

    if (this.scanSet == null) {
      if (other.scanSet != null) {
        return false;
      }
    } else if (!this.scanSet.equals(other.scanSet)) {
      return false;
    }

    if (this.batches == null) {
      if (other.batches != null) {
        return false;
      }
    } else if (!this.batches.equals(other.batches)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.readSet == null ? 0 : this.readSet.hashCode());

    result = prime * result + (this.writeSet == null ? 0 : this.writeSet.hashCode());

    result = prime * result + (this.scanSet == null ? 0 : this.scanSet.hashCode());

    result = prime * result + (this.batches == null ? 0 : this.batches.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "readSet:" + this.readSet;

    result += ", ";

    result += "writeSet:" + this.writeSet;

    result += ", ";

    result += "scanSet:" + this.scanSet;

    result += ", ";

    result += "batches:" + this.batches;

    return result + "}";
  }
}
