// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl

/**
 * Package watch defines interfaces for watching a sequence of changes.
 *<p>
 * API Overview
 *<p>
 * Watcher service allows a client to watch for updates that match a
 * query.  For each watched query, the client will receive a reliable
 * stream of watch events without re-ordering.
 *<p>
 * The watching is done by starting a streaming RPC. The argument to
 * the RPC contains the query. The result stream consists of a
 * never-ending sequence of Change messages (until the call fails or
 * is cancelled).
 *<p>
 * Root Entity
 *<p>
 * The Object name that receives the Watch RPC is called the root
 * entity.  The root entity is the parent of all entities that the
 * client cares about.  Therefore, the query is confined to children
 * of the root entity, and the names in the Change messages are all
 * relative to the root entity.
 *<p>
 * Watch Request
 *<p>
 * When a client makes a watch request, it can indicate whether it
 * wants to receive the initial states of the entities that match the
 * query, just new changes to the entities, or resume watching from a
 * particular point in a previous watch stream.  On receiving a watch
 * request, the server sends one or more messages to the client. The
 * first message informs the client that the server has registered the
 * client's request; the instant of time when the client receives the
 * event is referred to as the client's "watch point" for that query.
 *<p>
 * Atomic Delivery
 *<p>
 * The response stream consists of a sequence of Change messages. Each
 * Change message contains an optional continued bit
 * (default=false). A sub-sequence of Change messages with
 * continued=true followed by a Change message with continued=false
 * forms an "atomic group". Systems that support multi-entity atomic
 * updates may guarantee that all changes resulting from a single
 * atomic update are delivered in the same "atomic group". It is up to
 * the documentation of a particular system that implements the Watch
 * API to document whether or not it supports such grouping. We expect
 * that most callers will ignore the notion of atomic delivery and the
 * continued bit, i.e., they will just process each Change message as
 * it is received.
 *<p>
 * Initial State
 *<p>
 * The first atomic group delivered by a watch call is special. It is
 * delivered as soon as possible and contains the initial state of the
 * entities being watched.  The client should consider itself caught up
 * after processing this first atomic group.  The messages in this first
 * atomic group depend on the value of ResumeMarker.
 *<p>
 *   (1) ResumeMarker is "" or not specified: For every entity P that
 *       matches the query and exists, there will be at least one message
 *       delivered with entity == P and the last such message will contain
 *       the current state of P.  For every entity Q (including the entity
 *       itself) that matches the query but does not exist, either no
 *       message will be delivered, or the last message for Q will have
 *       state == DOES_NOT_EXIST. At least one message for entity="" will
 *       be delivered.
 *<p>
 *   (2) ResumeMarker == "now": there will be exactly one message with
 *       entity = "" and state INITIAL_STATE_SKIPPED.  The client cannot
 *       assume whether or not the entity exists after receiving this
 *       message.
 *<p>
 *   (3) ResumeMarker has a value R from a preceding watch call on this
 *       entity: The same messages as described in (1) will be delivered
 *       to the client except that any information implied by messages
 *       received on the preceding call up to and including R may not be
 *       delivered. The expectation is that the client will start with
 *       state it had built up from the preceding watch call, apply the
 *       changes received from this call and build an up-to-date view of
 *       the entities without having to fetch a potentially large amount
 *       of information that has not changed.  Note that some information
 *       that had already been delivered by the preceding call might be
 *       delivered again.
 *<p>
 * Ordering and Reliability
 *<p>
 * The Change messages that apply to a particular element of the
 * entity will be delivered eventually in order without loss for the
 * duration of the RPC. Note however that if multiple Changes apply to
 * the same element, the implementation is free to suppress them and
 * deliver just the last one.  The underlying system must provide the
 * guarantee that any relevant update received for an entity E after a
 * client's watch point for E MUST be delivered to that client.
 *<p>
 * These tight guarantees allow for the following simplifications in
 * the client:
 *<p>
 *   (1) The client does not need to have a separate polling loop to
 *       make up for missed updates.
 *<p>
 *   (2) The client does not need to manage timestamps/versions
 *       manually; the last update delivered corresponds to the
 *       eventual state of the entity.
 */
package io.v.v23.services.watch;
