// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.watch;

/**
 * ResumeMarker specifies how much of the existing underlying state
 * is delivered to the client when the watch request is received by
 * the system. The client can set this marker in one of the
 * following ways to get different semantics:
 *<p>
 * (A) Parameter is left empty.
 *     Semantics: Fetch initial state.
 *     The client wants the entities' initial states to be delivered.
 *     See the description in "Initial State".
 *<p>
 * (B) Parameter is set to the string "now" (UTF-8 encoding).
 *     Semantics: Fetch new changes only.
 *     The client just wants to get the changes received by the
 *     system after the watch point. The system may deliver changes
 *     from before the watch point as well.
 *<p>
 * (C) Parameter is set to a value received in an earlier
 *     Change.ResumeMarker field while watching the same entity with
 *     the same query.
 *     Semantics: Resume from a specific point.
 *     The client wants to receive the changes from a specific point
 *     - this value must correspond to a value received in the
 *     Change.ResumeMarker field. The system may deliver changes
 *     from before the ResumeMarker as well.  If the system cannot
 *     resume the stream from this point (e.g., if it is too far
 *     behind in the stream), it can return the
 *     ErrUnknownResumeMarker error.
 *<p>
 * An implementation MUST support the empty string "" marker
 * (initial state fetching) and the "now" marker. It need not
 * support resuming from a specific point.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/watch.ResumeMarker")
public class ResumeMarker extends io.v.v23.vdl.VdlList<java.lang.Byte> {
  private static final long serialVersionUID = 1L;

  /**
   * Vdl type for {@link ResumeMarker}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(ResumeMarker.class);

  /**
   * Creates a new instance of {@link ResumeMarker} with the given underlying value.
   *
   * @param impl underlying value
   */
  public ResumeMarker(java.util.List<java.lang.Byte> impl) {
    super(VDL_TYPE, impl);
  }

  /**
   * Creates a new empty instance of {@link ResumeMarker}.
   */
  public ResumeMarker() {
    this(new java.util.ArrayList<java.lang.Byte>());
  }
}
