// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.watch;

/**
 * Change is the new value for a watched entity.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/watch.Change")
public class Change extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Name", index = 0)
  private java.lang.String name;

  @io.v.v23.vdl.GeneratedFromVdl(name = "State", index = 1)
  private int state;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Value", index = 2)
  private io.v.v23.vdl.VdlAny value;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ResumeMarker", index = 3)
  private io.v.v23.services.watch.ResumeMarker resumeMarker;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Continued", index = 4)
  private boolean continued;

  /**
   * Vdl type for {@link Change}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Change.class);

  /**
   * Creates a new zero-value instance of {@link Change}.
   */
  public Change() {
    super(VDL_TYPE);

    this.name = "";

    this.state = 0;

    this.value = new io.v.v23.vdl.VdlAny();

    this.resumeMarker = new io.v.v23.services.watch.ResumeMarker();

    this.continued = false;
  }

  /**
   * Creates a new instance of {@link Change} with the provided field values.
   */
  public Change(
      java.lang.String name,
      int state,
      io.v.v23.vdl.VdlAny value,
      io.v.v23.services.watch.ResumeMarker resumeMarker,
      boolean continued) {
    super(VDL_TYPE);

    this.name = name;

    this.state = state;

    this.value = value;

    this.resumeMarker = resumeMarker;

    this.continued = continued;
  }

  /**
   * Name is the Object name of the entity that changed.  This name is relative
   * to the root entity (i.e. the name of the Watcher service).
   */
  public java.lang.String getName() {
    return this.name;
  }

  /**
   * Name is the Object name of the entity that changed.  This name is relative
   * to the root entity (i.e. the name of the Watcher service).
   */
  public void setName(java.lang.String name) {
    this.name = name;
  }

  /**
   * State must be one of Exists, DoesNotExist, or InitialStateSkipped.
   */
  public int getState() {
    return this.state;
  }

  /**
   * State must be one of Exists, DoesNotExist, or InitialStateSkipped.
   */
  public void setState(int state) {
    this.state = state;
  }

  /**
   * Value contains the service-specific data for the entity.
   */
  public io.v.v23.vdl.VdlAny getValue() {
    return this.value;
  }

  /**
   * Value contains the service-specific data for the entity.
   */
  public void setValue(io.v.v23.vdl.VdlAny value) {
    this.value = value;
  }

  /**
   * If present, provides a compact representation of all the messages
   * that have been received by the caller for the given Watch call.
   * For example, it could be a sequence number or a multi-part
   * timestamp/version vector. This marker can be provided in the
   * Request message to allow the caller to resume the stream watching
   * at a specific point without fetching the initial state.
   */
  public io.v.v23.services.watch.ResumeMarker getResumeMarker() {
    return this.resumeMarker;
  }

  /**
   * If present, provides a compact representation of all the messages
   * that have been received by the caller for the given Watch call.
   * For example, it could be a sequence number or a multi-part
   * timestamp/version vector. This marker can be provided in the
   * Request message to allow the caller to resume the stream watching
   * at a specific point without fetching the initial state.
   */
  public void setResumeMarker(io.v.v23.services.watch.ResumeMarker resumeMarker) {
    this.resumeMarker = resumeMarker;
  }

  /**
   * If true, this Change is followed by more Changes that are in the
   * same group as this Change.
   */
  public boolean getContinued() {
    return this.continued;
  }

  /**
   * If true, this Change is followed by more Changes that are in the
   * same group as this Change.
   */
  public void setContinued(boolean continued) {
    this.continued = continued;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Change other = (Change) obj;

    if (this.name == null) {
      if (other.name != null) {
        return false;
      }
    } else if (!this.name.equals(other.name)) {
      return false;
    }

    if (this.state != other.state) {
      return false;
    }

    if (this.value == null) {
      if (other.value != null) {
        return false;
      }
    } else if (!this.value.equals(other.value)) {
      return false;
    }

    if (this.resumeMarker == null) {
      if (other.resumeMarker != null) {
        return false;
      }
    } else if (!this.resumeMarker.equals(other.resumeMarker)) {
      return false;
    }

    if (this.continued != other.continued) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.name == null ? 0 : this.name.hashCode());

    result = prime * result + this.state;

    result = prime * result + (this.value == null ? 0 : this.value.hashCode());

    result = prime * result + (this.resumeMarker == null ? 0 : this.resumeMarker.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.continued).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "name:" + this.name;

    result += ", ";

    result += "state:" + this.state;

    result += ", ";

    result += "value:" + this.value;

    result += ", ";

    result += "resumeMarker:" + this.resumeMarker;

    result += ", ";

    result += "continued:" + this.continued;

    return result + "}";
  }
}
