// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  vtrace.vdl
package io.v.v23.services.vtrace;

/**
 * Factory for {@link StoreClient}s.
 */
public final class StoreClientFactory {
  /**
   * Creates a new {@link StoreClient}, binding it to the provided name.
   *
   * @param name name to bind to
   */
  public static StoreClient getStoreClient(java.lang.String name) {
    return getStoreClient(name, null);
  }

  /**
   * Creates a new {@link StoreClient}, binding it to the provided name and using the
   * provided options.  Currently supported options are:
   * <p><ul>
   * <li>{@link io.v.v23.OptionDefs#CLIENT}, which specifies a {@link io.v.v23.rpc.Client} to use for all rpc calls.</li>
   * </ul>
   *
   * @param name name to bind to
   * @param opts creation options
   */
  public static StoreClient getStoreClient(java.lang.String name, io.v.v23.Options opts) {
    io.v.v23.rpc.Client client = null;
    if (opts != null && opts.get(io.v.v23.OptionDefs.CLIENT) != null) {
      client = opts.get(io.v.v23.OptionDefs.CLIENT, io.v.v23.rpc.Client.class);
    }
    return new StoreClientImpl(client, name);
  }

  private StoreClientFactory() {}
}
