// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * SyncgroupSpec contains the specification for a syncgroup.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.SyncgroupSpec")
public class SyncgroupSpec extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Description", index = 0)
  private java.lang.String description;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PublishSyncbaseName", index = 1)
  private java.lang.String publishSyncbaseName;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Perms", index = 2)
  private io.v.v23.security.access.Permissions perms;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Collections", index = 3)
  private java.util.List<io.v.v23.services.syncbase.Id> collections;

  @io.v.v23.vdl.GeneratedFromVdl(name = "MountTables", index = 4)
  private java.util.List<java.lang.String> mountTables;

  @io.v.v23.vdl.GeneratedFromVdl(name = "IsPrivate", index = 5)
  private boolean isPrivate;

  /**
   * Vdl type for {@link SyncgroupSpec}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SyncgroupSpec.class);

  /**
   * Creates a new zero-value instance of {@link SyncgroupSpec}.
   */
  public SyncgroupSpec() {
    super(VDL_TYPE);

    this.description = "";

    this.publishSyncbaseName = "";

    this.perms = new io.v.v23.security.access.Permissions();

    this.collections = new java.util.ArrayList<io.v.v23.services.syncbase.Id>();

    this.mountTables = new java.util.ArrayList<java.lang.String>();

    this.isPrivate = false;
  }

  /**
   * Creates a new instance of {@link SyncgroupSpec} with the provided field values.
   */
  public SyncgroupSpec(
      java.lang.String description,
      java.lang.String publishSyncbaseName,
      io.v.v23.security.access.Permissions perms,
      java.util.List<io.v.v23.services.syncbase.Id> collections,
      java.util.List<java.lang.String> mountTables,
      boolean isPrivate) {
    super(VDL_TYPE);

    this.description = description;

    this.publishSyncbaseName = publishSyncbaseName;

    this.perms = perms;

    this.collections = collections;

    this.mountTables = mountTables;

    this.isPrivate = isPrivate;
  }

  /**
   * Human-readable description of this syncgroup.
   */
  public java.lang.String getDescription() {
    return this.description;
  }

  /**
   * Human-readable description of this syncgroup.
   */
  public void setDescription(java.lang.String description) {
    this.description = description;
  }

  /**
   * Optional. If present, any syncbase that is the admin of this syncgroup
   * is responsible for ensuring that the syncgroup is published to this
   * syncbase instance.
   */
  public java.lang.String getPublishSyncbaseName() {
    return this.publishSyncbaseName;
  }

  /**
   * Optional. If present, any syncbase that is the admin of this syncgroup
   * is responsible for ensuring that the syncgroup is published to this
   * syncbase instance.
   */
  public void setPublishSyncbaseName(java.lang.String publishSyncbaseName) {
    this.publishSyncbaseName = publishSyncbaseName;
  }

  /**
   * Permissions governing access to this syncgroup. Must include at least one
   * admin.
   */
  public io.v.v23.security.access.Permissions getPerms() {
    return this.perms;
  }

  /**
   * Permissions governing access to this syncgroup. Must include at least one
   * admin.
   */
  public void setPerms(io.v.v23.security.access.Permissions perms) {
    this.perms = perms;
  }

  /**
   * Data (set of collectionIds) covered by this syncgroup.
   */
  public java.util.List<io.v.v23.services.syncbase.Id> getCollections() {
    return this.collections;
  }

  /**
   * Data (set of collectionIds) covered by this syncgroup.
   */
  public void setCollections(java.util.List<io.v.v23.services.syncbase.Id> collections) {
    this.collections = collections;
  }

  /**
   * Mount tables at which to advertise this syncgroup, for rendezvous purposes.
   * (Note that in addition to these mount tables, Syncbase also uses
   * network-neighborhood-based discovery for rendezvous.)
   * We expect most clients to specify a single mount table, but we accept an
   * array of mount tables to permit the mount table to be changed over time
   * without disruption.
   * TODO(hpucha): Figure out a convention for advertising syncgroups in the
   * mount table.
   */
  public java.util.List<java.lang.String> getMountTables() {
    return this.mountTables;
  }

  /**
   * Mount tables at which to advertise this syncgroup, for rendezvous purposes.
   * (Note that in addition to these mount tables, Syncbase also uses
   * network-neighborhood-based discovery for rendezvous.)
   * We expect most clients to specify a single mount table, but we accept an
   * array of mount tables to permit the mount table to be changed over time
   * without disruption.
   * TODO(hpucha): Figure out a convention for advertising syncgroups in the
   * mount table.
   */
  public void setMountTables(java.util.List<java.lang.String> mountTables) {
    this.mountTables = mountTables;
  }

  /**
   * Specifies the privacy of this syncgroup. More specifically, specifies
   * whether blobs in this syncgroup can be served to clients presenting
   * blobrefs obtained from other syncgroups.
   */
  public boolean getIsPrivate() {
    return this.isPrivate;
  }

  /**
   * Specifies the privacy of this syncgroup. More specifically, specifies
   * whether blobs in this syncgroup can be served to clients presenting
   * blobrefs obtained from other syncgroups.
   */
  public void setIsPrivate(boolean isPrivate) {
    this.isPrivate = isPrivate;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SyncgroupSpec other = (SyncgroupSpec) obj;

    if (this.description == null) {
      if (other.description != null) {
        return false;
      }
    } else if (!this.description.equals(other.description)) {
      return false;
    }

    if (this.publishSyncbaseName == null) {
      if (other.publishSyncbaseName != null) {
        return false;
      }
    } else if (!this.publishSyncbaseName.equals(other.publishSyncbaseName)) {
      return false;
    }

    if (this.perms == null) {
      if (other.perms != null) {
        return false;
      }
    } else if (!this.perms.equals(other.perms)) {
      return false;
    }

    if (this.collections == null) {
      if (other.collections != null) {
        return false;
      }
    } else if (!this.collections.equals(other.collections)) {
      return false;
    }

    if (this.mountTables == null) {
      if (other.mountTables != null) {
        return false;
      }
    } else if (!this.mountTables.equals(other.mountTables)) {
      return false;
    }

    if (this.isPrivate != other.isPrivate) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.description == null ? 0 : this.description.hashCode());

    result =
        prime * result
            + (this.publishSyncbaseName == null ? 0 : this.publishSyncbaseName.hashCode());

    result = prime * result + (this.perms == null ? 0 : this.perms.hashCode());

    result = prime * result + (this.collections == null ? 0 : this.collections.hashCode());

    result = prime * result + (this.mountTables == null ? 0 : this.mountTables.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.isPrivate).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "description:" + this.description;

    result += ", ";

    result += "publishSyncbaseName:" + this.publishSyncbaseName;

    result += ", ";

    result += "perms:" + this.perms;

    result += ", ";

    result += "collections:" + this.collections;

    result += ", ";

    result += "mountTables:" + this.mountTables;

    result += ", ";

    result += "isPrivate:" + this.isPrivate;

    return result + "}";
  }
}
