// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Wrapper for {@link SyncgroupManagerServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class SyncgroupManagerServerWrapper {
  private final io.v.v23.services.syncbase.SyncgroupManagerServer server;

  /**
   * Creates a new {@link SyncgroupManagerServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public SyncgroupManagerServerWrapper(io.v.v23.services.syncbase.SyncgroupManagerServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.v23.services.syncbase.Id>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "listSyncgroups",
              "// ListSyncgroups returns the relative syncgroup ids of all syncgroups attached to"
                  + "// this database."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.SyncgroupSpec.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.v23.services.syncbase.SyncgroupMemberInfo.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "createSyncgroup",
              "// CreateSyncgroup creates a new syncgroup with the given spec."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database; all"
                  + "// Collections specified in prefixes must exist; Client must have at least"
                  + "// Read access on each of the Collection ACLs."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<java.lang.String>>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.v23.services.syncbase.SyncgroupMemberInfo.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.SyncgroupSpec.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "joinSyncgroup",
              "// JoinSyncgroup joins the syncgroup."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database and on the"
                  + "// syncgroup ACL."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "leaveSyncgroup",
              "// LeaveSyncgroup leaves the syncgroup. Previously synced data will continue"
                  + "// to be available."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "destroySyncgroup",
              "// DestroySyncgroup destroys the syncgroup. Previously synced data will"
                  + "// continue to be available to all members."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database, and must"
                  + "// have Admin access on the syncgroup ACL."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "ejectFromSyncgroup",
              "// EjectFromSyncgroup ejects a member from the syncgroup. The ejected member"
                  + "// will not be able to sync further, but will retain any data it has already"
                  + "// synced."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database, and must"
                  + "// have Admin access on the syncgroup ACL."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.SyncgroupSpec.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getSyncgroupSpec",
              "// GetSyncgroupSpec gets the syncgroup spec. version allows for atomic"
                  + "// read-modify-write of the spec - see comment for SetSyncgroupSpec."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database and on the"
                  + "// syncgroup ACL."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.SyncgroupSpec.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "setSyncgroupSpec",
              "// SetSyncgroupSpec sets the syncgroup spec. version may be either empty or"
                  + "// the value from a previous Get. If not empty, Set will only succeed if the"
                  + "// current version matches the specified one."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database, and must"
                  + "// have Admin access on the syncgroup ACL."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.Map<
                          java.lang.String,
                          io.v.v23.services.syncbase.SyncgroupMemberInfo>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getSyncgroupMembers",
              "// GetSyncgroupMembers gets the info objects for members of the syncgroup."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database and on the"
                  + "// syncgroup ACL."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "SyncgroupManager",
        "io.v.v23.services.syncbase",
        "// SyncgroupManager is the interface for syncgroup operations."
            + "// TODO(hpucha): Add blessings to create/join and add a refresh method."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("createSyncgroup".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"createSyncgroup\": %s", e.getMessage()));
      }
    }

    if ("destroySyncgroup".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"destroySyncgroup\": %s", e.getMessage()));
      }
    }

    if ("ejectFromSyncgroup".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"ejectFromSyncgroup\": %s", e.getMessage()));
      }
    }

    if ("getSyncgroupMembers".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"getSyncgroupMembers\": %s", e.getMessage()));
      }
    }

    if ("getSyncgroupSpec".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getSyncgroupSpec\": %s", e.getMessage()));
      }
    }

    if ("joinSyncgroup".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"joinSyncgroup\": %s", e.getMessage()));
      }
    }

    if ("leaveSyncgroup".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"leaveSyncgroup\": %s", e.getMessage()));
      }
    }

    if ("listSyncgroups".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"listSyncgroups\": %s", e.getMessage()));
      }
    }

    if ("setSyncgroupSpec".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"setSyncgroupSpec\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * ListSyncgroups returns the relative syncgroup ids of all syncgroups attached to
   * this database.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.listSyncgroups(_ctx, _call);
  }

  /**
   * CreateSyncgroup creates a new syncgroup with the given spec.
   *<p>
   * Requires: Client must have at least Read access on the Database; all
   * Collections specified in prefixes must exist; Client must have at least
   * Read access on each of the Collection ACLs.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {

    return this.server.createSyncgroup(_ctx, _call, sgId, spec, myInfo);
  }

  /**
   * JoinSyncgroup joins the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {

    return this
        .server.joinSyncgroup(
            _ctx, _call, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo);
  }

  /**
   * LeaveSyncgroup leaves the syncgroup. Previously synced data will continue
   * to be available.
   *<p>
   * Requires: Client must have at least Read access on the Database.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.Id sgId) {

    return this.server.leaveSyncgroup(_ctx, _call, sgId);
  }

  /**
   * DestroySyncgroup destroys the syncgroup. Previously synced data will
   * continue to be available to all members.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.Id sgId) {

    return this.server.destroySyncgroup(_ctx, _call, sgId);
  }

  /**
   * EjectFromSyncgroup ejects a member from the syncgroup. The ejected member
   * will not be able to sync further, but will retain any data it has already
   * synced.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member) {

    return this.server.ejectFromSyncgroup(_ctx, _call, sgId, member);
  }

  /**
   * GetSyncgroupSpec gets the syncgroup spec. version allows for atomic
   * read-modify-write of the spec - see comment for SetSyncgroupSpec.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerServer.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.Id sgId) {

    return this.server.getSyncgroupSpec(_ctx, _call, sgId);
  }

  /**
   * SetSyncgroupSpec sets the syncgroup spec. version may be either empty or
   * the value from a previous Get. If not empty, Set will only succeed if the
   * current version matches the specified one.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version) {

    return this.server.setSyncgroupSpec(_ctx, _call, sgId, spec, version);
  }

  /**
   * GetSyncgroupMembers gets the info objects for members of the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.Id sgId) {

    return this.server.getSyncgroupMembers(_ctx, _call, sgId);
  }
}
