// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Implementation of the {@link SyncgroupManagerClient} interface.
 */
final class SyncgroupManagerClientImpl
    implements io.v.v23.services.syncbase.SyncgroupManagerClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link SyncgroupManagerClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public SyncgroupManagerClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface SyncgroupManagerClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext _context) {
    return listSyncgroups(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return listSyncgroups(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "listSyncgroups", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.List<io.v.v23.services.syncbase.Id>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.List<io.v.v23.services.syncbase.Id>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.List<io.v.v23.services.syncbase.Id>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.List<io.v.v23.services.syncbase.Id>>() {
                      @Override
                      public java.util.List<io.v.v23.services.syncbase.Id> apply(
                          Object[] _results) {

                        return (java.util.List<io.v.v23.services.syncbase.Id>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {
    return createSyncgroup(_context, sgId, spec, myInfo, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
      io.v.v23.Options _opts) {
    return createSyncgroup(
        _context, sgId, spec, myInfo, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {sgId, spec, myInfo};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.Id.class,
          io.v.v23.services.syncbase.SyncgroupSpec.class,
          io.v.v23.services.syncbase.SyncgroupMemberInfo.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "createSyncgroup", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext _context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {
    return joinSyncgroup(
        _context,
        remoteSyncbaseName,
        expectedSyncbaseBlessings,
        sgId,
        myInfo,
        (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          final io.v.v23.context.VContext _context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.Options _opts) {
    return joinSyncgroup(
        _context,
        remoteSyncbaseName,
        expectedSyncbaseBlessings,
        sgId,
        myInfo,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          final io.v.v23.context.VContext _context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args =
        new java.lang.Object[] {remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          java.lang.String.class,
          new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {}.getType(),
          io.v.v23.services.syncbase.Id.class,
          io.v.v23.services.syncbase.SyncgroupMemberInfo.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "joinSyncgroup", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.services.syncbase.SyncgroupSpec>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.syncbase.SyncgroupSpec>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.services.syncbase.SyncgroupSpec.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.v23.services.syncbase.SyncgroupSpec>() {
                      @Override
                      public io.v.v23.services.syncbase.SyncgroupSpec apply(Object[] _results) {

                        return (io.v.v23.services.syncbase.SyncgroupSpec) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {
    return leaveSyncgroup(_context, sgId, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.Options _opts) {
    return leaveSyncgroup(_context, sgId, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {sgId};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.Id.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "leaveSyncgroup", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {
    return destroySyncgroup(_context, sgId, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.Options _opts) {
    return destroySyncgroup(_context, sgId, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {sgId};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.Id.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "destroySyncgroup", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member) {
    return ejectFromSyncgroup(_context, sgId, member, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member,
      io.v.v23.Options _opts) {
    return ejectFromSyncgroup(
        _context, sgId, member, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {sgId, member};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.Id.class, java.lang.String.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "ejectFromSyncgroup", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {
    return getSyncgroupSpec(_context, sgId, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.Options _opts) {
    return getSyncgroupSpec(_context, sgId, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {sgId};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.Id.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "getSyncgroupSpec", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.services.syncbase.SyncgroupSpec.class, java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[],
                        io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>() {
                      @Override
                      public io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut
                          apply(Object[] _results) {

                        io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut _ret =
                            new io.v.v23.services.syncbase.SyncgroupManagerClient
                                .GetSyncgroupSpecOut();

                        _ret.spec = (io.v.v23.services.syncbase.SyncgroupSpec) _results[0];

                        _ret.version = (java.lang.String) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version) {
    return setSyncgroupSpec(_context, sgId, spec, version, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version,
      io.v.v23.Options _opts) {
    return setSyncgroupSpec(
        _context, sgId, spec, version, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {sgId, spec, version};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.Id.class,
          io.v.v23.services.syncbase.SyncgroupSpec.class,
          java.lang.String.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "setSyncgroupSpec", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {
    return getSyncgroupMembers(_context, sgId, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.Options _opts) {
    return getSyncgroupMembers(_context, sgId, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {sgId};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.Id.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "getSyncgroupMembers", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.Map<
                          java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.Map<
                              java.lang.String,
                              io.v.v23.services.syncbase.SyncgroupMemberInfo>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[],
                        java.util.Map<
                            java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>() {
                      @Override
                      public java.util.Map<
                              java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>
                          apply(Object[] _results) {

                        return (java.util.Map<
                                java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>)
                            _results[0];
                      }
                    });
              }
            }));
  }
}
